/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildOutputParser
implements BuildOutputParser {
    @NotNull
    private static final String DEFAULT_MESSAGE_GROUP = "Android Gradle Plugin warnings";
    @NotNull
    private final Map<Object, Set<String>> futureOutputMap = new HashMap<Object, Set<String>>();
    @NotNull
    private final Set<Object> buildIdsWithAGPErrors = new HashSet<Object>();
    @NotNull
    private final Gson myGson;

    public GradleBuildOutputParser() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        this.myGson = gsonBuilder.create();
    }

    public boolean parse(@NotNull String line2, @NotNull BuildOutputInstantReader reader2, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        String currentLine = line2.trim();
        if (currentLine.startsWith("AGPBI: ")) {
            this.processMessage(currentLine, reader2.getParentEventId(), messageConsumer);
            return true;
        }
        if (currentLine.startsWith("FAILURE: Build failed with an exception.") && this.buildIdsWithAGPErrors.contains(reader2.getParentEventId())) {
            return true;
        }
        if (this.futureOutputMap.getOrDefault(reader2.getParentEventId(), Collections.emptySet()).contains(currentLine)) {
            this.futureOutputMap.get(reader2.getParentEventId()).remove(currentLine);
            return true;
        }
        return false;
    }

    private void processMessage(String line2, Object buildId, @NotNull Consumer<? super MessageEvent> messageConsumer) {
        String jsonString = line2.substring("AGPBI: ".length()).trim();
        if (jsonString.isEmpty()) {
            return;
        }
        try {
            Message msg = (Message)this.myGson.fromJson(jsonString, Message.class);
            Set futureOutput = this.futureOutputMap.computeIfAbsent(buildId, k -> new HashSet());
            if (msg.getKind() == Message.Kind.ERROR) {
                this.buildIdsWithAGPErrors.add(buildId);
            }
            futureOutput.addAll(Arrays.asList(msg.getRawMessage().split("\\n")));
            boolean validPosition = false;
            for (SourceFilePosition sourceFilePosition : msg.getSourceFilePositions()) {
                FilePosition filePosition = GradleBuildOutputParser.convertToFilePosition(sourceFilePosition);
                if (filePosition == null) continue;
                validPosition = true;
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), GradleBuildOutputParser.getMessageGroup(msg), msg.getText(), msg.getRawMessage().isEmpty() ? msg.getText() : msg.getRawMessage(), filePosition));
            }
            if (!validPosition) {
                messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), GradleBuildOutputParser.getMessageGroup(msg), msg.getText(), msg.getRawMessage().isEmpty() ? msg.getText() : msg.getRawMessage()));
            }
        }
        catch (JsonParseException ignored) {
            messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, MessageEvent.Kind.WARNING, GradleBuildOutputParser.getMessageGroup(null), line2, ""));
        }
    }

    @NotNull
    private static String getMessageGroup(@Nullable Message msg) {
        if (msg == null) {
            return DEFAULT_MESSAGE_GROUP;
        }
        String messageGroup = msg.getToolName() == null ? "Android Gradle Plugin" : msg.getToolName();
        switch (msg.getKind()) {
            case WARNING: {
                return messageGroup + " warnings";
            }
            case STATISTICS: {
                return messageGroup + " statistics";
            }
            case SIMPLE: 
            case INFO: {
                return messageGroup + " info";
            }
        }
        return messageGroup + " errors";
    }

    @Contract(pure=true)
    @NotNull
    private static MessageEvent.Kind convertKind(@NotNull Message.Kind kind) {
        switch (kind) {
            case WARNING: {
                return MessageEvent.Kind.WARNING;
            }
            case INFO: {
                return MessageEvent.Kind.INFO;
            }
            case STATISTICS: {
                return MessageEvent.Kind.STATISTICS;
            }
            case SIMPLE: {
                return MessageEvent.Kind.SIMPLE;
            }
        }
        return MessageEvent.Kind.ERROR;
    }

    @Nullable
    private static FilePosition convertToFilePosition(@NotNull SourceFilePosition sourceFilePosition) {
        File sourceFile = sourceFilePosition.getFile().getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        SourcePosition position = sourceFilePosition.getPosition();
        int startLine = position.getStartLine();
        int endLine = position.getEndLine();
        int startColumn = position.getStartColumn();
        int endColumn = position.getEndColumn();
        return new FilePosition(sourceFile, startLine, startColumn, endLine, endColumn);
    }
}

