/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.events;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.build.events.Failure;
import com.intellij.notification.Notification;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSyncFailure {
    @Contract(pure=true)
    @NotNull
    public static Failure create(@NotNull NotificationData data) {
        return AndroidSyncFailure.create(data, "");
    }

    @Contract(pure=true)
    @NotNull
    public static Failure create(final @NotNull NotificationData data, final @NotNull String suffix) {
        return new Failure(){

            @NotNull
            public String getMessage() {
                return data.getTitle();
            }

            @NotNull
            public String getDescription() {
                return data.getMessage() + suffix;
            }

            public List<? extends Failure> getCauses() {
                return null;
            }

            @NotNull
            public Notification getNotification() {
                return new Notification(GradleUtil.GRADLE_SYSTEM_ID.getReadableName() + " sync", data.getTitle(), data.getMessage(), data.getNotificationCategory().getNotificationType()).setListener(data.getListener());
            }

            @Nullable
            public Navigatable getNavigatable() {
                return data.getNavigatable();
            }
        };
    }
}

