/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.attribution;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\r\u001a\u00020\t*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"minimumSupportedAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "buildOutputLine", "", "getAgpAttributionFileDir", "Ljava/io/File;", "requestData", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request$RequestData;", "isAgpVersionHigherOrEqualToMinimal", "", "project", "Lcom/intellij/openapi/project/Project;", "isBuildAttributionEnabledForProject", "higherOrEqualToMinimal", "intellij.android.projectSystem.gradle"})
@JvmName(name="BuildAttributionUtil")
@SourceDebugExtension(value={"SMAP\nBuildAttributionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionUtil.kt\ncom/android/tools/idea/gradle/project/build/attribution/BuildAttributionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1722#2,3:45\n*S KotlinDebug\n*F\n+ 1 BuildAttributionUtil.kt\ncom/android/tools/idea/gradle/project/build/attribution/BuildAttributionUtil\n*L\n34#1:45,3\n*E\n"})
public final class BuildAttributionUtil {
    @NotNull
    private static final AgpVersion minimumSupportedAgpVersion;

    public static final boolean isBuildAttributionEnabledForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuildAttributionUtil.isAgpVersionHigherOrEqualToMinimal(project);
    }

    public static final boolean isAgpVersionHigherOrEqualToMinimal(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List<AgpVersion> list2 = ProjectStructure.getInstance(project).getAndroidPluginVersions().getAllVersions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).and\u2026luginVersions.allVersions");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AgpVersion it = (AgpVersion)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (BuildAttributionUtil.higherOrEqualToMinimal(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean higherOrEqualToMinimal(AgpVersion $this$higherOrEqualToMinimal) {
        return $this$higherOrEqualToMinimal.compareTo(minimumSupportedAgpVersion) >= 0;
    }

    @NotNull
    public static final String buildOutputLine() {
        return "Build Analyzer results available";
    }

    @NotNull
    public static final File getAgpAttributionFileDir(@NotNull GradleBuildInvoker.Request.RequestData requestData) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        return FilesKt.resolve((File)requestData.getRootProjectPath(), (String)".gradle");
    }

    static {
        AgpVersion agpVersion = AgpVersion.Companion.tryParse("4.0.0-beta05");
        Intrinsics.checkNotNull((Object)agpVersion);
        minimumSupportedAgpVersion = agpVersion;
    }
}

