/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SupportedModuleChecker {
    @NotNull
    public static SupportedModuleChecker getInstance() {
        return (SupportedModuleChecker)ApplicationManager.getApplication().getService(SupportedModuleChecker.class);
    }

    public void checkForSupportedModules(@NotNull Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0 || !GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        boolean androidGradleSeen = false;
        for (Module module2 : modules) {
            ModuleType moduleType = ModuleType.get((Module)module2);
            if (!(moduleType instanceof JavaModuleType)) continue;
            String externalSystemId = ExternalSystemModulePropertyManager.getInstance((Module)module2).getExternalSystemId();
            if (!GradleUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) {
                unsupportedModules.add(module2);
                continue;
            }
            androidGradleSeen = true;
        }
        if (!androidGradleSeen || unsupportedModules.isEmpty()) {
            return;
        }
        String moduleNames2 = StringUtil.join(unsupportedModules, Module::getName, (String)", ");
        String text2 = "Compilation is not supported for following modules: " + moduleNames2 + ". Unfortunately you can't have non-Gradle Java modules and Android-Gradle modules in one project.";
        AndroidNotification.getInstance(project).showBalloon("Unsupported Modules Detected", text2, NotificationType.ERROR);
    }
}

