/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.android.tools.idea.gradle.util.ParametersListUtil;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME = "show.do.not.copy.http.proxy.settings.to.gradle";
    private final boolean myShouldShowDialog;
    private JPanel myPane;
    private JTextField myHttpProxyLoginTextField;
    private JCheckBox myHttpProxyAuthCheckBox;
    private PortField myHttpProxyPortTextField;
    private JTextField myHttpProxyHostTextField;
    private RawCommandLineEditor myHttpProxyExceptions;
    private JTextField myHttpsProxyLoginTextField;
    private JCheckBox myHttpsProxyAuthCheckBox;
    private PortField myHttpsProxyPortTextField;
    private JTextField myHttpsProxyHostTextField;
    private RawCommandLineEditor myHttpsProxyExceptions;
    private JCheckBox myEnableHttpsProxyCheckBox;
    private JPanel myHttpsProxyPanel;
    private JTextPane myMessageTextLabel;

    public ProxySettingsDialog(@NotNull Project project, @NotNull ProxySettings httpProxySettings) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(AndroidBundle.message("android.proxy.settings.dialog.title", objectArray));
        this.setOKButtonText("Yes");
        this.setCancelButtonText("No");
        this.myShouldShowDialog = PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME, true);
        this.setDoNotAskOption(new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME));
        this.init();
        this.enableHttpProxyAuth(false);
        this.enableHttpsProxyAuth(false);
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessageTextLabel);
        this.myMessageTextLabel.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        String text2 = AndroidBundle.message("android.proxy.settings.dialog.message", ApplicationNamesInfo.getInstance().getProductName());
        this.myMessageTextLabel.setText(text2);
        this.myHttpProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        this.myHttpProxyExceptions.setText(httpProxySettings.getExceptions());
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpProxyExceptions.setText(ProxySettings.replacePipesWithCommasAndClean(httpProxySettings.getExceptions()));
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpProxyLoginTextField.setText(httpProxySettings.getUser());
            this.enableHttpProxyAuth(true);
        }
        this.myEnableHttpsProxyCheckBox.setSelected(true);
        this.myHttpsProxyHostTextField.setText(httpProxySettings.getHost());
        this.myHttpsProxyPortTextField.setNumber(httpProxySettings.getPort());
        this.myHttpsProxyAuthCheckBox.setSelected(httpProxySettings.getUser() != null);
        if (httpProxySettings.getExceptions() != null) {
            this.myHttpsProxyExceptions.setText(ProxySettings.replacePipesWithCommasAndClean(httpProxySettings.getExceptions()));
        }
        if (httpProxySettings.getUser() != null) {
            this.myHttpsProxyLoginTextField.setText(httpProxySettings.getUser());
            this.enableHttpsProxyAuth(true);
        }
        this.myEnableHttpsProxyCheckBox.addActionListener(e -> {
            Object source = e.getSource();
            if (source == this.myEnableHttpsProxyCheckBox) {
                this.enableHttpsProxy(this.myEnableHttpsProxyCheckBox.isSelected());
            }
        });
        this.myHttpProxyAuthCheckBox.addActionListener(e -> {
            Object source = e.getSource();
            if (source == this.myHttpProxyAuthCheckBox) {
                this.enableHttpProxyAuth(this.myHttpProxyAuthCheckBox.isSelected());
            }
        });
        this.myHttpsProxyAuthCheckBox.addActionListener(e -> {
            Object source = e.getSource();
            if (source == this.myHttpsProxyAuthCheckBox) {
                this.enableHttpsProxyAuth(this.myHttpsProxyAuthCheckBox.isSelected());
            }
        });
    }

    public void show() {
        if (this.myShouldShowDialog) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    public boolean applyProxySettings(@NotNull Properties properties2) {
        boolean needsPassword;
        ProxySettings httpProxySettings = ProxySettingsDialog.createProxySettingsFromUI("http", this.myHttpProxyHostTextField, this.myHttpProxyPortTextField, this.myHttpProxyExceptions, this.myHttpProxyAuthCheckBox, this.myHttpProxyLoginTextField);
        boolean hasHttpPassword = properties2.containsKey("systemProp.http.proxyPassword");
        boolean hasHttpsPassword = properties2.containsKey("systemProp.https.proxyPassword");
        httpProxySettings.setPassword(properties2.getProperty("systemProp.http.proxyPassword"));
        httpProxySettings.applyProxySettings(properties2);
        boolean bl = needsPassword = StringUtil.isNotEmpty((String)httpProxySettings.getUser()) && !hasHttpPassword;
        if (this.myEnableHttpsProxyCheckBox.isSelected()) {
            ProxySettings httpsProxySettings = ProxySettingsDialog.createProxySettingsFromUI("https", this.myHttpsProxyHostTextField, this.myHttpsProxyPortTextField, this.myHttpsProxyExceptions, this.myHttpsProxyAuthCheckBox, this.myHttpsProxyLoginTextField);
            httpsProxySettings.setPassword(properties2.getProperty("systemProp.https.proxyPassword"));
            httpsProxySettings.applyProxySettings(properties2);
            needsPassword |= StringUtil.isNotEmpty((String)httpsProxySettings.getUser()) && !hasHttpsPassword;
        }
        return needsPassword;
    }

    private void createUIComponents() {
        this.myHttpProxyExceptions = new RawCommandLineEditor(ParametersListUtil.COMMA_LINE_PARSER, ParametersListUtil.COMMA_LINE_JOINER);
        this.myHttpsProxyExceptions = new RawCommandLineEditor(ParametersListUtil.COMMA_LINE_PARSER, ParametersListUtil.COMMA_LINE_JOINER);
    }

    @NotNull
    private static ProxySettings createProxySettingsFromUI(@NotNull String proxyType, @NotNull JTextField proxyHostTextField, @NotNull PortField proxyPortTextField, @NotNull RawCommandLineEditor proxyExceptions, @NotNull JCheckBox proxyAuthCheckBox, @NotNull JTextField proxyLoginTextField) {
        ProxySettings proxySettings = new ProxySettings(proxyType);
        proxySettings.setHost(proxyHostTextField.getText());
        proxySettings.setPort(proxyPortTextField.getNumber());
        proxySettings.setExceptions(ProxySettings.replaceCommasWithPipesAndClean(proxyExceptions.getText()));
        if (proxyAuthCheckBox.isSelected()) {
            proxySettings.setUser(proxyLoginTextField.getText());
            proxySettings.setPassword("");
        }
        return proxySettings;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    private void enableHttpsProxy(boolean enabled2) {
        this.myHttpsProxyPanel.setEnabled(enabled2);
        this.myHttpsProxyHostTextField.setEnabled(enabled2);
        this.myHttpsProxyPortTextField.setEnabled(enabled2);
        this.myHttpsProxyExceptions.setEnabled(enabled2);
        this.myHttpsProxyAuthCheckBox.setEnabled(enabled2);
        this.enableHttpsProxyAuth(enabled2 && this.myHttpsProxyAuthCheckBox.isSelected());
    }

    private void enableHttpProxyAuth(boolean enabled2) {
        this.myHttpProxyLoginTextField.setEnabled(enabled2);
    }

    private void enableHttpsProxyAuth(boolean enabled2) {
        this.myHttpsProxyLoginTextField.setEnabled(enabled2);
    }

    @VisibleForTesting
    void setHttpProxyHost(@NotNull String value2) {
        this.myHttpProxyHostTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpPortNumber(int value2) {
        this.myHttpProxyPortTextField.setValue((Object)value2);
    }

    @VisibleForTesting
    void setHttpProxyException(@NotNull String value2) {
        this.myHttpProxyExceptions.setText(value2);
    }

    @VisibleForTesting
    void setHttpProxyAuthenticationEnabled(boolean value2) {
        this.myHttpProxyAuthCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpProxyLogin(@NotNull String value2) {
        this.myHttpProxyLoginTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpsProxyEnabled(boolean value2) {
        this.myEnableHttpsProxyCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpsProxyHost(@NotNull String value2) {
        this.myHttpsProxyHostTextField.setText(value2);
    }

    @VisibleForTesting
    void setHttpsPortNumber(int value2) {
        this.myHttpsProxyPortTextField.setValue((Object)value2);
    }

    @VisibleForTesting
    void setHttpsProxyException(@NotNull String value2) {
        this.myHttpsProxyExceptions.setText(value2);
    }

    @VisibleForTesting
    void setHttpsProxyAuthenticationEnabled(boolean value2) {
        this.myHttpsProxyAuthCheckBox.setSelected(value2);
    }

    @VisibleForTesting
    void setHttpsProxyLogin(@NotNull String value2) {
        this.myHttpsProxyLoginTextField.setText(value2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextPane jTextPane;
        PortField portField;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        PortField portField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel2.setMaximumSize(new Dimension(-1, -1));
        jPanel2.setMinimumSize(new Dimension(735, 555));
        jPanel2.setOpaque(true);
        jPanel2.setPreferredSize(new Dimension(735, 555));
        jPanel2.setRequestFocusEnabled(false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "", 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 6, 6), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "HTTP Proxy", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.host"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1));
        this.myHttpProxyAuthCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.auth"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIBundle").getString("auth.login.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.exclude"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1));
        this.myHttpProxyLoginTextField = jTextField4 = new JTextField();
        jTextField4.setName("httpUser");
        jTextField4.setText("");
        jPanel3.add((Component)jTextField4, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpProxyHostTextField = jTextField3 = new JTextField();
        jTextField3.setName("httpHost");
        jPanel3.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        RawCommandLineEditor rawCommandLineEditor = this.myHttpProxyExceptions;
        rawCommandLineEditor.setDialogCaption("Proxy exceptions");
        rawCommandLineEditor.setName("httpExceptions");
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.port"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        this.myHttpProxyPortTextField = portField2 = new PortField();
        portField2.setName("httpPort");
        jPanel3.add((Component)portField2, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("");
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/UIBundle").getString("auth.password.label"));
        jPanel3.add((Component)jLabel6, new GridConstraints(4, 2, 1, 1, 0, 1, 0, 0, null, null, null, 4));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("<html><b>N/A</b></html>");
        jPanel3.add((Component)jLabel7, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHttpsProxyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 6, 6), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "HTTPS Proxy", 0, 0, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.host"));
        jPanel.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1));
        this.myHttpsProxyAuthCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.auth"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 4, 8, 0, 3, 0, null, null, null, 1));
        JLabel jLabel9 = new JLabel();
        jLabel9.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.exclude"));
        jPanel.add((Component)jLabel9, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 1));
        this.myHttpsProxyLoginTextField = jTextField2 = new JTextField();
        jTextField2.setName("httpsUser");
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpsProxyHostTextField = jTextField = new JTextField();
        jTextField.setName("httpsHost");
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        RawCommandLineEditor rawCommandLineEditor2 = this.myHttpsProxyExceptions;
        rawCommandLineEditor2.setDialogCaption("Proxy exceptions");
        rawCommandLineEditor2.setName("httpsExceptions");
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(2, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/UIBundle").getString("proxy.manual.port"));
        jPanel.add((Component)jLabel10, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        this.myHttpsProxyPortTextField = portField = new PortField();
        portField.setName("httpsPort");
        jPanel.add((Component)portField, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("");
        jPanel.add((Component)jLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messages/UIBundle").getString("auth.password.label"));
        jPanel.add((Component)jLabel12, new GridConstraints(4, 2, 1, 1, 0, 1, 0, 0, null, null, null, 4));
        JLabel jLabel13 = new JLabel();
        jLabel13.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messages/UIBundle").getString("auth.login.label"));
        jPanel.add((Component)jLabel13, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("<html><b>N/A</b></html>");
        jPanel.add((Component)jLabel14, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessageTextLabel = jTextPane = new JTextPane();
        jTextPane.setText("");
        jPanel2.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myEnableHttpsProxyCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable HTTPS Proxy");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("");
        jPanel2.add((Component)jLabel15, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("");
        jPanel2.add((Component)jLabel16, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jTextField4);
        jLabel8.setLabelFor(jTextField);
        jLabel13.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

