/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ProjectStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private AndroidPluginVersionsInProject myPluginVersionsInProject = new AndroidPluginVersionsInProject();
    @NotNull
    private final List<Module> myAppHolderModules = new ArrayList<Module>();
    @NotNull
    private final List<Module> myLeafHolderModules = new ArrayList<Module>();

    @NotNull
    public static ProjectStructure getInstance(@NotNull Project project) {
        return (ProjectStructure)project.getService(ProjectStructure.class);
    }

    private ProjectStructure(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeProjectStructure() {
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List mainModules = Arrays.stream(moduleManager.getModules()).filter(ProjectStructure::isAndroidOrJavaMainSourceSetModuleBySourceSetName).collect(Collectors.toList());
        Set mainModulesAccessibleFromMainModules = mainModules.stream().flatMap(it -> Arrays.stream(ModuleRootManager.getInstance((Module)it).getDependencies())).filter(ProjectStructure::isAndroidOrJavaMainSourceSetModuleBySourceSetName).collect(Collectors.toSet());
        List leafHolderModules = mainModules.stream().filter(it -> !mainModulesAccessibleFromMainModules.contains(it) || ProjectStructure.isAppOrFeature(it)).map(ProjectStructure::getHolder).collect(Collectors.toList());
        List appHolderModules = mainModules.stream().filter(ProjectStructure::isApp).map(ProjectStructure::getHolder).collect(Collectors.toList());
        for (Module module2 : mainModules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null) continue;
            pluginVersionsInProject.add(androidModel);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject = pluginVersionsInProject;
            this.myLeafHolderModules.clear();
            this.myLeafHolderModules.addAll(leafHolderModules);
            this.myAppHolderModules.clear();
            this.myAppHolderModules.addAll(appHolderModules);
        }
    }

    private static boolean isAppOrFeature(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppOrFeature();
    }

    private static boolean isApp(@NotNull Module module2) {
        AndroidModuleSystem.Type projectType = ProjectSystemUtil.getModuleSystem(module2).getType();
        return projectType == AndroidModuleSystem.Type.TYPE_APP || projectType == AndroidModuleSystem.Type.TYPE_INSTANTAPP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AndroidPluginVersionsInProject getAndroidPluginVersions() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPluginVersionsInProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Module> getAppHolderModules() {
        Object object = this.myLock;
        synchronized (object) {
            return ImmutableList.copyOf(this.myAppHolderModules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Module> getLeafHolderModules() {
        Object object = this.myLock;
        synchronized (object) {
            return ImmutableList.copyOf(this.myLeafHolderModules);
        }
    }

    @Nullable
    public static Module getHolder(@NotNull Module module2) {
        String moduleName2;
        int lastDot;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
            return null;
        }
        if ("sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module2)) && (lastDot = (moduleName2 = module2.getName()).lastIndexOf(46)) > 0) {
            String holderModuleName = moduleName2.substring(0, lastDot);
            Module holder = ModuleManager.getInstance((Project)module2.getProject()).findModuleByName(holderModuleName);
            if (holder != null) {
                return holder;
            }
        }
        return module2;
    }

    private static boolean isAndroidOrJavaMainSourceSetModuleBySourceSetName(@NotNull Module module2) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
            return false;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module2))) {
            return false;
        }
        String moduleId = ExternalSystemApiUtil.getExternalProjectId((Module)module2);
        if (moduleId == null) {
            return false;
        }
        return "main".equals(StringsKt.substringAfterLast((String)moduleId, (String)":", (String)""));
    }

    public static boolean isAndroidOrJavaHolderModule(@NotNull Module module2) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
            return false;
        }
        return ExternalSystemApiUtil.getExternalModuleType((Module)module2) == null;
    }

    public static class AndroidPluginVersionsInProject {
        @NotNull
        private final Set<AgpVersion> myAgpVersions = new HashSet<AgpVersion>();

        private void add(@NotNull AndroidModuleModel androidModel) {
            AgpVersion modelVersion = androidModel.getAgpVersion();
            if (modelVersion != null) {
                this.add(modelVersion);
            }
        }

        @VisibleForTesting
        private void add(@NotNull AgpVersion modelVersion) {
            this.myAgpVersions.add(modelVersion);
        }

        @NotNull
        public List<AgpVersion> getAllVersions() {
            return new ArrayList<AgpVersion>(this.myAgpVersions);
        }
    }
}

