/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.AndroidModuleImporter;
import com.android.tools.idea.gradle.project.GradleProjectDependencyParser;
import com.android.tools.idea.gradle.project.GradleSiblingLookup;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleModuleImporter
extends ModuleImporter {
    private final Logger LOG = Logger.getInstance(this.getClass());
    @Nullable
    private final Project myProject;
    private final boolean myIsWizard;

    private GradleModuleImporter(@NotNull WizardContext context2) {
        this(context2.getProject(), true);
    }

    private GradleModuleImporter(@Nullable Project project, boolean isWizard) {
        this.myIsWizard = isWizard;
        this.myProject = project;
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step2) {
        return false;
    }

    @Override
    @NotNull
    public List<? extends ModuleWizardStep> createWizardSteps() {
        return Collections.emptyList();
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects) {
        try {
            GradleModuleImporter.importModules(this, projects, this.myProject, null);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(@NotNull VirtualFile importSource) {
        return GradleProjects.canImportAsGradleProject(importSource) && (this.myIsWizard || this.findModules(importSource).size() == 1);
    }

    @Override
    @NotNull
    public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) {
        assert (this.myProject != null);
        return GradleModuleImporter.getRelatedProjects(importSource, this.myProject);
    }

    @NotNull
    public static Set<ModuleToImport> getRelatedProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        VirtualFile settingsGradle = sourceProject.findFileByRelativePath("settings.gradle");
        if (settingsGradle != null) {
            return GradleModuleImporter.buildModulesSet(GradleModuleImporter.getSubProjects(settingsGradle, destinationProject), GradleProjectDependencyParser.newInstance(destinationProject));
        }
        return GradleModuleImporter.getRequiredProjects(sourceProject, destinationProject);
    }

    @NotNull
    private static Set<ModuleToImport> getRequiredProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        GradleSiblingLookup subProjectLocations = new GradleSiblingLookup(sourceProject, destinationProject);
        Function<VirtualFile, Iterable<String>> parser2 = GradleProjectDependencyParser.newInstance(destinationProject);
        HashMap modules = Maps.newHashMap();
        LinkedList toAnalyze = Lists.newLinkedList();
        toAnalyze.add(sourceProject);
        while (!toAnalyze.isEmpty()) {
            HashSet dependencies2 = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)toAnalyze, parser2)));
            Iterable notAnalyzed = Iterables.filter((Iterable)dependencies2, (Predicate)Predicates.not((Predicate)Predicates.in(modules.keySet())));
            HashMap dependencyToLocation = Maps.newHashMap();
            for (String dependency : notAnalyzed) {
                dependencyToLocation.put(dependency, subProjectLocations.apply(dependency));
            }
            modules.putAll(dependencyToLocation);
            toAnalyze = FluentIterable.from(dependencyToLocation.values()).filter(Predicates.notNull()).toList();
        }
        modules.put(subProjectLocations.getPrimaryProjectName(), sourceProject);
        return GradleModuleImporter.buildModulesSet(modules, parser2);
    }

    @NotNull
    private static Set<ModuleToImport> buildModulesSet(@NotNull Map<String, VirtualFile> modules, @NotNull Function<VirtualFile, Iterable<String>> parser2) {
        HashSet modulesSet = Sets.newHashSetWithExpectedSize((int)modules.size());
        for (Map.Entry<String, VirtualFile> entry : modules.entrySet()) {
            VirtualFile location = entry.getValue();
            Supplier dependencyComputer = location != null ? Suppliers.compose(parser2, (Supplier)Suppliers.ofInstance((Object)location)) : Suppliers.ofInstance((Object)ImmutableSet.of());
            modulesSet.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)dependencyComputer));
        }
        return modulesSet;
    }

    @NotNull
    public static Map<String, VirtualFile> getSubProjects(@NotNull VirtualFile settingsGradle, Project destinationProject) {
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get(settingsGradle, destinationProject);
        Set<String> paths = gradleSettingsModel.modulePaths();
        LinkedHashMap<String, File> allProjects = new LinkedHashMap<String, File>();
        for (String path2 : paths) {
            File projectFile;
            if (path2.equals(":") || (projectFile = gradleSettingsModel.moduleDirectory(path2)) == null) continue;
            allProjects.put(path2, projectFile);
        }
        return Maps.transformValues(allProjects, (Function)new ResolvePath(VfsUtilCore.virtualToIoFile((VirtualFile)settingsGradle.getParent())));
    }

    @VisibleForTesting
    static void importModules(@NotNull Object requestor, @NotNull Map<String, VirtualFile> modules, @Nullable Project project, @Nullable GradleSyncListener listener2) throws IOException {
        String error = GradleModuleImporter.validateProjectsForImport(modules);
        if (error != null) {
            if (listener2 != null && project != null) {
                listener2.syncFailed(project, error);
                return;
            }
            throw new IOException(error);
        }
        assert (project != null);
        WriteCommandAction.writeCommandAction((Project)project).run(() -> GradleModuleImporter.copyAndRegisterModule(requestor, modules, project, listener2));
    }

    @Nullable
    private static String validateProjectsForImport(@NotNull Map<String, VirtualFile> modules) {
        TreeSet<String> projects = new TreeSet<String>();
        for (Map.Entry<String, VirtualFile> mapping : modules.entrySet()) {
            if (mapping.getValue() != null) continue;
            projects.add(mapping.getKey());
        }
        if (projects.isEmpty()) {
            return null;
        }
        if (projects.size() == 1) {
            return String.format("Sources for module '%1$s' were not found", Iterables.getFirst(projects, null));
        }
        String projectsList = Joiner.on((String)"', '").join(projects);
        return String.format("Sources were not found for modules '%1$s'", projectsList);
    }

    private static void copyAndRegisterModule(@NotNull Object requestor, @NotNull Map<String, VirtualFile> modules, @NotNull Project project, @Nullable GradleSyncListener listener2) throws IOException {
        VirtualFile projectRoot = Objects.requireNonNull(ProjectUtil.guessProjectDir((Project)project));
        if (projectRoot.findChild("settings.gradle") == null) {
            projectRoot.createChildData(requestor, "settings.gradle");
        }
        GradleSettingsModel gradleSettingsModel = ProjectBuildModel.get(project).getProjectSettingsModel();
        for (Map.Entry<String, VirtualFile> module2 : modules.entrySet()) {
            String name2 = module2.getKey();
            File targetFile = GradleUtil.getModuleDefaultPath(projectRoot, name2);
            VirtualFile moduleSource = module2.getValue();
            if (moduleSource != null) {
                if (!VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)moduleSource, (boolean)true)) {
                    VirtualFile target2 = VfsUtil.createDirectoryIfMissing((String)targetFile.getAbsolutePath());
                    if (target2 == null) {
                        throw new IOException(String.format("Unable to create directory %1$s", targetFile));
                    }
                    if (target2.exists()) {
                        target2.delete(requestor);
                    }
                    moduleSource.copy(requestor, target2.getParent(), target2.getName());
                } else {
                    targetFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleSource);
                }
            }
            if (gradleSettingsModel == null) continue;
            gradleSettingsModel.addModulePath(name2);
            if (FileUtil.filesEqual((File)GradleUtil.getModuleDefaultPath(projectRoot, name2), (File)targetFile)) continue;
            gradleSettingsModel.setModuleDirectory(name2, targetFile);
        }
        if (gradleSettingsModel == null) {
            Messages.showErrorDialog((Project)project, (String)"Couldn't add new paths to the Gradle settings file, please add them manually", (String)"Gradle Module Import Error");
        } else {
            gradleSettingsModel.applyChanges();
            GradleSyncInvoker.Request request2 = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_IMPORT_MODULES_COPIED);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request2, listener2);
        }
    }

    private static class ResolvePath
    implements Function<File, VirtualFile> {
        private final File mySourceDir;

        ResolvePath(File sourceDir) {
            this.mySourceDir = sourceDir;
        }

        public VirtualFile apply(File path2) {
            if (!path2.isAbsolute()) {
                path2 = new File(this.mySourceDir, path2.getPath());
            }
            return VfsUtil.findFileByIoFile((File)path2, (boolean)true);
        }
    }

    public static class GradleAndroidModuleImporter
    implements AndroidModuleImporter {
        @Override
        @NotNull
        public ModuleImporter create(@NotNull WizardContext context2) {
            return new GradleModuleImporter(context2);
        }
    }
}

