/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.AndroidGradleProjectOpenProcessorKt;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidGradleProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "()V", "name", "", "getName", "()Ljava/lang/String;", "canOpenAsExistingProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canOpenProject", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "promptToCloseIfNecessary", "project", "intellij.android.projectSystem.gradle"})
public final class AndroidGradleProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    public String getName() {
        return "Android Gradle";
    }

    public boolean canOpenProject(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return GradleProjects.canImportAsGradleProject(file2);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile importTarget;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.canOpenProject(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = ProjectImportUtil.findGradleTarget(virtualFile);
        if (virtualFile2 == null) {
            virtualFile2 = virtualFile;
        }
        VirtualFile adjustedOpenTarget = (importTarget = virtualFile2).isDirectory() ? importTarget : importTarget.getParent();
        GradleProjectImporter gradleImporter = GradleProjectImporter.Companion.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)adjustedOpenTarget, (String)"adjustedOpenTarget");
        if (!this.canOpenAsExistingProject(adjustedOpenTarget)) {
            if (!forceOpenInNewFrame && !this.promptToCloseIfNecessary(projectToClose)) {
                return null;
            }
            VirtualFile projectFolder = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)projectFolder, (String)"projectFolder");
            return gradleImporter.importAndOpenProjectCore(projectToClose, forceOpenInNewFrame, projectFolder);
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
        Path path2 = adjustedOpenTarget.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"adjustedOpenTarget.toNioPath()");
        return projectManagerEx.openProject(path2, new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, 12, null));
    }

    private final boolean promptToCloseIfNecessary(Project project) {
        boolean success2 = true;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Project[] openProjects = projectArray;
        if (!(openProjects.length == 0)) {
            int exitCode2 = AndroidGradleProjectOpenProcessorKt.access$confirmOpenNewProject();
            if (exitCode2 == 1) {
                Project toClose;
                Project project2 = toClose = project != null && !project.isDefault() ? project : openProjects[openProjects.length - 1];
                if (!ProjectManagerEx.Companion.getInstanceEx().closeAndDispose(toClose)) {
                    success2 = false;
                }
            } else if (exitCode2 != 0) {
                success2 = false;
            }
        }
        return success2;
    }

    private final boolean canOpenAsExistingProject(VirtualFile file2) {
        return FileExtensions.toVirtualFile(FileExtensions.toPathString(file2).resolve(".idea"), true) != null;
    }
}

