/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.FileEditorUtil;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.generated.file.ro");
    @NotNull
    private final GeneratedSourceFileChangeTracker myGeneratedSourceFileChangeTracker;
    @NotNull
    private final Project myProject;

    public GeneratedFileNotificationProvider(@NotNull Project project) {
        this.myGeneratedSourceFileChangeTracker = GeneratedSourceFileChangeTracker.getInstance((Project)project);
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        GradleAndroidModel androidModel = GradleProjectSystemUtil.findAndroidModelInModule(this.myProject, file2, false);
        if (androidModel == null) {
            return null;
        }
        return this.createNotificationPanel(file2, fileEditor, androidModel);
    }

    @Nullable
    @VisibleForTesting
    public MyEditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull GradleAndroidModel androidModel) {
        if (((Boolean)FileEditorUtil.DISABLE_GENERATED_FILE_NOTIFICATION_KEY.get((UserDataHolder)fileEditor, (Object)false)).booleanValue()) {
            return null;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)buildFolderPath, (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return null;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file2, (boolean)false)) {
            if (this.myGeneratedSourceFileChangeTracker.isEditedGeneratedFile(file2)) {
                return null;
            }
            VirtualFile explodedBundled = buildFolder.findChild("exploded-aar");
            boolean inAar = explodedBundled != null && VfsUtilCore.isAncestor((VirtualFile)explodedBundled, (VirtualFile)file2, (boolean)true);
            String text2 = inAar ? "Resource files inside Android library archive files (.aar) should not be edited" : "Files under the \"build\" folder are generated and should not be edited.";
            return new MyEditorNotificationPanel(fileEditor, text2);
        }
        return null;
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        MyEditorNotificationPanel(@NotNull FileEditor fileEditor, @NotNull String text2) {
            super(fileEditor, EditorNotificationPanel.Status.Warning);
            this.setText(text2);
        }
    }
}

