/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.semantics;

import com.android.tools.idea.gradle.dsl.parser.semantics.ArityHelper;
import com.android.tools.idea.gradle.dsl.parser.semantics.ExternalToModelMap;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertySemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SurfaceSyntaxDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

public final class ModelMapCollector {
    @NotNull
    public static Collector<Object[], ?, ExternalToModelMap> toModelMap(ExternalToModelMap ... parentMaps) {
        Function<Object[], SurfaceSyntaxDescription> surfaceSyntaxDescriptionGetter = data -> {
            String name2 = (String)data[0];
            Integer arity = (Integer)data[1];
            SemanticsDescription description2 = (SemanticsDescription)data[3];
            if (Objects.equals(arity, ArityHelper.property)) {
                if (!(description2 instanceof PropertySemanticsDescription)) {
                    throw new RuntimeException("Dsl setup problem for " + name2 + ": property/semantics description mismatch");
                }
            } else if (!(description2 instanceof MethodSemanticsDescription)) {
                throw new RuntimeException("Dsl setup problem for " + name2 + ": method/semantics description mismatch");
            }
            return new SurfaceSyntaxDescription(name2, arity);
        };
        Function<Object[], ModelEffectDescription> modelEffectDescriptionGetter = data -> {
            ModelPropertyDescription mpd;
            String name2 = (String)data[0];
            Object propertyDescriptionDesignator = data[2];
            SemanticsDescription sd = (SemanticsDescription)data[3];
            if (propertyDescriptionDesignator instanceof String) {
                mpd = new ModelPropertyDescription((String)propertyDescriptionDesignator);
            } else if (propertyDescriptionDesignator instanceof ModelPropertyDescription) {
                mpd = (ModelPropertyDescription)propertyDescriptionDesignator;
            } else {
                throw new RuntimeException("Unrecognized model property description designator for " + name2 + ": " + propertyDescriptionDesignator);
            }
            VersionConstraint vc = ((Object[])data).length == 4 ? null : (VersionConstraint)data[4];
            return new ModelEffectDescription(mpd, sd, vc);
        };
        Function<Object[], VersionConstraint> versionConstraintGetter = data -> ((Object[])data).length == 4 ? null : (VersionConstraint)data[4];
        return Collector.of(LinkedHashSet::new, (s, o) -> s.add(new ExternalToModelMap.Entry((SurfaceSyntaxDescription)surfaceSyntaxDescriptionGetter.apply((Object[])o), (ModelEffectDescription)modelEffectDescriptionGetter.apply((Object[])o), (VersionConstraint)versionConstraintGetter.apply((Object[])o))), (a, b) -> {
            a.addAll(b);
            return a;
        }, s -> {
            for (ExternalToModelMap parentMap : parentMaps) {
                s.addAll(parentMap.getEntrySet());
            }
            return new ExternalToModelMap((Set<ExternalToModelMap.Entry>)s);
        }, new Collector.Characteristics[0]);
    }
}

