/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.InterpolatedText;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleScriptFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslWriter;
import com.android.tools.idea.gradle.dsl.parser.semantics.ExternalToModelMap;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyDslUtil {
    private static final Logger LOG = Logger.getInstance(GroovyDslUtil.class);
    @NotNull
    private static final Set<String> GROOVY_KEYWORDS = new HashSet<String>(Arrays.asList("as", "assert", "break", "case", "catch", "class", "const", "continue", "def", "default", "do", "else", "enum", "extends", "false", "finally", "for", "goto", "if", "implements", "import", "in", "instanceof", "interface", "new", "null", "package", "return", "super", "switch", "this", "throw", "throws", "trait", "true", "try", "while"));
    @NotNull
    private static final Pattern GROOVY_NORMAL_IDENTIFIER = Pattern.compile("(\\p{L}|[_$])(\\p{L}|[0-9]|[_$])*");

    @Nullable
    static GroovyPsiElement ensureGroovyPsi(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof GroovyPsiElement) {
            return (GroovyPsiElement)element2;
        }
        LOG.warn((Throwable)new IllegalArgumentException("Wrong PsiElement type for writer! Must be of type GroovyPsiElement"));
        return null;
    }

    @Nullable
    static GrClosableBlock getClosableBlock(@NotNull PsiElement element2) {
        if (!(element2 instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element2).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    static GroovyPsiElementFactory getPsiElementFactory(@NotNull GradleDslElement element2) {
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element2.getPsiElement());
        if (psiElement == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }

    static String getGradleNameForPsiElement(@NotNull PsiElement element2) {
        final StringBuilder gradleName = new StringBuilder();
        GroovyPsiElementVisitor visitor2 = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression e) {
                if (e.getText().startsWith("project") && e.getArgumentList().getAllArguments().length == 1 && e.getArgumentList().getAllArguments()[0] instanceof GrLiteral) {
                    gradleName.append(e.getText().replaceAll("\\s", "").replace("\"", "'"));
                }
            }
        });
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof GrMethodCallExpression) {
                child.accept((PsiElementVisitor)visitor2);
                continue;
            }
            gradleName.append(child.getText());
        }
        return gradleName.length() == 0 ? element2.getText() : gradleName.toString();
    }

    static void maybeDeleteIfEmpty(@Nullable PsiElement element2, @NotNull GradleDslElement dslElement) {
        GradleDslElement parentDslElement = dslElement.getParent();
        if ((parentDslElement instanceof GradleDslExpressionList && !((GradleDslExpressionList)parentDslElement).shouldBeDeleted() || parentDslElement instanceof GradleDslExpressionMap && !((GradleDslExpressionMap)parentDslElement).shouldBeDeleted()) && parentDslElement.getPsiElement() == element2) {
            return;
        }
        GroovyDslUtil.deleteIfEmpty(element2, dslElement);
    }

    private static void deleteIfEmpty(@Nullable PsiElement element2, @NotNull GradleDslElement containingDslElement) {
        if (element2 == null) {
            return;
        }
        PsiElement parent2 = element2.getParent();
        GradleDslElement dslParent = SharedParserUtilsKt.getNextValidParent(containingDslElement);
        if (element2.isValid()) {
            if (element2 instanceof GrAssignmentExpression) {
                if (((GrAssignmentExpression)element2).getRValue() == null) {
                    element2.delete();
                }
            } else if (element2 instanceof GrApplicationStatement) {
                if (((GrApplicationStatement)element2).getArgumentList() == null) {
                    element2.delete();
                }
            } else if (element2 instanceof GrClosableBlock) {
                if (dslParent == null || dslParent.isInsignificantIfEmpty()) {
                    final Boolean[] isEmpty = new Boolean[]{true};
                    ((GrClosableBlock)element2).acceptChildren(new GroovyElementVisitor(){

                        public void visitElement(@NotNull GroovyPsiElement child) {
                            if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                                return;
                            }
                            isEmpty[0] = false;
                        }
                    });
                    if (isEmpty[0].booleanValue()) {
                        element2.delete();
                    }
                }
            } else if (element2 instanceof GrMethodCallExpression) {
                GrMethodCallExpression call = (GrMethodCallExpression)element2;
                GrArgumentList argumentList = null;
                for (PsiElement curr = call.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    if (!(curr instanceof GrArgumentList)) continue;
                    argumentList = (GrArgumentList)curr;
                    break;
                }
                GrClosableBlock[] closureArguments = call.getClosureArguments();
                if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                    element2.delete();
                }
            } else if (element2 instanceof GrArgumentList) {
                GrArgumentList argumentList = (GrArgumentList)element2;
                if (!(argumentList.getAllArguments().length != 0 || parent2 instanceof GrMethodCallExpression && ((GrMethodCallExpression)parent2).hasClosureArguments())) {
                    argumentList.delete();
                }
            } else if (element2 instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)element2;
                if (namedArgument.getExpression() == null) {
                    namedArgument.delete();
                }
            } else if (element2 instanceof GrVariableDeclaration) {
                GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)element2;
                for (GrVariable grVariable : variableDeclaration.getVariables()) {
                    if (grVariable.getInitializerGroovy() != null) continue;
                    grVariable.delete();
                }
                if (variableDeclaration.getVariables().length == 0) {
                    variableDeclaration.delete();
                }
            } else if (element2 instanceof GrVariable) {
                GrVariable variable = (GrVariable)element2;
                if (variable.getInitializerGroovy() == null) {
                    variable.delete();
                }
            } else if (element2 instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)element2;
                if (listOrMap.isMap() && listOrMap.getNamedArguments().length == 0) {
                    listOrMap.delete();
                } else if (!listOrMap.isMap() && listOrMap.getInitializers().length == 0) {
                    listOrMap.delete();
                }
            }
        }
        if (!element2.isValid()) {
            GroovyDslUtil.handleElementRemoved(parent2, element2);
            if (dslParent != null) {
                if (element2 == dslParent.getPsiElement() && dslParent.isInsignificantIfEmpty()) {
                    GroovyDslUtil.maybeDeleteIfEmpty(parent2, dslParent);
                } else {
                    GroovyDslUtil.maybeDeleteIfEmpty(parent2, containingDslElement);
                }
            }
        }
    }

    static void handleElementRemoved(@Nullable PsiElement psiElement, @Nullable PsiElement removed) {
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)psiElement;
            if (removed instanceof GrNamedArgument && listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOLON, (CharSequence)":", listOrMap.getRBrack().getNode());
            }
        }
    }

    @Nullable
    static GrExpression extractUnsavedExpression(@NotNull GradleDslSettableExpression literal) {
        GroovyPsiElement newElement = GroovyDslUtil.ensureGroovyPsi(literal.getUnsavedValue());
        if (!(newElement instanceof GrExpression)) {
            return null;
        }
        return (GrExpression)newElement;
    }

    private static String escapeString(@NotNull String str, boolean forGString) {
        StringBuilder sb = new StringBuilder();
        GrStringUtil.escapeStringCharacters((int)str.length(), (CharSequence)str, (String)(forGString ? "\"" : "'"), (boolean)true, (boolean)true, (StringBuilder)sb);
        return sb.toString();
    }

    @Nullable
    static PsiElement createLiteral(@NotNull GradleDslSimpleExpression context2, @NotNull GradleDslFile applyContext, @NotNull Object unsavedValue) {
        String unsavedValueText = null;
        if (unsavedValue instanceof String) {
            String stringValue = (String)unsavedValue;
            if (StringUtil.isQuotedString((String)stringValue)) {
                String unquotedString = GrStringUtil.removeQuotes((String)stringValue);
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString(unquotedString, true), (boolean)true);
            } else {
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString((String)unsavedValue, false), (boolean)false);
            }
        } else if (unsavedValue instanceof Integer || unsavedValue instanceof Boolean || unsavedValue instanceof BigDecimal) {
            unsavedValueText = unsavedValue.toString();
        } else if (unsavedValue instanceof ReferenceTo) {
            unsavedValueText = GroovyDslUtil.convertToExternalTextValue(((ReferenceTo)unsavedValue).getReferredElement(), context2, applyContext, false);
            if (unsavedValueText == null) {
                unsavedValueText = ((ReferenceTo)unsavedValue).getReferredElement().getFullName();
            }
        } else if (unsavedValue instanceof InterpolatedText) {
            InterpolatedText interpolatedValue = (InterpolatedText)unsavedValue;
            StringBuilder builder2 = new StringBuilder();
            for (InterpolatedText.InterpolatedTextItem elem : interpolatedValue.getInterpolationElements()) {
                if (elem.getTextItem() != null) {
                    builder2.append(elem.getTextItem());
                }
                if (elem.getReferenceItem() == null) continue;
                String externalText = GroovyDslUtil.convertToExternalTextValue(elem.getReferenceItem().getReferredElement(), context2, applyContext, true);
                builder2.append(externalText != null ? externalText : elem.getReferenceItem().getReferredElement().getFullName());
            }
            unsavedValueText = GrStringUtil.addQuotes((String)builder2.toString(), (boolean)true);
        } else if (unsavedValue instanceof RawText) {
            unsavedValueText = ((RawText)unsavedValue).getGroovyText();
        }
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory2 = GroovyDslUtil.getPsiElementFactory(applyContext);
        if (factory2 == null) {
            return null;
        }
        return factory2.createExpressionFromText((CharSequence)unsavedValueText);
    }

    public static String convertToExternalTextValue(GradleDslSimpleExpression context2, GradleDslFile applyContext, String referenceText, boolean forInjection) {
        GradleDslElement referenceElement = context2.resolveInternalSyntaxReference(referenceText, false);
        if (referenceElement == null) {
            return referenceText;
        }
        String externalReference = GroovyDslUtil.convertToExternalTextValue(referenceElement, context2, applyContext, forInjection);
        return externalReference != null ? externalReference : referenceText;
    }

    public static String convertToExternalTextValue(GradleDslElement referenceElement, GradleDslSimpleExpression context2, GradleDslFile applyContext, boolean forInjection) {
        StringBuilder externalName = new StringBuilder();
        GradleDslElement currentParent = referenceElement.getParent();
        HashSet<GradleDslElement> contextParents = new HashSet<GradleDslElement>(10);
        for (GradleDslElement contextParent = context2.getParent(); contextParent != null && !(contextParent instanceof GradleDslFile); contextParent = contextParent.getParent()) {
            contextParents.add(contextParent);
        }
        ArrayList<GradleDslElement> resolutionElements = new ArrayList<GradleDslElement>();
        resolutionElements.add(referenceElement);
        while (currentParent != null && currentParent.getParent() != null && !contextParents.contains(currentParent)) {
            resolutionElements.add(0, currentParent);
            currentParent = currentParent.getParent();
        }
        if (currentParent instanceof GradleVersionCatalogFile && context2.getDslFile() instanceof GradleScriptFile) {
            externalName.append(((GradleVersionCatalogFile)currentParent).getCatalogName()).append(".");
            if (resolutionElements.size() > 0 && "libraries".equals(((GradleDslElement)resolutionElements.get(0)).getName())) {
                resolutionElements.remove(0);
            }
        }
        for (GradleDslElement currentElement : resolutionElements) {
            List<String> elementExternalNameParts = applyContext.getParser().externalNameForParent((String)currentElement.getName(), (GradleDslElement)currentElement.getParent()).externalNameParts;
            if (currentElement.getDslFile() instanceof GradleVersionCatalogFile) {
                externalName.append(String.join((CharSequence)".", elementExternalNameParts.get(0).split("[_.-]")));
            } else if (currentElement.getParent() instanceof GradleDslExpressionList && currentElement instanceof GradleDslSimpleExpression) {
                GradleDslExpressionList parent2 = (GradleDslExpressionList)currentElement.getParent();
                int i = parent2.getSimpleExpressions().indexOf(currentElement);
                externalName.append(i + "]");
            } else if (!(currentElement instanceof ExtDslElement) && !(currentElement instanceof BuildScriptDslElement)) {
                externalName.append(GroovyDslUtil.quotePartIfNecessary(elementExternalNameParts.get(0)));
            }
            if (currentElement == referenceElement) continue;
            if (currentElement instanceof GradleDslExpressionList) {
                externalName.append("[");
                continue;
            }
            if (currentElement instanceof ExtDslElement || currentElement instanceof BuildScriptDslElement) continue;
            externalName.append(".");
        }
        if (externalName.length() == 0) {
            return null;
        }
        if (!forInjection) {
            return externalName.toString();
        }
        Pattern varShouldNotBeWrapped = Pattern.compile("(([a-zA-Z0-9_]\\w*)(\\.([a-zA-Z0-9_]\\w+))*)");
        if (varShouldNotBeWrapped.matcher(externalName.toString()).matches()) {
            return "$" + externalName.toString();
        }
        return "${" + externalName.toString() + "}";
    }

    public static boolean isStringLiteral(@NotNull PsiElement element2) {
        ASTNode node = GroovyDslUtil.getFirstASTNode(element2);
        if (node == null) {
            return false;
        }
        return TokenSets.STRING_LITERAL_SET.contains(node.getElementType());
    }

    public static boolean decodeStringLiteral(@NotNull PsiElement element2, @NotNull StringBuilder sb) {
        String contents = GrStringUtil.removeQuotes((String)element2.getText());
        IElementType elementType = element2.getFirstChild().getNode().getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(elementType) || elementType == GroovyTokenTypes.mGSTRING_CONTENT) {
            return GrStringUtil.parseStringCharacters((String)contents, (StringBuilder)sb, null);
        }
        if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mREGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters((String)contents, (StringBuilder)sb, null, (boolean)true);
        }
        if (elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters((String)contents, (StringBuilder)sb, null, (boolean)false);
        }
        return false;
    }

    public static String gradleNameFor(GrExpression expression2) {
        final boolean[] allValid = new boolean[]{true};
        final StringBuilder result2 = new StringBuilder();
        expression2.accept((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                String name2;
                GrExpression qualifierExpression = referenceExpression.getQualifierExpression();
                if (qualifierExpression != null) {
                    qualifierExpression.accept((GroovyElementVisitor)this);
                    result2.append(".");
                }
                if ((name2 = referenceExpression.getReferenceName()) != null) {
                    result2.append(GradleNameElement.escape(name2));
                } else {
                    allValid[0] = false;
                }
            }

            public void visitIndexProperty(@NotNull GrIndexProperty indexPropertyExpression) {
                GrExpression invokedExpression = indexPropertyExpression.getInvokedExpression();
                invokedExpression.accept((GroovyElementVisitor)this);
                result2.append("[");
                GrArgumentList argumentList = indexPropertyExpression.getArgumentList();
                GroovyPsiElement[] arguments2 = argumentList.getAllArguments();
                if (arguments2.length != 1) {
                    allValid[0] = false;
                    return;
                }
                result2.append(arguments2[0].getText());
                result2.append("]");
            }

            public void visitElement(@NotNull GroovyPsiElement element2) {
                allValid[0] = false;
            }
        }));
        return allValid[0] ? result2.toString() : null;
    }

    static PsiElement createDerivedMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement parentPsiElement = GroovyDslUtil.getParentPsi(expressionMap);
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression emptyMap = factory2.createExpressionFromText((CharSequence)"[:]");
        GrNamedArgument namedArgument = factory2.createNamedArgument(expressionMap.getName(), emptyMap);
        PsiElement addedElement = GroovyDslUtil.addToMap((GrListOrMap)parentPsiElement, namedArgument);
        if (addedElement instanceof GrNamedArgument) {
            GrExpression added = ((GrNamedArgument)addedElement).getExpression();
            expressionMap.setPsiElement((PsiElement)added);
            return added;
        }
        LOG.warn("Unexpected result of addToMap: " + addedElement);
        return null;
    }

    @Nullable
    private static PsiElement realAddBefore(@NotNull GrListOrMap element2, @NotNull PsiElement newElement, @NotNull PsiElement anchor) {
        CheckUtil.checkWritable((PsiElement)element2);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)newElement);
        ASTNode anchorNode = GroovyDslUtil.getAnchorNode((PsiElement)element2, anchor.getNode(), true);
        ASTNode newNode = CodeEditUtil.addChildren((ASTNode)element2.getNode(), (ASTNode)elementCopy, (ASTNode)elementCopy, (ASTNode)anchorNode);
        if (newNode == null) {
            LOG.warn((Throwable)new IncorrectOperationException("Element cannot be added"));
            return null;
        }
        if (newNode instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)((TreeElement)newNode)).getPsi();
        }
        return newNode.getPsi();
    }

    private static ASTNode getAnchorNode(@NotNull PsiElement element2, ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? element2.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }

    @Nullable
    static PsiElement addToMap(@NotNull GrListOrMap map2, @NotNull GrNamedArgument newValue) {
        ASTNode astNode = map2.getNode();
        if (map2.getNamedArguments().length != 0) {
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", map2.getRBrack().getNode());
        } else {
            while (map2.getLBrack().getNextSibling() != map2.getRBrack()) {
                map2.getLBrack().getNextSibling().delete();
            }
        }
        return GroovyDslUtil.realAddBefore(map2, (PsiElement)newValue, map2.getRBrack());
    }

    @Nullable
    static PsiElement processListElement(@NotNull GradleDslSettableExpression expression2) {
        GradleDslElement parent2 = expression2.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement parentPsi = parent2.create();
        if (parentPsi == null) {
            return null;
        }
        PsiElement newExpressionPsi = expression2.getUnsavedValue();
        if (newExpressionPsi == null) {
            return null;
        }
        PsiElement added = GroovyDslUtil.createPsiElementInsideList(parent2, expression2, parentPsi, newExpressionPsi);
        expression2.setPsiElement(added);
        expression2.commit();
        return expression2.getPsiElement();
    }

    @Nullable
    static PsiElement processMapElement(@NotNull GradleDslSettableExpression expression2) {
        PsiElement added;
        GradleDslElement parent2 = expression2.getParent();
        assert (parent2 != null);
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent2.create());
        if (parentPsiElement == null) {
            return null;
        }
        expression2.setPsiElement((PsiElement)parentPsiElement);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression2);
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory2.createNamedArgument(expression2.getName(), newLiteral);
        if (parentPsiElement instanceof GrCommandArgumentList) {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else if (parentPsiElement instanceof GrArgumentList) {
            added = ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument);
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap grListOrMap = (GrListOrMap)parentPsiElement;
            added = GroovyDslUtil.addToMap(grListOrMap, namedArgument);
        } else {
            added = parentPsiElement.addBefore((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            GrExpression grExpression = (GrExpression)PsiTreeUtil.getChildOfType((PsiElement)addedNameArgument, GrExpression.class);
            if (grExpression != null) {
                expression2.setExpression((PsiElement)grExpression);
                expression2.commit();
                expression2.reset();
                return expression2.getPsiElement();
            }
            return null;
        }
        LOG.warn((Throwable)new IllegalStateException("Unexpected element type added to map: " + added));
        return null;
    }

    static PsiElement createInfixElement(@NotNull GradleDslSettableExpression expression2) {
        GradleDslElement parent2 = expression2.getParent();
        if (!(parent2 instanceof GradleDslInfixExpression)) {
            return null;
        }
        GradleDslInfixExpression infixExpression = (GradleDslInfixExpression)parent2;
        PsiElement parentPsi = parent2.create();
        if (parentPsi == null) {
            return null;
        }
        PsiElement expressionPsi = expression2.getUnsavedValue();
        if (expressionPsi == null) {
            return null;
        }
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parentPsi.getProject());
        String expressionText = parentPsi.getText() + " " + expression2.getName() + " " + expressionPsi.getText();
        GrExpression newInfixExpression = factory2.createExpressionFromText((CharSequence)expressionText);
        PsiElement newParentPsi = parentPsi.replace((PsiElement)newInfixExpression);
        parent2.setPsiElement(newParentPsi);
        expression2.setPsiElement(newParentPsi.getLastChild().getLastChild());
        expression2.commit();
        expression2.reset();
        return expression2.getPsiElement();
    }

    static void applyDslLiteralOrReference(@NotNull GradleDslSettableExpression expression2, GroovyDslWriter writer2) {
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(expression2.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyDslUtil.maybeUpdateName(expression2, writer2);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression2);
        if (newLiteral == null) {
            return;
        }
        GroovyPsiElement psiExpression = GroovyDslUtil.ensureGroovyPsi(expression2.getExpression());
        if (psiExpression != null) {
            PsiElement replace2 = psiExpression.replace((PsiElement)newLiteral);
            if (replace2 instanceof GrLiteral || replace2 instanceof GrReferenceExpression || replace2 instanceof GrIndexProperty) {
                expression2.setExpression(replace2);
            }
        } else {
            PsiElement added;
            if (psiElement instanceof GrApplicationStatement) {
                GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
                GrApplicationStatement fakeStatement = (GrApplicationStatement)factory2.createStatementFromText((CharSequence)"a 'a'");
                GrCommandArgumentList arguments2 = fakeStatement.getArgumentList();
                arguments2.getFirstChild().delete();
                psiElement.addAfter((PsiElement)arguments2, psiElement.getLastChild());
                added = ((GrApplicationStatement)psiElement).getArgumentList().add((PsiElement)newLiteral);
            } else {
                added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            }
            expression2.setExpression(added);
            if (expression2.getUnsavedClosure() != null) {
                GroovyDslUtil.createAndAddClosure(expression2.getUnsavedClosure(), expression2);
            }
        }
        expression2.reset();
        expression2.commit();
    }

    @Nullable
    static PsiElement createNamedArgumentList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement added;
        GradleDslElement parent2 = expressionList.getParent();
        assert (parent2 instanceof GradleDslExpressionMap);
        PsiElement parentPsiElement = parent2.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory2.createExpressionFromText((CharSequence)"[]");
        GrNamedArgument namedArgument = factory2.createNamedArgument(expressionList.getName(), expressionFromText);
        if (parentPsiElement instanceof GrArgumentList) {
            GrArgumentList argList = (GrArgumentList)parentPsiElement;
            argList.addNamedArgument(namedArgument);
            GrNamedArgument[] args = argList.getNamedArguments();
            added = args[args.length - 1];
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)parentPsiElement;
            if (!listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", listOrMap.getLBrack().getNextSibling().getNode());
            }
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            expressionList.setPsiElement((PsiElement)addedNameArgument.getExpression());
            return expressionList.getPsiElement();
        }
        return null;
    }

    @Nullable
    static PsiElement createMethodCallArgumentList(@NotNull GradleDslExpressionList expressionList) {
        GradleDslElement parent2 = expressionList.getParent();
        assert (parent2 instanceof GradleDslMethodCall);
        PsiElement parentPsiElement = parent2.create();
        if (parentPsiElement == null) {
            return null;
        }
        if (parentPsiElement instanceof GrMethodCallExpression) {
            return ((GrMethodCallExpression)parentPsiElement).getArgumentList();
        }
        return null;
    }

    @Nullable
    static String getInjectionName(@NotNull GrStringInjection injection) {
        String variableName = null;
        GrClosableBlock closableBlock = injection.getClosableBlock();
        if (closableBlock != null) {
            String blockText = closableBlock.getText();
            variableName = blockText.substring(1, blockText.length() - 1);
        } else {
            GrExpression expression2 = injection.getExpression();
            if (expression2 != null) {
                variableName = expression2.getText();
            }
        }
        return variableName;
    }

    @NotNull
    static String ensureUnquotedText(@NotNull String str) {
        if (StringUtil.isQuotedString((String)str)) {
            str = StringUtil.unquoteString((String)str);
        }
        return str;
    }

    @Nullable
    static PsiElement getParentPsi(@NotNull GradleDslElement element2) {
        GradleDslElement parent2 = element2.getParent();
        if (parent2 == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent2.create());
        if (parentPsiElement == null) {
            return null;
        }
        return parentPsiElement;
    }

    static boolean shouldAddToListInternal(@NotNull GradleDslElement element2) {
        GradleDslElement parent2 = element2.getParent();
        if (!(parent2 instanceof GradleDslExpressionList)) {
            return false;
        }
        PsiElement parentPsi = parent2.getPsiElement();
        return parentPsi instanceof GrListOrMap && ((GrListOrMap)parentPsi).getInitializers().length > 0 || parentPsi instanceof GrArgumentList && ((GrArgumentList)parentPsi).getAllArguments().length > 0;
    }

    static void emplaceElementIntoList(@NotNull PsiElement anchorBefore, @NotNull PsiElement list2, @NotNull PsiElement newElement) {
        ASTNode node = list2.getNode();
        ASTNode anchor = anchorBefore.getNode().getTreeNext();
        node.addChild(newElement.getNode(), anchor);
        node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", newElement.getNode());
    }

    static PsiElement emplaceElementToFrontOfList(@NotNull PsiElement listElement, @NotNull PsiElement newElement) {
        assert (listElement instanceof GrListOrMap || listElement instanceof GrArgumentList);
        ASTNode node = listElement.getNode();
        if (listElement instanceof GrListOrMap) {
            GrListOrMap list2 = (GrListOrMap)listElement;
            ASTNode anchor = list2.getLBrack().getNode().getTreeNext();
            if (!list2.isEmpty()) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list2.getLBrack().getNode().getTreeNext());
        } else if (((GrArgumentList)listElement).getLeftParen() != null) {
            GrArgumentList list3 = (GrArgumentList)listElement;
            PsiElement leftParen = list3.getLeftParen();
            assert (leftParen != null);
            ASTNode anchor = list3.getLeftParen().getNode().getTreeNext();
            if (list3.getAllArguments().length != 0) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list3.getLeftParen().getNode().getTreeNext());
        } else {
            ASTNode anchor = GroovyDslUtil.getFirstASTNode(listElement);
            if (anchor != null) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), GroovyDslUtil.getFirstASTNode(listElement));
        }
        return newElement;
    }

    @Nullable
    static ASTNode getFirstASTNode(@NotNull PsiElement parent2) {
        PsiElement firstChild = parent2.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        return firstChild.getNode();
    }

    @NotNull
    static PsiElement createPsiElementInsideList(@NotNull GradleDslElement parentDslElement, @NotNull GradleDslElement dslElement, @NotNull PsiElement parentPsiElement, @NotNull PsiElement newElement) {
        PsiElement added;
        GradleDslElement anchor = parentDslElement.requestAnchor(dslElement);
        if (GroovyDslUtil.shouldAddToListInternal(dslElement) && anchor != null) {
            PsiElement anchorPsi = anchor.getPsiElement();
            assert (anchorPsi != null);
            GroovyDslUtil.emplaceElementIntoList(anchorPsi, parentPsiElement, newElement);
            added = newElement;
        } else {
            added = GroovyDslUtil.emplaceElementToFrontOfList(parentPsiElement, newElement);
        }
        return added;
    }

    @NotNull
    static String quotePartIfNecessary(String part) {
        if (!GROOVY_NORMAL_IDENTIFIER.matcher(part).matches()) {
            return "'" + part + "'";
        }
        if (GROOVY_KEYWORDS.contains(part)) {
            return "'" + part + "'";
        }
        return part;
    }

    @NotNull
    public static String quotePartsIfNecessary(@NotNull List<String> parts) {
        StringBuilder sb = new StringBuilder();
        boolean firstPart = true;
        for (String part : parts) {
            if (!firstPart) {
                sb.append('.');
            } else {
                firstPart = false;
            }
            sb.append(GroovyDslUtil.quotePartIfNecessary(part));
        }
        return sb.toString();
    }

    @NotNull
    static String quotePartsIfNecessary(@NotNull ExternalNameInfo info2) {
        List<String> parts = info2.externalNameParts;
        if (info2.verbatim) {
            return String.join((CharSequence)".", parts);
        }
        return GroovyDslUtil.quotePartsIfNecessary(parts);
    }

    @Nullable
    static PsiElement createNameElement(@NotNull GradleDslElement context2, @NotNull String name2) {
        GroovyPsiElementFactory factory2 = GroovyDslUtil.getPsiElementFactory(context2);
        if (factory2 == null) {
            return null;
        }
        String str = name2 + " 1";
        GrExpression expression2 = factory2.createExpressionFromText((CharSequence)str);
        if (expression2 instanceof GrApplicationStatement) {
            return ((GrApplicationStatement)expression2).getInvokedExpression();
        }
        return null;
    }

    static void maybeUpdateName(@NotNull GradleDslElement element2, GroovyDslWriter writer2) {
        PsiNamedElement newElement;
        GradleNameElement nameElement = element2.getNameElement();
        String localName = nameElement.getLocalName();
        if (localName == null || localName.isEmpty()) {
            return;
        }
        if (localName.equals(nameElement.getOriginalName())) {
            return;
        }
        PsiElement oldName = element2.getNameElement().getNamedPsiElement();
        if (oldName == null) {
            return;
        }
        GradleDslElement parent2 = element2.getParent();
        if (parent2 != null) {
            Set<ExternalToModelMap.Entry> modelEntries = parent2.getExternalToModelMap(writer2).getEntrySet();
            for (ExternalToModelMap.Entry entry : modelEntries) {
                if (!entry.modelEffectDescription.property.name.equals(nameElement.getOriginalName())) continue;
                LOG.warn((Throwable)new UnsupportedOperationException("trying to update a property: " + nameElement.getOriginalName()));
                return;
            }
        }
        String newName2 = GradleNameElement.unescape(localName);
        if (oldName instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)oldName;
            namedElement.setName(newName2);
            newElement = namedElement;
        } else {
            PsiElement psiElement = GroovyDslUtil.createNameElement(element2, GroovyDslUtil.quotePartIfNecessary(newName2));
            if (psiElement == null) {
                return;
            }
            newElement = oldName.replace(psiElement);
        }
        element2.getNameElement().commitNameChange((PsiElement)newElement, writer2, element2.getParent());
    }

    @Nullable
    static PsiElement getPsiElementForAnchor(@NotNull PsiElement parent2, @Nullable GradleDslElement dslAnchor) {
        PsiElement anchorAfter;
        PsiElement psiElement = anchorAfter = dslAnchor == null ? null : SharedParserUtilsKt.findLastPsiElementIn(dslAnchor);
        if (anchorAfter == null && parent2 instanceof GrClosableBlock) {
            return GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent2);
        }
        while (anchorAfter != null && !(anchorAfter instanceof PsiFile) && anchorAfter.getParent() != parent2) {
            anchorAfter = anchorAfter.getParent();
        }
        return anchorAfter instanceof PsiFile ? (parent2 instanceof GrClosableBlock ? GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent2) : null) : anchorAfter;
    }

    private static PsiElement adjustForCloseableBlock(@NotNull GrClosableBlock block) {
        PsiElement element2 = block.getFirstChild();
        if (element2 != null) {
            element2 = element2.getNextSibling();
        }
        while (element2 != null && (element2 = element2.getNextSibling()) != null && (Strings.isNullOrEmpty((String)element2.getText()) || element2.getText().matches("[\\t ]+"))) {
        }
        return element2 == null ? null : element2.getPrevSibling();
    }

    static boolean needToCreateParent(@NotNull GradleDslElement element2) {
        GradleDslElement parent2 = element2.getParent();
        return parent2 != null && parent2.getPsiElement() == null;
    }

    static boolean closableBlockNeedsNewline(@NotNull GrClosableBlock block) {
        PsiElement start2 = block.getLBrace();
        PsiElement end = block.getRBrace();
        if (end == null) {
            return false;
        }
        for (PsiElement element2 = start2; element2 != end; element2 = element2.getNextSibling()) {
            if (!element2.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) continue;
            return false;
        }
        return true;
    }

    static List<GradleReferenceInjection> findInjections(@NotNull GradleDslSimpleExpression context2, @NotNull PsiElement psiElement, boolean includeUnresolved) {
        GrStringInjection[] grStringInjections;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (psiElement instanceof GrReferenceExpression || psiElement instanceof GrIndexProperty) {
            String name2 = context2.getDslFile().getParser().convertReferencePsi(context2, psiElement);
            GradleDslElement element2 = context2.resolveInternalSyntaxReference(name2, true);
            return ImmutableList.of((Object)new GradleReferenceInjection(context2, element2, psiElement, name2));
        }
        if (!(psiElement instanceof GrString)) {
            return Collections.emptyList();
        }
        ArrayList<GradleReferenceInjection> injections = new ArrayList<GradleReferenceInjection>();
        for (GrStringInjection injection : grStringInjections = ((GrString)psiElement).getInjections()) {
            String name3;
            if (injection == null || (name3 = GroovyDslUtil.getInjectionName(injection)) == null) continue;
            GradleDslElement referenceElement = context2.resolveExternalSyntaxReference(name3, true);
            if (!includeUnresolved && referenceElement == null) continue;
            injections.add(new GradleReferenceInjection(context2, referenceElement, (PsiElement)injection, name3));
        }
        return injections;
    }

    static void createAndAddClosure(@NotNull GradleDslClosure closure2, @NotNull GradleDslElement element2) {
        PsiElement newElement;
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element2.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
        GrClosableBlock block = factory2.createClosureFromText("{ }");
        if (psiElement instanceof GrApplicationStatement) {
            GrCommandArgumentList argumentList = ((GrApplicationStatement)psiElement).getArgumentList();
            newElement = argumentList.addAfter((PsiElement)block, argumentList.getLastChild());
        } else {
            psiElement.addAfter(factory2.createWhiteSpace(), psiElement.getLastChild());
            newElement = psiElement.addAfter((PsiElement)block, psiElement.getLastChild());
        }
        closure2.setPsiElement(newElement);
        closure2.applyChanges();
        element2.setParsedClosureElement(closure2);
        element2.setNewClosureElement(null);
    }

    static void deletePsiElement(@NotNull GradleDslElement context2, @Nullable PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent2 = psiElement.getParent();
        psiElement.delete();
        GroovyDslUtil.maybeDeleteIfEmpty(parent2, context2);
        SharedParserUtilsKt.removePsiIfInvalid(context2);
    }
}

