/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradlePropertiesFile
extends GradleDslFile {
    @NotNull
    private final Properties myProperties;

    public GradlePropertiesFile(@NotNull Properties properties2, @NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2, @NotNull BuildModelContext context2) {
        super(file2, project, moduleName2, context2);
        this.myProperties = properties2;
    }

    @Override
    public void parse() {
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        return new ArrayList<GradleDslElement>(this.getPropertyElements().values());
    }

    @Override
    @Nullable
    public GradleDslSimpleExpression getPropertyElement(@NotNull String property2) {
        String value2 = this.myProperties.getProperty(property2);
        if (value2 == null) {
            return null;
        }
        GradlePropertyElement propertyElement = new GradlePropertyElement(this, GradleNameElement.fake(GradleNameElement.escape(property2)));
        propertyElement.setValue(value2);
        return propertyElement;
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        HashMap<String, GradleDslElement> results2 = new HashMap<String, GradleDslElement>();
        for (String name2 : this.myProperties.stringPropertyNames()) {
            results2.put(name2, this.getPropertyElement(name2));
        }
        return results2;
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getPropertyElements();
    }

    @Override
    @NotNull
    public GradleDslWriter getWriter() {
        return new GradleDslWriter.Adapter(this.getContext());
    }

    private static class GradlePropertyElement
    extends GradleDslSimpleExpression {
        @Nullable
        private Object myValue;

        private GradlePropertyElement(@Nullable GradleDslElement parent2, @NotNull GradleNameElement name2) {
            super(parent2, null, name2, null);
            this.setElementType(PropertyType.PROPERTIES_FILE);
        }

        @Override
        @Nullable
        public Object produceValue() {
            return this.myValue;
        }

        @Override
        @Nullable
        public Object produceUnresolvedValue() {
            return this.getValue();
        }

        @Override
        @Nullable
        public <T> T getValue(@NotNull Class<T> clazz) {
            Object value2 = this.getValue();
            if (clazz.isInstance(value2)) {
                return clazz.cast(value2);
            }
            return null;
        }

        @Override
        @Nullable
        public <T> T getUnresolvedValue(@NotNull Class<T> clazz) {
            return this.getValue(clazz);
        }

        @Override
        public void setValue(@NotNull Object value2) {
            this.myValue = value2;
            this.valueChanged();
        }

        @Override
        @Nullable
        public Object produceRawValue() {
            return this.getUnresolvedValue();
        }

        @Override
        @NotNull
        public GradleDslSimpleExpression copy() {
            GradlePropertyElement element2 = new GradlePropertyElement(this.myParent, GradleNameElement.copy(this.myName));
            element2.myValue = this.myValue;
            return element2;
        }

        @Override
        @NotNull
        public Collection<GradleDslElement> getChildren() {
            return ImmutableList.of();
        }

        @Override
        protected void apply() {
        }
    }
}

