/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.crashlytics.CrashlyticsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleScriptFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildFile
extends GradleScriptFile {
    @Nullable
    private GradlePropertiesFile myPropertiesFile;
    @Nullable
    private GradleBuildFile myParentModuleBuildFile;
    @NotNull
    private final Set<GradleBuildFile> myChildModuleBuildFiles = Sets.newHashSet();
    public static final ImmutableMap<String, PropertiesElementDescription> CHILD_PROPERTIES_ELEMENTS_MAP = (ImmutableMap)Stream.of({"android", AndroidDslElement.ANDROID}, {"buildscript", BuildScriptDslElement.BUILDSCRIPT}, {"configurations", ConfigurationsDslElement.CONFIGURATIONS}, {"crashlytics", CrashlyticsDslElement.CRASHLYTICS}, {"dependencies", DependenciesDslElement.DEPENDENCIES}, {"ext", ExtDslElement.EXT}, {"java", JavaDslElement.JAVA}, {"repositories", RepositoriesDslElement.REPOSITORIES}, {"subprojects", SubProjectsDslElement.SUBPROJECTS}, {"plugins", PluginsDslElement.PLUGINS}).collect(ImmutableMap.toImmutableMap(data -> (String)data[0], data -> (PropertiesElementDescription)data[1]));

    public GradleBuildFile(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2, @NotNull BuildModelContext context2) {
        super(file2, project, moduleName2, context2);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element2) {
        if ("apply".equals(element2.getFullName())) {
            ApplyDslElement applyDslElement = this.getPropertyElement("apply", ApplyDslElement.class);
            if (applyDslElement == null) {
                applyDslElement = new ApplyDslElement(this, this);
                super.addParsedElement(applyDslElement);
            }
            applyDslElement.addParsedElement(element2);
            return;
        }
        super.addParsedElement(element2);
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element2) {
        ModelEffectDescription effect = null;
        if (element2 instanceof GradleDslLiteral) {
            if (element2.getName().equals("sourceCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mSourceCompatibility"), MethodSemanticsDescription.SET);
            } else if (element2.getName().equals("targetCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mTargetCompatibility"), MethodSemanticsDescription.SET);
            } else {
                super.setParsedElement(element2);
                return;
            }
            JavaDslElement javaDslElement = this.getPropertyElement(JavaDslElement.JAVA);
            if (javaDslElement == null) {
                javaDslElement = new JavaDslElement(this, GradleNameElement.create(JavaDslElement.JAVA.name));
                this.setParsedElement(javaDslElement);
            }
            element2.setModelEffect(effect);
            javaDslElement.setParsedElement(element2);
            return;
        }
        super.setParsedElement(element2);
    }

    @Override
    public void addAppliedProperty(GradleDslElement element2) {
        if (element2 instanceof GradleDslLiteral) {
            ModelEffectDescription effect;
            if (element2.getName().equals("sourceCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mSourceCompatibility"), MethodSemanticsDescription.SET);
            } else if (element2.getName().equals("targetCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mTargetCompatibility"), MethodSemanticsDescription.SET);
            } else {
                super.addAppliedProperty(element2);
                return;
            }
            JavaDslElement javaDslElement = this.getPropertyElement(JavaDslElement.JAVA);
            if (javaDslElement == null) {
                javaDslElement = new JavaDslElement(this, GradleNameElement.create(JavaDslElement.JAVA.name));
                this.addAppliedProperty(javaDslElement);
            }
            element2.setModelEffect(effect);
            javaDslElement.addAppliedProperty(element2);
            return;
        }
        super.addAppliedProperty(element2);
    }

    @Override
    @NotNull
    protected ImmutableMap<String, PropertiesElementDescription> getChildPropertiesElementsDescriptionMap() {
        return CHILD_PROPERTIES_ELEMENTS_MAP;
    }

    public void setPropertiesFile(@NotNull GradlePropertiesFile propertiesFile) {
        this.myPropertiesFile = propertiesFile;
    }

    @Nullable
    public GradlePropertiesFile getPropertiesFile() {
        return this.myPropertiesFile;
    }

    public void setParentModuleBuildFile(@NotNull GradleBuildFile parentModuleBuildFile) {
        this.myParentModuleBuildFile = parentModuleBuildFile;
        this.myParentModuleBuildFile.myChildModuleBuildFiles.add(this);
    }

    @Nullable
    public GradleBuildFile getParentModuleBuildFile() {
        return this.myParentModuleBuildFile;
    }

    @NotNull
    public Collection<GradleBuildFile> getChildModuleBuildFiles() {
        return this.myChildModuleBuildFiles;
    }
}

