/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.ext;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ElementSort {
    @NotNull
    private final GradleDslElement myElement;
    @NotNull
    private final GradlePropertiesDslElement myParent;

    private ElementSort(@NotNull GradlePropertiesDslElement parentElement, @NotNull GradleDslElement element2) {
        this.myElement = element2;
        this.myParent = parentElement;
    }

    public static ElementSort create(@NotNull GradlePropertiesDslElement parent2, @NotNull GradleDslElement element2) {
        return new ElementSort(parent2, element2);
    }

    public boolean sort(@NotNull List<GradleDslElement> elementList, @NotNull List<GradleDslElement> resultList) {
        HashMap<GradleDslElement, State> states = new HashMap<GradleDslElement, State>();
        elementList.forEach(e -> states.put((GradleDslElement)e, State.UNMARKED));
        ArrayList<GradleDslElement> postSort = new ArrayList<GradleDslElement>();
        for (GradleDslElement e2 : elementList) {
            if (this.visit(states, e2, postSort)) continue;
            return false;
        }
        resultList.clear();
        resultList.addAll(postSort);
        return true;
    }

    private boolean visit(@NotNull Map<GradleDslElement, State> states, @NotNull GradleDslElement element2, @NotNull List<GradleDslElement> postSort) {
        if (states.get(element2) == State.PERM_MARK) {
            return true;
        }
        if (states.get(element2) == State.TEMP_MARK) {
            return false;
        }
        states.put(element2, State.TEMP_MARK);
        for (GradleDslElement item2 : this.gatherDependencies(element2)) {
            if (this.visit(states, item2, postSort)) continue;
            return false;
        }
        states.put(element2, State.PERM_MARK);
        postSort.add(element2);
        return true;
    }

    private List<GradleDslElement> gatherDependencies(@NotNull GradleDslElement element2) {
        return element2.getDependencies().stream().map(e -> {
            GradleDslElement newElement = e.getToBeInjected();
            GradleDslSimpleExpression originElement = e.getOriginElement();
            String internalSyntaxReference = e.getName();
            if (newElement == null && this.myElement.getNameElement().isReferencedIn(internalSyntaxReference)) {
                return this.myElement;
            }
            if (newElement == null) {
                newElement = originElement.resolveInternalSyntaxReference(internalSyntaxReference, false);
            }
            while (newElement != null && newElement.getParent() != this.myParent) {
                newElement = newElement.getParent();
            }
            return newElement;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static enum State {
        UNMARKED,
        TEMP_MARK,
        PERM_MARK;

    }
}

