/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslMethodCall
extends GradleDslSimpleExpression {
    public static final Logger LOG = Logger.getInstance(GradleDslMethodCall.class);
    @NotNull
    private String myMethodName;
    @NotNull
    private GradleDslExpressionList myArguments;
    private boolean myIsConstructor;

    public GradleDslMethodCall(@NotNull GradleDslElement parent2, @NotNull GradleNameElement name2, @NotNull String methodName) {
        super(parent2, null, name2, null);
        this.myMethodName = methodName;
        this.myArguments = new GradleDslExpressionList((GradleDslElement)this, GradleNameElement.empty(), false);
        this.myIsConstructor = false;
    }

    public GradleDslMethodCall(@NotNull GradleDslElement parent2, @NotNull PsiElement methodCall, @NotNull GradleNameElement name2, @NotNull String methodName, boolean isConstructor) {
        super(parent2, methodCall, name2, methodCall);
        this.myMethodName = methodName;
        this.myArguments = new GradleDslExpressionList((GradleDslElement)this, GradleNameElement.empty(), false);
        this.myIsConstructor = isConstructor;
    }

    @VisibleForTesting
    public GradleDslMethodCall(@NotNull GradleDslElement parent2, @Nullable PsiElement methodCall, @NotNull GradleNameElement name2, boolean isConstructor, @NotNull String methodName) {
        super(parent2, methodCall, name2, methodCall);
        this.myMethodName = methodName;
        this.myArguments = new GradleDslExpressionList((GradleDslElement)this, GradleNameElement.empty(), false);
        this.myIsConstructor = isConstructor;
    }

    public void setParsedArgumentList(@NotNull GradleDslExpressionList arguments2) {
        this.myArguments = arguments2;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression2) {
        this.myArguments.addParsedExpression(expression2);
    }

    public void addNewArgument(@NotNull GradleDslExpression argument) {
        this.myArguments.addNewExpression(argument);
    }

    public void replaceArgument(@NotNull GradleDslExpression oldElement, @NotNull GradleDslExpression newElement) {
        this.myArguments.replaceExpression(oldElement, newElement);
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public void setIsConstructor(boolean isConstructor) {
        this.myIsConstructor = isConstructor;
    }

    @Nullable
    public PsiElement getArgumentListPsiElement() {
        return this.myArguments.getPsiElement();
    }

    @NotNull
    public List<GradleDslExpression> getArguments() {
        return this.myArguments.getExpressions();
    }

    @NotNull
    public GradleDslExpressionList getArgumentsElement() {
        return this.myArguments;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return new ArrayList<GradleDslElement>(this.getArguments());
    }

    @Override
    @Nullable
    public Object produceValue() {
        return this.getValueFromArgList(this.getArguments());
    }

    @Override
    @Nullable
    public Object produceUnresolvedValue() {
        return this.getValue();
    }

    @Nullable
    private Object getValueFromArgList(@NotNull List<? extends GradleDslElement> args) {
        if (args.size() == 1 && args.get(0) instanceof GradleDslSimpleExpression) {
            return ((GradleDslSimpleExpression)args.get(0)).getValue();
        }
        PsiElement psiElement = this.getPsiElement();
        return psiElement != null ? GradleDslMethodCall.getPsiText(psiElement) : null;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz.isAssignableFrom(File.class)) {
            return clazz.cast(this.getFileValue());
        }
        Object value2 = this.getValue();
        if (clazz.isInstance(value2)) {
            return clazz.cast(value2);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getUnresolvedValue(@NotNull Class<T> clazz) {
        return this.getValue(clazz);
    }

    @Nullable
    private File getFileValue() {
        String path2 = PropertyUtil.getFileValue(this);
        return path2 == null ? null : new File(path2);
    }

    @Override
    public void setValue(@NotNull Object value2) {
        if (value2 instanceof File) {
            this.setFileValue((File)value2);
        }
        this.valueChanged();
    }

    @Override
    @Nullable
    public Object produceRawValue() {
        return this.getUnresolvedValue();
    }

    @Override
    @NotNull
    public GradleDslMethodCall copy() {
        assert (this.myParent != null);
        GradleDslMethodCall methodCall = new GradleDslMethodCall(this.myParent, GradleNameElement.copy(this.myName), this.myMethodName);
        for (GradleDslExpression argument : this.getArguments()) {
            GradleDslExpression copy = argument.copy();
            methodCall.addNewArgument(copy);
        }
        return methodCall;
    }

    private void setFileValue(@NotNull File file2) {
        if (!this.myMethodName.equals("file")) {
            LOG.warn((Throwable)new UnsupportedOperationException("Cannot set a file value to a method other than file(). Method name: " + this.myMethodName));
            return;
        }
        List<GradleDslExpression> arguments2 = this.getArguments();
        if (arguments2.isEmpty()) {
            GradleDslLiteral argument = new GradleDslLiteral(this, GradleNameElement.empty());
            argument.setValue(file2.getPath());
            this.myArguments.addNewExpression(argument);
            return;
        }
        GradleDslElement pathArgument = arguments2.get(0);
        if (!(pathArgument instanceof GradleDslSimpleExpression)) {
            return;
        }
        ((GradleDslSimpleExpression)pathArgument).setValue(file2.getPath());
    }

    @NotNull
    public String getMethodName() {
        return this.myMethodName;
    }

    public void setMethodName(@NotNull String newMethodName) {
        this.myMethodName = newMethodName;
    }

    @Override
    @NotNull
    public String getName() {
        String name2 = super.getName();
        return name2.isEmpty() ? this.getMethodName() : name2;
    }

    public void remove(@NotNull GradleDslElement argument) {
        this.myArguments.removeElement(argument);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslMethodCall(this);
    }

    @Override
    protected void reset() {
        super.reset();
        this.myArguments.reset();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslMethodCall(this);
    }
}

