/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslLiteral
extends GradleDslSettableExpression {
    public GradleDslLiteral(@NotNull GradleDslElement parent2, @NotNull GradleNameElement name2) {
        super(parent2, null, name2, null);
        this.setReference(false);
    }

    public GradleDslLiteral(@NotNull GradleDslElement parent2, @NotNull PsiElement psiElement, @NotNull GradleNameElement name2, @NotNull PsiElement literal, @NotNull LiteralType literalType) {
        super(parent2, psiElement, name2, literal);
        if (literalType == LiteralType.REFERENCE) {
            this.setReference(true);
        } else if (literalType == LiteralType.INTERPOLATION) {
            this.setInterpolated(true);
        }
    }

    @Override
    @Nullable
    public Object produceValue() {
        PsiElement element2 = this.getCurrentElement();
        if (element2 == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element2, true));
    }

    @Override
    @Nullable
    public Object produceUnresolvedValue() {
        PsiElement element2 = this.getCurrentElement();
        if (element2 == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().extractValue(this, element2, false));
    }

    @Override
    public void setValue(@NotNull Object value2) {
        if (!this.isValid(value2)) {
            return;
        }
        PsiElement element2 = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement psiElement = this.getDslFile().getParser().convertToPsiElement(this, value2);
            this.getDslFile().getParser().setUpForNewValue(this, psiElement);
            return psiElement;
        });
        this.setUnsavedValue(element2);
        this.valueChanged();
    }

    @Override
    @Nullable
    public Object produceRawValue() {
        PsiElement currentElement = this.getCurrentElement();
        if (currentElement == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(() -> {
            boolean shouldInterpolate = this.getDslFile().getParser().shouldInterpolate(this);
            Object val = this.getDslFile().getParser().extractValue(this, currentElement, false);
            if (val instanceof String && shouldInterpolate) {
                return GradlePropertyModel.iStr((String)val);
            }
            return val;
        });
    }

    @Override
    @NotNull
    public GradleDslLiteral copy() {
        assert (this.myParent != null);
        GradleDslLiteral literal = new GradleDslLiteral(this.myParent, GradleNameElement.copy(this.myName));
        Object v = this.getRawValue();
        if (v != null) {
            if (this.isReference()) {
                GradlePropertyModelImpl literalModel = GradlePropertyModelBuilder.create(this).build();
                ReferenceTo valueReference = ReferenceTo.createReferenceFromText((String)v, literalModel);
                if (valueReference != null) {
                    literal.setValue(valueReference);
                } else {
                    literal.setValue(new RawText((String)v, (String)v));
                }
            } else {
                literal.setValue(v);
            }
        }
        return literal;
    }

    public String toString() {
        Object value2 = this.getValue();
        String nameString = this.getName();
        Object namePrefix = nameString.isEmpty() ? "" : nameString + ": ";
        return (String)namePrefix + (value2 != null ? value2.toString() : super.toString());
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslLiteral(this);
    }

    @Override
    public void delete() {
        this.getDslFile().getWriter().deleteDslLiteral(this);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslLiteral(this);
    }

    @Nullable
    public GradleReferenceInjection getReferenceInjection() {
        return this.myDependencies.isEmpty() ? null : (GradleReferenceInjection)this.myDependencies.get(0);
    }

    @Override
    @Nullable
    public String getReferenceText() {
        if (!this.isReference() && !this.isInterpolated()) {
            return null;
        }
        PsiElement element2 = this.getCurrentElement();
        return element2 != null ? GradleDslLiteral.getPsiText(element2) : null;
    }

    @Override
    public void reset() {
        super.reset();
        ApplicationManager.getApplication().runReadAction(() -> this.getDslFile().getParser().setUpForNewValue(this, this.getCurrentElement()));
    }

    public static enum LiteralType {
        INTERPOLATION,
        LITERAL,
        REFERENCE;

    }
}

