/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ExternalToModelMap;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders = new ArrayList<GradlePropertiesDslElement>();
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    @NotNull
    protected ExternalNameInfo.ExternalNameSyntax mySyntax;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies = new ArrayList<GradleReferenceInjection>();
    @NotNull
    protected final List<GradleReferenceInjection> myDependents = new ArrayList<GradleReferenceInjection>();
    @Nullable
    private ModelEffectDescription myModelEffectDescription;

    protected GradleDslElementImpl(@Nullable GradleDslElement parent2, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2) {
        assert (parent2 != null || this instanceof GradleDslFile);
        this.myParent = parent2;
        this.myPsiElement = psiElement;
        this.myName = name2;
        this.myDslFile = parent2 == null ? (GradleDslFile)this : parent2.getDslFile();
        this.mySyntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myModelEffectDescription == null ? this.myName.name() : this.myModelEffectDescription.property.name;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            return GradleNameElement.escape(this.getName());
        }
        String ourName = this.getName();
        return this.myParent.getQualifiedName() + (String)(ourName.isEmpty() ? "" : "." + GradleNameElement.escape(ourName));
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myModelEffectDescription == null) {
            return this.myName.fullName();
        }
        List<String> parts = this.myName.qualifyingParts();
        parts.add(this.getName());
        return GradleNameElement.createNameFromParts(parts);
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        return this.myName;
    }

    @Override
    public void setNameElement(@NotNull GradleNameElement name2) {
        this.myName = name2;
    }

    @Override
    public void rename(@NotNull String newName2) {
        this.rename(Arrays.asList(newName2));
    }

    @Override
    public void rename(@NotNull List<String> hierarchicalName) {
        this.myName.rename(hierarchicalName);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent2) {
        this.myParent = parent2;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        return this.myHolders;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    @NotNull
    public ExternalNameInfo.ExternalNameSyntax getExternalSyntax() {
        return this.mySyntax;
    }

    @Override
    public void setExternalSyntax(@NotNull ExternalNameInfo.ExternalNameSyntax syntax) {
        this.mySyntax = syntax;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        return this.myElementType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        return this.myDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        return resultBuilder.build();
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element2) {
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
            if (this instanceof DescribedGradlePropertiesDslElement && this.myParent instanceof GradlePropertiesDslElement) {
                ((GradlePropertiesDslElement)this.myParent).updateAppliedState(this);
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        GradleDslExpressionMap map2;
        LinkedHashMap<String, GradleDslElement> results2 = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results2.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element2 = (GradlePropertiesDslElement)currentElement;
            results2.putAll(element2.getVariableElements());
        }
        if (currentElement instanceof GradleBuildFile) {
            for (GradleBuildFile file2 = (GradleBuildFile)currentElement; file2 != null; file2 = file2.getParentModuleBuildFile()) {
                ExtDslElement buildScriptExt;
                BuildScriptDslElement buildScriptElement;
                GradlePropertiesFile propertiesFile;
                ExtDslElement ext = file2.getPropertyElement(ExtDslElement.EXT);
                if (ext != null) {
                    results2.putAll(ext.getPropertyElements());
                }
                if ((propertiesFile = file2.getPropertiesFile()) != null) {
                    Map<String, GradleDslElement> filteredProperties = ((GradlePropertiesDslElement)propertiesFile).getPropertyElements().entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(".")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    results2.putAll(filteredProperties);
                }
                if ((buildScriptElement = file2.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT)) == null || (buildScriptExt = buildScriptElement.getPropertyElement(ExtDslElement.EXT)) == null) continue;
                results2.putAll(buildScriptExt.getPropertyElements());
            }
        } else if (currentElement instanceof GradleVersionCatalogFile && (map2 = ((GradleVersionCatalogFile)currentElement).getPropertyElement(GradleDslExpressionMap.VERSIONS)) != null) {
            Map<String, GradleDslElement> versions = map2.getPropertyElements();
            results2.putAll(versions.entrySet().stream().collect(Collectors.toMap(e -> "versions." + (String)e.getKey(), Map.Entry::getValue)));
        }
        return results2;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        return this.getDslFile().getContext().getNotificationForType(this.myDslFile, type);
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        return new ArrayList<GradleReferenceInjection>(this.myDependents);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return new ArrayList<GradleReferenceInjection>(this.myDependencies);
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void addDependency(@NotNull GradleReferenceInjection injection) {
        this.myDependencies.add(injection);
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        HashSet<GradleDslElement> visited = new HashSet<GradleDslElement>();
        this.modify(visited);
    }

    protected void modify(Set<GradleDslElement> visited) {
        ++this.myModificationCount;
        visited.add(this);
        this.myDependents.forEach(e -> {
            if (!visited.contains(e.getOriginElement())) {
                e.getOriginElement().modify(visited);
            }
        });
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }

    @Override
    public boolean isNewEmptyBlockElement() {
        if (this.myPsiElement != null) {
            return false;
        }
        if (!this.isBlockElement() || !this.isInsignificantIfEmpty()) {
            return false;
        }
        List<GradleDslElement> children2 = this.getContainedElements(true);
        if (children2.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children2) {
            if (child.isNewEmptyBlockElement()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalToModelMap getExternalToModelMap(@NotNull GradleDslNameConverter converter) {
        return this.getExternalToModelMap(converter, ExternalToModelMap.empty, ExternalToModelMap.empty);
    }

    @NotNull
    protected final ExternalToModelMap getExternalToModelMap(@NotNull GradleDslNameConverter converter, ExternalToModelMap groovy, ExternalToModelMap kts) {
        GradleDslNameConverter.Kind kind = converter.getKind();
        if (kind == GradleDslNameConverter.Kind.GROOVY) {
            return groovy;
        }
        if (kind == GradleDslNameConverter.Kind.KOTLIN) {
            return kts;
        }
        return ExternalToModelMap.empty;
    }

    @Override
    @Nullable
    public ModelEffectDescription getModelEffect() {
        return this.myModelEffectDescription;
    }

    @Override
    public void setModelEffect(@Nullable ModelEffectDescription effect) {
        this.myModelEffectDescription = effect;
    }

    @Override
    @Nullable
    public ModelPropertyDescription getModelProperty() {
        return this.myModelEffectDescription == null ? null : this.myModelEffectDescription.property;
    }

    @Nullable
    public static GradleDslElement dereference(@NotNull GradleDslElement element2, @NotNull String index2) {
        if (element2 instanceof GradleDslExpressionList) {
            int offset;
            try {
                offset = Integer.parseInt(index2);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GradleDslExpressionList list2 = (GradleDslExpressionList)element2;
            if (list2.getExpressions().size() <= offset) {
                return null;
            }
            return list2.getExpressions().get(offset);
        }
        if (element2 instanceof GradleDslExpressionMap) {
            GradleDslExpressionMap map2 = (GradleDslExpressionMap)element2;
            index2 = GradleDslElementImpl.stripQuotes(index2);
            return map2.getPropertyElement(index2);
        }
        GradleDslElement value2 = PropertyUtil.followElement(element2);
        if (value2 == null) {
            return null;
        }
        if (value2 != element2) {
            return GradleDslElementImpl.dereference(value2, index2);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties2, @NotNull String name2, GradleDslNameConverter converter, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name2);
        if (!indexMatcher.find()) {
            ModelPropertyDescription property2 = converter.modelDescriptionForParent(name2, properties2);
            String modelName = property2 == null ? name2 : property2.name;
            return sameScope ? properties2.getElementBefore(childElement, modelName, includeSelf) : properties2.getPropertyElementBefore(childElement, modelName, includeSelf);
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null || elementName.isEmpty()) {
            return null;
        }
        ModelPropertyDescription property3 = converter.modelDescriptionForParent(elementName, properties2);
        String modelName = property3 == null ? elementName : property3.name;
        GradleDslElement element2 = sameScope ? properties2.getElementBefore(childElement, modelName, includeSelf) : properties2.getPropertyElementBefore(childElement, modelName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            String match2 = indexMatcher.group(1);
            if (match2 == null) {
                return null;
            }
            indexParts.add(match2);
        }
        while (!indexParts.isEmpty()) {
            String index2 = (String)indexParts.pop();
            if (element2 == null) {
                return null;
            }
            element2 = GradleDslElementImpl.dereference(element2, index2);
        }
        return element2;
    }

    @Nullable
    private static GradleBuildFile findBuildFile(GradleBuildFile rootModuleBuildFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleBuildFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleBuildFile;
        }
        for (GradleBuildFile buildFile : rootModuleBuildFile.getChildModuleBuildFiles()) {
            if (FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)moduleDirectory)) {
                return buildFile;
            }
            GradleBuildFile childBuildFile = GradleDslElementImpl.findBuildFile(buildFile, moduleDirectory);
            if (childBuildFile == null) continue;
            return buildFile;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties2, @NotNull List<String> nameParts, GradleDslNameConverter converter, @NotNull List<GradleDslElement> trace) {
        int traceIndex = trace.size() - 1;
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            GradleDslElement element2 = GradleDslElementImpl.extractElementFromProperties(properties2, nameParts.get(i), converter, i == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element2 == null) {
                return null;
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element2 = PropertyUtil.followElement(element2))) {
                return null;
            }
            properties2 = (GradlePropertiesDslElement)element2;
        }
        return GradleDslElementImpl.extractElementFromProperties(properties2, nameParts.get(nameParts.size() - 1), converter, nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element2, @NotNull List<String> nameParts, GradleDslNameConverter converter, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element2);
        }
        while (ignoreParentNumber-- > 0 && element2 != null && !(element2 instanceof GradleDslFile) && !(element2 instanceof BuildScriptDslElement)) {
            element2 = element2.getParent();
        }
        while (element2 != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element2)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element2, nameParts, converter, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element2).getPropertyElementBefore(lastElement, ExtDslElement.EXT.name, false)) instanceof ExtDslElement && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, converter, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element2).getPropertyElementBefore(element2, BuildScriptDslElement.BUILDSCRIPT.name, false)) instanceof BuildScriptDslElement && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, nameParts, converter, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element2);
            }
            if (element2 instanceof BuildScriptDslElement) {
                return null;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleBuildFile buildDslFile, @NotNull String referenceText) {
        GradlePropertiesFile propertiesDslFile = buildDslFile.getPropertiesFile();
        return propertiesDslFile != null ? ((GradlePropertiesDslElement)propertiesDslFile).getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInVersionCatalogs(@NotNull BuildModelContext context2, @NotNull List<String> referenceParts) {
        if (referenceParts.size() < 2) {
            return null;
        }
        String catalog = referenceParts.get(0);
        for (GradleVersionCatalogFile versionCatalogFile : context2.getVersionCatalogFiles()) {
            GradleDslElement table2;
            Pattern pattern;
            if (!catalog.equals(versionCatalogFile.getCatalogName())) continue;
            String tableName = referenceParts.get(1);
            if ("plugins".equals(tableName) || "bundles".equals(tableName) || "versions".equals(tableName)) {
                pattern = Pattern.compile(String.join((CharSequence)"[-_.]", referenceParts.subList(2, referenceParts.size())));
                table2 = versionCatalogFile.getElement(tableName);
            } else {
                pattern = Pattern.compile(String.join((CharSequence)"[-_.]", referenceParts.subList(1, referenceParts.size())));
                table2 = versionCatalogFile.getElement("libraries");
            }
            if (table2 == null) {
                return null;
            }
            for (GradleDslElement element2 : table2.getChildren()) {
                if (!pattern.matcher(element2.getName()).matches()) continue;
                return element2;
            }
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleBuildFile buildFile, @NotNull List<String> referenceText, GradleDslNameConverter converter) {
        for (GradleBuildFile parentBuildFile = buildFile.getParentModuleBuildFile(); parentBuildFile != null; parentBuildFile = parentBuildFile.getParentModuleBuildFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentBuildFile.getPropertyElement(ExtDslElement.EXT);
            if (extDslElement != null && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement(extDslElement, referenceText, converter, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentBuildFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentBuildFile.getParentModuleBuildFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(parentBuildFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, GradleDslNameConverter converter, boolean resolveWithOrder) {
        GradleDslExpressionMap libraries2;
        GradleDslElement element2;
        GradleDslExpressionMap versions;
        if (startElement.getDslFile() instanceof GradleVersionCatalogFile && referenceText.size() == 1 && ((versions = startElement.getDslFile().getPropertyElement("versions", GradleDslExpressionMap.class)) != null ? (element2 = GradleDslElementImpl.resolveReferenceOnElement(versions, referenceText, converter, false, false, -1)) != null : (libraries2 = startElement.getDslFile().getPropertyElement("libraries", GradleDslExpressionMap.class)) != null && (element2 = GradleDslElementImpl.resolveReferenceOnElement(libraries2, referenceText, converter, false, false, -1)) != null)) {
            return element2;
        }
        element2 = GradleDslElementImpl.resolveReferenceOnElement(startElement, referenceText, converter, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size());
        if (element2 != null) {
            return element2;
        }
        String text2 = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        if (dslFile instanceof GradleBuildFile) {
            GradleDslElement bsElement;
            GradleBuildFile buildFile = (GradleBuildFile)dslFile;
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(buildFile, text2);
            if (propertyElement != null) {
                return propertyElement;
            }
            BuildScriptDslElement bsDslElement = buildFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            GradleDslElement versionCatalogElement = GradleDslElementImpl.resolveReferenceInVersionCatalogs(buildFile.getContext(), referenceText);
            if (versionCatalogElement != null) {
                return versionCatalogElement;
            }
            GradleBuildFile rootProjectBuildFile = buildFile.getContext().getRootProjectFile();
            if (rootProjectBuildFile == null || buildFile == rootProjectBuildFile) {
                return null;
            }
            return GradleDslElementImpl.resolveReferenceInPropertiesFile(rootProjectBuildFile, text2);
        }
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleDslElementImpl searchStartElement = this;
        if (searchStartElement.getDslFile() instanceof GradleVersionCatalogFile) {
            if (((String)referenceText).startsWith("versions.")) {
                referenceText = DOUBLE_QUOTES + ((String)referenceText).substring("versions.".length()) + DOUBLE_QUOTES;
            } else if (((String)referenceText).startsWith("libraries.")) {
                referenceText = DOUBLE_QUOTES + ((String)referenceText).substring("libraries.".length()) + DOUBLE_QUOTES;
            }
        }
        GradleDslParser parser2 = this.getDslFile().getParser();
        referenceText = parser2.convertReferenceText(searchStartElement, (String)referenceText);
        return this.resolveInternalSyntaxReference((String)referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull PsiElement psiElement, boolean resolveWithOrder) {
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser2 = this.getDslFile().getParser();
        String referenceText = parser2.convertReferencePsi(searchStartElement, psiElement);
        return this.resolveInternalSyntaxReference(referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveInternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleBuildFile buildFile;
        int index2;
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser2 = this.getDslFile().getParser();
        boolean withinBuildscript = false;
        GradleDslElement element2 = this;
        while (element2 != null) {
            if (!((element2 = element2.getParent()) instanceof BuildScriptDslElement)) continue;
            withinBuildscript = true;
            break;
        }
        List<String> referenceTextSegments = GradleNameElement.split(referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index2 = 0; index2 < segmentCount && (buildFile = GradleDslElementImpl.resolveProjectReference(searchStartElement, referenceTextSegments.get(index2))) != null; ++index2) {
            searchStartElement = buildFile;
        }
        GradleDslElement resolvedElement = null;
        GradleDslFile dslFile = searchStartElement.getDslFile();
        if (index2 >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index2, segmentCount);
            if (dslFile == searchStartElement && withinBuildscript) {
                searchStartElement = dslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            }
            if (searchStartElement != null) {
                resolvedElement = GradleDslElementImpl.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, parser2, resolveWithOrder);
            }
        }
        if (resolvedElement == null && dslFile instanceof GradleBuildFile) {
            GradleBuildFile buildFile2 = (GradleBuildFile)dslFile;
            resolvedElement = GradleDslElementImpl.resolveReferenceInParentModules(buildFile2, referenceTextSegments, parser2);
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleBuildFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile = startElement.getDslFile();
        if (dslFile instanceof GradleBuildFile) {
            GradleBuildFile buildFile;
            if ("project".equals(projectReference)) {
                return buildFile;
            }
            if ("parent".equals(projectReference)) {
                return buildFile.getParentModuleBuildFile();
            }
            if ("rootProject".equals(projectReference)) {
                for (buildFile = (GradleBuildFile)dslFile; buildFile != null && !FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getProject().getBaseDir())); buildFile = buildFile.getParentModuleBuildFile()) {
                }
                return buildFile;
            }
            String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
            if (standardProjectKey != null) {
                String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
                VirtualFile settingFile = buildFile.tryToFindSettingsFile();
                if (settingFile == null) {
                    return null;
                }
                GradleSettingsFile file2 = buildFile.getContext().getOrCreateSettingsFile(settingFile);
                GradleSettingsModelImpl model2 = new GradleSettingsModelImpl(file2);
                File moduleDirectory = model2.moduleDirectory(modulePath);
                if (moduleDirectory == null) {
                    return null;
                }
                while (buildFile != null && !FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getProject().getBaseDir()))) {
                    buildFile = buildFile.getParentModuleBuildFile();
                }
                if (buildFile == null) {
                    return null;
                }
                return GradleDslElementImpl.findBuildFile(buildFile, moduleDirectory);
            }
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index2) {
        if (index2.startsWith(SINGLE_QUOTES) && index2.endsWith(SINGLE_QUOTES) || index2.startsWith(DOUBLE_QUOTES) && index2.endsWith(DOUBLE_QUOTES)) {
            return index2.substring(1, index2.length() - 1);
        }
        return index2;
    }
}

