/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleReferenceInjection {
    @Nullable
    private GradleDslElement myToBeInjected;
    @NotNull
    private PsiElement myPsiInjection;
    @NotNull
    private GradleDslSimpleExpression myOriginElement;
    @NotNull
    private String myName;

    public GradleReferenceInjection(@NotNull GradleDslSimpleExpression originElement, @Nullable GradleDslElement injection, @NotNull PsiElement psiInjection, @NotNull String name2) {
        if (originElement == injection) {
            throw new IllegalStateException("Can't create a reference injection linking the same element to itself. Element: " + originElement);
        }
        this.myOriginElement = originElement;
        this.myToBeInjected = injection;
        this.myPsiInjection = psiInjection;
        this.myName = name2;
    }

    public boolean isResolved() {
        return this.myToBeInjected != null;
    }

    public void resolveWith(@Nullable GradleDslElement expression2) {
        this.myToBeInjected = expression2;
    }

    @Nullable
    public GradleDslElement getToBeInjected() {
        return this.myToBeInjected;
    }

    @NotNull
    public GradleDslSimpleExpression getOriginElement() {
        return this.myOriginElement;
    }

    @Nullable
    public GradleDslSimpleExpression getToBeInjectedExpression() {
        return this.myToBeInjected instanceof GradleDslSimpleExpression ? (GradleDslSimpleExpression)this.myToBeInjected : null;
    }

    @NotNull
    public PsiElement getPsiInjection() {
        return this.myPsiInjection;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public static String injectAll(@NotNull PsiElement psiElement, @NotNull Collection<GradleReferenceInjection> injections) {
        StringBuilder builder2 = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiElement element2 : psiElement.getChildren()) {
                Optional<GradleReferenceInjection> filteredInjection = injections.stream().filter(injection -> element2 == injection.getPsiInjection()).findFirst();
                if (filteredInjection.isPresent()) {
                    GradleDslSimpleExpression expression2 = filteredInjection.get().getToBeInjectedExpression();
                    if (expression2 == null) {
                        builder2.append(element2.getText());
                        continue;
                    }
                    Object value2 = expression2.getValue();
                    builder2.append(value2 == null ? "" : value2);
                    continue;
                }
                builder2.append(element2.getText());
            }
        });
        return builder2.toString();
    }
}

