/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.settings;

import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginsBlockModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginsBlockModelImpl
extends GradleDslBlockModel
implements PluginsBlockModel {
    @NonNls
    public static final String APPLY = "apply";
    @NonNls
    public static final String ID = "id";
    @NonNls
    public static final String VERSION = "version";

    public PluginsBlockModelImpl(@NotNull PluginsDslElement element2) {
        super(element2);
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(this.myDslElement)).values());
    }

    @Override
    @NotNull
    public List<PluginModel> appliedPlugins() {
        Predicate<PluginModel> appliedPredicate = plugin -> {
            ResolvedPropertyModel apply2 = plugin.apply();
            GradlePropertyModel.ValueType valueType = apply2.getValueType();
            if (valueType == GradlePropertyModel.ValueType.NONE) {
                return false;
            }
            if (valueType == GradlePropertyModel.ValueType.BOOLEAN) {
                return apply2.getValue(GradlePropertyModel.BOOLEAN_TYPE);
            }
            return false;
        };
        return this.plugins().stream().filter(appliedPredicate).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(this.myDslElement));
        if (models.containsKey(plugin)) {
            return models.get(plugin);
        }
        GradleDslLiteral literal = new GradleDslLiteral(this.myDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        this.myDslElement.setNewElement(literal);
        return new PluginModelImpl(literal);
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin, @NotNull String version2, @Nullable Boolean apply2) {
        GradleDslInfixExpression expression2 = new GradleDslInfixExpression(this.myDslElement, null);
        expression2.setNewLiteral(ID, plugin.trim());
        expression2.setNewLiteral(VERSION, version2);
        if (apply2 != null) {
            expression2.setNewLiteral(APPLY, apply2);
        }
        this.myDslElement.setNewElement(expression2);
        return new PluginModelImpl(expression2);
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull ReferenceTo reference, @Nullable Boolean apply2) {
        GradleDslMethodCall alias = new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), "alias");
        GradleDslLiteral target2 = new GradleDslLiteral(alias.getArgumentsElement(), GradleNameElement.empty());
        target2.setValue(reference);
        alias.addNewArgument(target2);
        if (apply2 != null) {
            GradleDslInfixExpression expression2 = new GradleDslInfixExpression(this.myDslElement, null);
            alias.setParent(expression2);
            expression2.setNewElement(alias);
            expression2.setNewLiteral(APPLY, apply2);
            this.myDslElement.setNewElement(expression2);
            return new PluginModelImpl(expression2);
        }
        this.myDslElement.setNewElement(alias);
        return new PluginModelImpl(alias);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        PluginModelImpl.removePlugins(PluginModelImpl.create(this.myDslElement), plugin);
    }
}

