/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.kotlin;

import com.android.tools.idea.gradle.dsl.api.java.LanguageLevelPropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.LanguageLevelUtil;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JvmTargetPropertyModelImpl
extends ResolvedPropertyModelImpl
implements LanguageLevelPropertyModel {
    private static final Logger LOG = Logger.getInstance(JvmTargetPropertyModelImpl.class);
    private static final String docLink = "https://kotlinlang.org/docs/reference/using-gradle.html#attributes-specific-for-jvm";
    private static final ImmutableMap<Integer, String> allowedTargets = ImmutableMap.builder().put((Object)6, (Object)"1.6").put((Object)8, (Object)"1.8").put((Object)9, (Object)"9").put((Object)10, (Object)"10").put((Object)11, (Object)"11").put((Object)12, (Object)"12").build();

    public JvmTargetPropertyModelImpl(@NotNull GradlePropertyModelImpl realModel) {
        super(realModel);
    }

    @Override
    @TestOnly
    @Nullable
    public LanguageLevel toLanguageLevel() {
        String stringToParse = LanguageLevelUtil.getStringToParse(this);
        return stringToParse == null ? null : LanguageLevelUtil.parseFromGradleString(stringToParse);
    }

    @Override
    public void setLanguageLevel(@NotNull LanguageLevel level) {
        int major = level.toJavaVersion().feature;
        if (allowedTargets.containsKey((Object)major)) {
            this.setValue(allowedTargets.get((Object)major));
            return;
        }
        LOG.warn((Throwable)new IllegalArgumentException("Kotlin jvmTarget does not support Java " + major + ". See https://kotlinlang.org/docs/reference/using-gradle.html#attributes-specific-for-jvm for a list of supported targets."));
    }
}

