/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleArgToMapTransform
extends PropertyTransform {
    private static final Logger LOG = Logger.getInstance(SingleArgToMapTransform.class);
    @NotNull
    private final String mySingleArgName;
    @NotNull
    private final String myFieldName;

    public SingleArgToMapTransform(@NotNull String singleArgName, @NotNull String fieldName) {
        this.myFieldName = fieldName;
        this.mySingleArgName = singleArgName;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        GradleDslMethodCall methodCall;
        return e instanceof GradleDslMethodCall && !(methodCall = (GradleDslMethodCall)e).getArguments().isEmpty() && methodCall.getArguments().get(0) instanceof GradleDslSimpleExpression;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        return null;
    }

    @Override
    @NotNull
    public GradleDslSimpleExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name2) {
        return PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(this.myFieldName));
    }

    @Override
    @NotNull
    public GradleDslExpression bindList(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull String name2) {
        return new GradleDslExpressionList(holder, GradleNameElement.create(this.myFieldName), false);
    }

    @Override
    @NotNull
    public GradleDslExpression bindMap(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull String name2) {
        return new GradleDslExpressionMap(holder, GradleNameElement.create(this.myFieldName));
    }

    @Override
    @Nullable
    public GradleDslExpression replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        if (oldElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)oldElement;
            if (!methodCall.getArguments().isEmpty() && methodCall.getArguments().get(0) instanceof GradleDslSimpleExpression) {
                GradleDslSimpleExpression argument = (GradleDslSimpleExpression)methodCall.getArguments().get(0);
                methodCall.remove(argument);
                GradleDslExpressionMap expressionMap = new GradleDslExpressionMap(methodCall, GradleNameElement.empty());
                argument.rename(this.mySingleArgName);
                expressionMap.setNewElement(argument.copy());
                expressionMap.setNewElement(newElement);
                methodCall.addNewArgument(expressionMap);
            }
            return methodCall;
        }
        LOG.warn((Throwable)new IllegalStateException("Can't replace an element that isn't a GradleDslMethodCall: " + oldElement));
        return null;
    }
}

