/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.android.FakeSdkElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkOrPreviewTransform
extends PropertyTransform {
    @NotNull
    private final ModelPropertyDescription propertyDescription;
    @NotNull
    private final String genericSetter;
    @NotNull
    private final String sdkSetter;
    @NotNull
    private final String previewSetter;
    @Nullable
    private VersionConstraint versionConstraint;

    public SdkOrPreviewTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String genericSetter, @NotNull String sdkSetter, @NotNull String previewSetter, @Nullable VersionConstraint versionConstraint) {
        this.propertyDescription = propertyDescription;
        this.genericSetter = genericSetter;
        this.sdkSetter = sdkSetter;
        this.previewSetter = previewSetter;
        this.versionConstraint = versionConstraint;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        return e == null || e.getModelProperty() == this.propertyDescription;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof GradleDslSimpleExpression && this.previewSetter.equals(e.getNameElement().getLocalName())) {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)e;
            return new FakeSdkElement(expression2.getParent(), GradleNameElement.copy(expression2.getNameElement()), expression2, true);
        }
        return e;
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name2) {
        ExternalNameInfo.ExternalNameSyntax syntax;
        String operatorName;
        if (this.versionConstraint == null || this.versionConstraint.isOkWith(holder.getDslFile().getContext().getAgpVersion())) {
            if (value2 instanceof ReferenceTo) {
                operatorName = this.genericSetter;
                syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
            } else if (value2 instanceof Integer) {
                operatorName = this.sdkSetter;
                syntax = holder.getDslFile().getWriter() instanceof GroovyDslNameConverter ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
            } else if (value2 instanceof String && ((String)value2).startsWith("android-")) {
                operatorName = this.previewSetter;
                syntax = holder.getDslFile().getWriter() instanceof GroovyDslNameConverter ? ExternalNameInfo.ExternalNameSyntax.METHOD : ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT;
                value2 = ((String)value2).substring("android-".length());
            } else {
                operatorName = this.genericSetter;
                syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
            }
        } else {
            operatorName = this.genericSetter;
            syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
        }
        GradleDslSimpleExpression expression2 = PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(operatorName));
        expression2.setModelEffect(new ModelEffectDescription(this.propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE));
        expression2.setExternalSyntax(syntax);
        return expression2;
    }

    @Override
    @NotNull
    public GradleDslElement replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        GradlePropertiesDslElement propertiesHolder = (GradlePropertiesDslElement)holder;
        if (oldElement != null) {
            propertiesHolder.replaceElement(oldElement, newElement);
        } else {
            propertiesHolder.setNewElement(newElement);
        }
        return newElement;
    }
}

