/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext.transforms;

import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListOrVarargsTransform
extends PropertyTransform {
    @NotNull
    private final ModelPropertyDescription propertyDescription;
    @NotNull
    private final String setter;
    @NotNull
    private final String varargs;

    public ListOrVarargsTransform(@NotNull ModelPropertyDescription propertyDescription, @NotNull String setter, @NotNull String varargs) {
        this.propertyDescription = propertyDescription;
        this.setter = setter;
        this.varargs = varargs;
    }

    @Override
    public boolean test(@Nullable GradleDslElement e, @NotNull GradleDslElement holder) {
        return e == null || e.getModelProperty() == this.propertyDescription;
    }

    @Override
    @Nullable
    public GradleDslElement transform(@Nullable GradleDslElement e) {
        if (e == null) {
            return null;
        }
        return e;
    }

    @Override
    @NotNull
    public GradleDslExpression bind(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull Object value2, @NotNull String name2) {
        String operatorName = this.setter;
        ExternalNameInfo.ExternalNameSyntax syntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
        GradleDslSimpleExpression expression2 = PropertyUtil.createBasicExpression(holder, value2, GradleNameElement.create(operatorName));
        expression2.setModelEffect(new ModelEffectDescription(this.propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE));
        expression2.setExternalSyntax(syntax);
        return expression2;
    }

    @Override
    @NotNull
    public GradleDslExpression replace(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslExpression newElement, @NotNull String name2) {
        GradlePropertiesDslElement propertiesHolder = (GradlePropertiesDslElement)holder;
        if (oldElement != null) {
            propertiesHolder.replaceElement(oldElement, newElement);
        } else {
            propertiesHolder.setNewElement(newElement);
        }
        return newElement;
    }
}

