/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.MultiTypePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiTypePropertyModelImpl<T extends Enum<T>>
extends GradlePropertyModelImpl
implements MultiTypePropertyModel<T> {
    private static final Logger LOG = Logger.getInstance(MultiTypePropertyModelImpl.class);
    @NotNull
    private Map<T, PropertyTransform> myTransforms;
    @NotNull
    private T myType;
    @NotNull
    private T myOriginalType;

    public MultiTypePropertyModelImpl(@NotNull T defaultType, @NotNull GradleDslElement element2, @NotNull Map<T, PropertyTransform> transformMap) {
        super(element2);
        this.myTransforms = new LinkedHashMap<T, PropertyTransform>(transformMap);
        this.myType = defaultType;
        this.myOriginalType = defaultType;
        this.setUpTransforms();
    }

    public MultiTypePropertyModelImpl(@NotNull T defaultType, @NotNull GradleDslElement holder, @NotNull PropertyType propertyType, @NotNull String name2, @NotNull Map<T, PropertyTransform> transformMap) {
        super(holder, propertyType, name2);
        this.myTransforms = new LinkedHashMap<T, PropertyTransform>(transformMap);
        this.myType = defaultType;
        this.myOriginalType = defaultType;
        this.setUpTransforms();
    }

    private void setUpTransforms() {
        if (this.myElement == null) {
            return;
        }
        for (Map.Entry<T, PropertyTransform> e : this.myTransforms.entrySet()) {
            if (!e.getValue().test(this.myElement, this.myPropertyHolder)) continue;
            this.myType = (Enum)e.getKey();
            this.myOriginalType = this.myType;
            break;
        }
    }

    @Override
    @Nullable
    public GradleDslElement getElement() {
        PropertyTransform transform2 = this.getTransform();
        if (transform2.test(this.myElement, this.myPropertyHolder)) {
            return transform2.transform(this.myElement);
        }
        return null;
    }

    @Override
    @NotNull
    protected PropertyTransform getTransform() {
        PropertyTransform pt = this.myTransforms.get(this.myType);
        if (pt != null) {
            return pt;
        }
        return super.getTransform();
    }

    @Override
    @NotNull
    protected PropertyTransform getTransformFor(@Nullable GradleDslElement element2) {
        if (element2 == null) {
            return super.getTransformFor(element2);
        }
        for (PropertyTransform pt : this.myTransforms.values()) {
            if (!pt.test(element2, this.myPropertyHolder)) continue;
            return pt;
        }
        return super.getTransformFor(element2);
    }

    @Override
    @NotNull
    public T getType() {
        return this.myType;
    }

    @Override
    public void setValue(@NotNull T type, @NotNull Object value2) {
        this.setTypeAndValue(type, value2);
    }

    @Override
    public void setType(@NotNull T type) {
        this.setTypeAndValue(type, null);
    }

    protected void setTypeAndValue(@NotNull T type, @Nullable Object value2) {
        Object newValue = value2;
        if (newValue == null) {
            GradlePropertyModel.ValueType oldValueType = this.getValueType();
            if (oldValueType == GradlePropertyModel.ValueType.MAP || oldValueType == GradlePropertyModel.ValueType.LIST) {
                LOG.warn((Throwable)new UnsupportedOperationException("Can't convert " + oldValueType + " property to new type " + type));
                return;
            }
            GradleDslElement element2 = this.getElement();
            assert (element2 instanceof GradleDslSimpleExpression);
            newValue = ((GradleDslSimpleExpression)element2).getRawValue();
        }
        this.myType = type;
        if (newValue != null) {
            super.setValue(newValue);
        }
    }

    @Override
    public boolean isModified() {
        return this.myType != this.myOriginalType || super.isModified();
    }
}

