/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.InterpolatedText;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.TypeReference;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelImpl
implements GradlePropertyModel {
    private static final Logger LOG = Logger.getInstance(GradlePropertyModelImpl.class);
    @Nullable
    protected GradleDslElement myElement;
    @Nullable
    protected GradleDslElement myDefaultElement;
    @NotNull
    protected GradleDslElement myPropertyHolder;
    @NotNull
    private List<PropertyTransform> myTransforms = new ArrayList<PropertyTransform>();
    @NotNull
    private final PropertyType myPropertyType;
    @NotNull
    protected String myName;
    @Nullable
    protected ModelPropertyDescription myPropertyDescription;

    public GradlePropertyModelImpl(@NotNull GradleDslElement element2) {
        this.myElement = element2;
        GradleDslElement parent2 = element2.getParent();
        if (parent2 == null) {
            assert (element2 instanceof GradleDslFile);
            parent2 = element2;
        }
        assert (parent2 instanceof GradlePropertiesDslElement || parent2 instanceof GradleDslMethodCall) : "Property found to be invalid, this should never happen!";
        this.myPropertyHolder = parent2;
        this.myPropertyType = this.myElement.getElementType();
        this.myName = this.myElement.getName();
        this.myPropertyDescription = this.myElement.getModelProperty();
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull String name2) {
        this.myPropertyHolder = holder;
        this.myPropertyType = type;
        this.myName = name2;
        this.myPropertyDescription = null;
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull ModelPropertyDescription description2) {
        this(holder, type, description2.name);
        this.myPropertyDescription = description2;
    }

    public void addTransform(@NotNull PropertyTransform transform2) {
        this.myTransforms.add(0, transform2);
    }

    @Nullable
    public GradleDslElement getDefaultElement() {
        return this.myDefaultElement;
    }

    public void setDefaultElement(@NotNull GradleDslElement defaultElement) {
        this.myDefaultElement = defaultElement;
    }

    @Override
    @NotNull
    public GradlePropertyModel.ValueType getValueType() {
        return GradlePropertyModelImpl.extractAndGetValueType(this.getElement());
    }

    @Override
    @NotNull
    public PropertyType getPropertyType() {
        GradleDslElement element2 = this.getElement();
        return element2 == null ? this.myPropertyType : element2.getElementType();
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, true);
    }

    @Override
    public <T> T getRawValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, false);
    }

    @Nullable
    private static GradleDslElement maybeGetInnerReferenceModel(@NotNull GradleDslElement element2) {
        GradleDslLiteral reference;
        GradleReferenceInjection injection;
        GradleDslExpression expression2;
        GradleDslExpressionList list2;
        if (GradlePropertyModelImpl.extractAndGetValueType(element2) == GradlePropertyModel.ValueType.LIST && element2 instanceof GradleDslExpressionList && (list2 = (GradleDslExpressionList)element2).getExpressions().size() == 1 && (expression2 = list2.getElementAt(0)) instanceof GradleDslLiteral && ((GradleDslLiteral)expression2).isReference() && (injection = (reference = (GradleDslLiteral)expression2).getReferenceInjection()) != null) {
            return injection.getToBeInjected();
        }
        return null;
    }

    @Nullable
    private Object getInterpolatedValueIfPossible() {
        GradleDslSimpleExpression interpolated = (GradleDslSimpleExpression)this.getElement();
        PsiElement expression2 = interpolated.getExpression();
        if (expression2 == null) {
            return null;
        }
        ArrayList<InterpolatedText.InterpolatedTextItem> interpolationElements = new ArrayList<InterpolatedText.InterpolatedTextItem>();
        for (PsiElement child : expression2.getChildren()) {
            if (child.getText().startsWith("$")) {
                Matcher wrappedValueMatcher = this.getElement().getDslFile().getParser().getPatternForWrappedVariables().matcher(child.getText());
                Matcher unwrappedValueMatcher = this.getElement().getDslFile().getParser().getPatternForUnwrappedVariables().matcher(child.getText());
                String injectedText = null;
                if (wrappedValueMatcher.find()) {
                    injectedText = wrappedValueMatcher.group(1);
                } else if (unwrappedValueMatcher.find()) {
                    injectedText = unwrappedValueMatcher.group(1);
                }
                if (injectedText == null) {
                    return interpolated.getReferenceText() != null ? new RawText(interpolated.getReferenceText(), interpolated.getReferenceText()) : null;
                }
                ReferenceTo injectionReference = ReferenceTo.createReferenceFromText(injectedText, this);
                if (injectionReference == null) {
                    return interpolated.getReferenceText() != null ? new RawText(interpolated.getReferenceText(), interpolated.getReferenceText()) : null;
                }
                interpolationElements.add(new InterpolatedText.InterpolatedTextItem(injectionReference));
                continue;
            }
            interpolationElements.add(new InterpolatedText.InterpolatedTextItem(child.getText()));
        }
        return new InterpolatedText(interpolationElements);
    }

    @NotNull
    private Map<String, GradlePropertyModel> getMap(boolean resolved) {
        GradleDslExpressionMap map2;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return ImmutableMap.of();
        }
        GradleDslElement innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element2);
        if (resolved && innerElement instanceof GradleDslExpressionMap) {
            map2 = (GradleDslExpressionMap)innerElement;
        } else {
            assert (element2 instanceof GradleDslExpressionMap);
            map2 = (GradleDslExpressionMap)element2;
        }
        return map2.getPropertyElements(GradleDslExpression.class).stream().collect(Collectors.toMap(e -> e.getName(), e -> new GradlePropertyModelImpl((GradleDslElement)e), (u, v) -> v, LinkedHashMap::new));
    }

    @NotNull
    private List<GradlePropertyModel> getList(boolean resolved) {
        GradleDslElement innerElement;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return ImmutableList.of();
        }
        assert (element2 instanceof GradleDslExpressionList);
        GradleDslExpressionList list2 = (GradleDslExpressionList)element2;
        if (resolved && (innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element2)) instanceof GradleDslExpressionList) {
            list2 = (GradleDslExpressionList)innerElement;
        }
        return ContainerUtil.map(list2.getExpressions(), e -> new GradlePropertyModelImpl((GradleDslElement)e));
    }

    @Override
    @NotNull
    public String getName() {
        GradleDslExpressionList list2;
        int index2;
        GradleDslElement element2 = this.getElement();
        if (element2 != null && element2.getParent() instanceof GradleDslExpressionList && (index2 = (list2 = (GradleDslExpressionList)element2.getParent()).findIndexOf(element2)) != -1) {
            return String.valueOf(index2);
        }
        return element2 == null ? this.myName : element2.getName();
    }

    @Override
    @NotNull
    public List<GradlePropertyModel> getDependencies() {
        return new ArrayList<GradlePropertyModel>(this.dependencies());
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        GradleDslElement element2 = this.getRawElement();
        if (element2 != null && element2.getParent() instanceof GradleDslExpressionList) {
            GradleDslExpressionList list2 = (GradleDslExpressionList)element2.getParent();
            return element2.getParent().getQualifiedName() + "[" + String.valueOf(list2.findIndexOf(element2)) + "]";
        }
        return element2 == null ? this.myPropertyHolder.getQualifiedName() + "." + this.getName() : element2.getQualifiedName();
    }

    @Override
    @NotNull
    public VirtualFile getGradleFile() {
        return this.myPropertyHolder.getDslFile().getFile();
    }

    @Override
    public void setValue(@NotNull Object value2) {
        if (value2 instanceof List) {
            this.setListValue((List)value2);
        } else if (value2 instanceof Map) {
            this.setMapValue((Map)value2);
        } else {
            GradleDslExpression newElement = this.myPropertyDescription == null ? this.getTransform().bind(this.myPropertyHolder, this.myElement, value2, this.getName()) : this.getTransform().bind(this.myPropertyHolder, this.myElement, value2, this.myPropertyDescription);
            if (newElement != null) {
                this.bindToNewElement(newElement);
            }
        }
    }

    private void setMapValue(Map<String, GradlePropertyModel> value2) {
        this.convertToEmptyMap();
        for (Map.Entry<String, GradlePropertyModel> e : value2.entrySet()) {
            GradlePropertyModel newValueModel = this.getMapValue(e.getKey());
            Object newValue = e.getValue().getValue(OBJECT_TYPE);
            if (newValue == null || newValueModel == null) continue;
            newValueModel.setValue(newValue);
        }
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyMap() {
        this.makeEmptyMap();
        return this;
    }

    @Override
    @Nullable
    public GradlePropertyModel getMapValue(@NotNull String key) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.MAP && valueType != GradlePropertyModel.ValueType.NONE) {
            LOG.warn((Throwable)new IllegalStateException("getMapValue \"" + key + "\" called on a non-map model of type " + valueType + "."));
            return null;
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyMap();
        }
        GradleDslElement element2 = this.getTransform().transform(this.myElement);
        assert (element2 instanceof GradleDslExpressionMap);
        GradleDslExpressionMap map2 = (GradleDslExpressionMap)element2;
        GradleDslElement arg = map2.getPropertyElement(key);
        return arg == null ? new GradlePropertyModelImpl(element2, PropertyType.DERIVED, key) : new GradlePropertyModelImpl(arg);
    }

    private void setListValue(List<GradlePropertyModel> value2) {
        this.convertToEmptyList();
        for (GradlePropertyModel e : value2) {
            GradlePropertyModel newValueModel = this.addListValue();
            Object newValue = e.getValue(OBJECT_TYPE);
            if (newValue == null) continue;
            newValueModel.setValue(newValue);
        }
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyList() {
        this.makeEmptyList();
        return this;
    }

    @Override
    @Nullable
    public GradlePropertyModel addListValue() {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            LOG.warn((Throwable)new IllegalStateException("addListValue called on a non-list of type " + valueType + "."));
            return null;
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element2 = this.getTransform().transform(this.myElement);
        assert (element2 instanceof GradleDslExpressionList);
        return this.addListValueAt(((GradleDslExpressionList)element2).getExpressions().size());
    }

    @Override
    @Nullable
    public GradlePropertyModel addListValueAt(int index2) {
        GradleDslElement element2;
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            LOG.warn((Throwable)new IllegalStateException("addListValueAt called on a non-list of type " + valueType + "."));
            return null;
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        if (!((element2 = this.getTransform().transform(this.myElement)) instanceof GradleDslExpressionList)) {
            LOG.warn((Throwable)new IllegalStateException("element is not a GradleDslExpressionList " + element2));
            return null;
        }
        GradleDslExpressionList list2 = (GradleDslExpressionList)element2;
        if (index2 > list2.getPropertyElements(GradleDslExpression.class).size()) {
            LOG.warn((Throwable)new IllegalStateException("attempting to add an element past the end of the list " + list2));
            return null;
        }
        GradleDslLiteral literal = new GradleDslLiteral(element2, GradleNameElement.empty());
        literal.setValue("");
        list2.addNewExpression(literal, index2);
        return new GradlePropertyModelImpl(literal);
    }

    @Override
    @Nullable
    public GradlePropertyModel getListValue(@NotNull Object value2) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            LOG.warn((Throwable)new IllegalStateException("getListValue called on a non-list of type " + valueType + "."));
            return null;
        }
        List list2 = (List)this.getValue(LIST_TYPE);
        if (list2 == null) {
            return null;
        }
        return list2.stream().filter(e -> {
            Object v = e.getValue(OBJECT_TYPE);
            return v != null && v.equals(value2);
        }).findFirst().orElse(null);
    }

    @Override
    public void rewrite() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null || this.myElement == null) {
            return;
        }
        if (!(this.myElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalStateException("Called rewrite on a non-Expression: " + this.myElement));
            return;
        }
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType == GradlePropertyModel.ValueType.LIST) {
            this.setListValue((List)this.getValue(LIST_TYPE));
        } else if (valueType == GradlePropertyModel.ValueType.MAP) {
            this.setMapValue((Map)this.getValue(MAP_TYPE));
        } else {
            GradleDslExpression newElement = this.myPropertyDescription == null ? this.getTransform().bind(this.myPropertyHolder, this.myElement, this.getValue(OBJECT_TYPE), this.getName()) : this.getTransform().bind(this.myPropertyHolder, this.myElement, this.getValue(OBJECT_TYPE), this.myPropertyDescription);
            if (newElement == this.myElement) {
                newElement = newElement.copy();
            }
            this.bindToNewElement(newElement);
        }
    }

    @Override
    public void delete() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null || this.myElement == null) {
            return;
        }
        this.myElement = this.getTransform().delete(this.myPropertyHolder, this.myElement, element2);
    }

    @Override
    @NotNull
    public ResolvedPropertyModelImpl resolve() {
        return new ResolvedPropertyModelImpl(this);
    }

    @Override
    @NotNull
    public GradlePropertyModel getUnresolvedModel() {
        return this;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return null;
        }
        return element2.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getExpressionPsiElement() {
        return this.getExpressionPsiElement(false);
    }

    @Override
    @Nullable
    public PsiElement getFullExpressionPsiElement() {
        return this.getExpressionPsiElement(true);
    }

    @Nullable
    private PsiElement getExpressionPsiElement(boolean fullExpression) {
        GradleDslElement element2;
        GradleDslElement gradleDslElement = element2 = fullExpression ? this.myElement : this.getElement();
        if (element2 instanceof GradleDslExpression) {
            return ((GradleDslExpression)element2).getExpression();
        }
        return element2 == null ? null : element2.getPsiElement();
    }

    @Override
    public void rename(@NotNull String name2) {
        this.rename(Arrays.asList(name2));
    }

    @Override
    public void rename(@NotNull List<String> name2) {
        if (this.myElement == null) {
            this.myName = GradleNameElement.join(name2);
            return;
        }
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return;
        }
        GradleDslElement parent2 = element2.getParent();
        if (parent2 instanceof GradleDslExpressionList || parent2 instanceof GradleDslMethodCall) {
            LOG.warn((Throwable)new UnsupportedOperationException("Can't rename list values: " + element2 + " in " + parent2 + "."));
            return;
        }
        element2.rename(name2);
        this.myName = this.myElement.getName();
    }

    @Override
    public boolean isModified() {
        GradleDslElement element2 = this.myElement;
        if (element2 != null) {
            if (element2 instanceof FakeElement) {
                return PropertyUtil.isFakeElementModified((FakeElement)element2);
            }
            GradleDslElement originalElement = PropertyUtil.findOriginalElement(this.myPropertyHolder, element2);
            if (originalElement == null) {
                return true;
            }
            GradleDslElement transformedElement = this.getElement();
            if (transformedElement == null) {
                return true;
            }
            GradleDslElement transformedOriginalElement = PropertyUtil.findOriginalElement(this.getHolder(), transformedElement);
            if (transformedOriginalElement == null) {
                transformedOriginalElement = this.getTransformFor(originalElement).transform(originalElement);
            }
            if (transformedOriginalElement == null) {
                return true;
            }
            return PropertyUtil.isModelElementModified(originalElement, element2, transformedOriginalElement, transformedElement);
        }
        GradlePropertiesDslElement holder = this.myPropertyHolder instanceof GradleDslMethodCall ? ((GradleDslMethodCall)this.myPropertyHolder).getArgumentsElement() : (GradlePropertiesDslElement)this.myPropertyHolder;
        GradleDslElement originalElement = holder.getOriginalElementForNameAndType(this.getName(), this.myPropertyType);
        GradleDslElement holderOriginalElement = PropertyUtil.findOriginalElement(holder.getParent(), holder);
        return originalElement != null && (originalElement.isModified() || PropertyUtil.isElementModified(holderOriginalElement, holder));
    }

    @Override
    public String toString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @Nullable
    public String valueAsString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @NotNull
    public String forceString() {
        String s = this.toString();
        assert (s != null);
        return s;
    }

    @Override
    @Nullable
    public Integer toInt() {
        return (Integer)this.getValue(INTEGER_TYPE);
    }

    @Override
    @Nullable
    public BigDecimal toBigDecimal() {
        return (BigDecimal)this.getValue(BIG_DECIMAL_TYPE);
    }

    @Override
    @Nullable
    public Boolean toBoolean() {
        return (Boolean)this.getValue(BOOLEAN_TYPE);
    }

    @Override
    @Nullable
    public List<GradlePropertyModel> toList() {
        return (List)this.getValue(LIST_TYPE);
    }

    @Override
    @Nullable
    public Map<String, GradlePropertyModel> toMap() {
        return (Map)this.getValue(MAP_TYPE);
    }

    private static GradlePropertyModel.ValueType extractAndGetValueType(@Nullable GradleDslElement element2) {
        if (element2 == null) {
            return GradlePropertyModel.ValueType.NONE;
        }
        if (element2 instanceof GradleDslExpressionMap) {
            return GradlePropertyModel.ValueType.MAP;
        }
        if (element2 instanceof GradleDslExpressionList) {
            return GradlePropertyModel.ValueType.LIST;
        }
        if (element2 instanceof GradleDslSimpleExpression && ((GradleDslSimpleExpression)element2).isInterpolated()) {
            return GradlePropertyModel.ValueType.INTERPOLATED;
        }
        if (element2 instanceof GradleDslSimpleExpression && ((GradleDslSimpleExpression)element2).isReference()) {
            return GradlePropertyModel.ValueType.REFERENCE;
        }
        if (element2 instanceof GradleDslMethodCall && (element2.getExternalSyntax() == ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT || element2.getElementType() == PropertyType.DERIVED) || element2 instanceof GradleDslUnknownElement) {
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        if (element2 instanceof GradleDslSimpleExpression) {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)element2;
            Object value2 = expression2.getValue();
            if (value2 instanceof Boolean) {
                return GradlePropertyModel.ValueType.BOOLEAN;
            }
            if (value2 instanceof Integer) {
                return GradlePropertyModel.ValueType.INTEGER;
            }
            if (value2 instanceof String) {
                return GradlePropertyModel.ValueType.STRING;
            }
            if (value2 instanceof BigDecimal) {
                return GradlePropertyModel.ValueType.BIG_DECIMAL;
            }
            if (value2 == null) {
                return GradlePropertyModel.ValueType.NONE;
            }
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        return GradlePropertyModel.ValueType.UNKNOWN;
    }

    @Nullable
    private <T> T extractValue(@NotNull TypeReference<T> typeReference, boolean resolved) {
        Object value2;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            element2 = this.getDefaultElement();
        }
        if (element2 == null) {
            return null;
        }
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType == GradlePropertyModel.ValueType.MAP) {
            value2 = this.getMap(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.LIST) {
            value2 = this.getList(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.REFERENCE) {
            ReferenceTo referenceVal;
            GradleDslSimpleExpression ref = (GradleDslSimpleExpression)element2;
            String refText = ref.getReferenceText();
            value2 = typeReference.getType() == Object.class || typeReference.getType() == ReferenceTo.class ? (refText != null ? ((referenceVal = ReferenceTo.createReferenceFromText(refText, this)) != null ? typeReference.castTo(referenceVal) : typeReference.castTo(new RawText(refText, refText))) : null) : (refText == null ? null : typeReference.castTo(refText));
        } else if (valueType == GradlePropertyModel.ValueType.INTERPOLATED && (typeReference == INTERPOLATED_TEXT_TYPE || typeReference == OBJECT_TYPE)) {
            Object extractedDslObject = this.getInterpolatedValueIfPossible();
            value2 = extractedDslObject == null ? null : typeReference.castTo(extractedDslObject);
        } else if (valueType == GradlePropertyModel.ValueType.UNKNOWN) {
            if (!(element2 instanceof GradleDslBlockElement)) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = element2 instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)element2).getCurrentElement() : element2.getPsiElement();
                if (psiElement == null) {
                    return null;
                }
                value2 = GradleDslElementImpl.getPsiText(psiElement);
            } else {
                value2 = element2.getFullName();
            }
        } else {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)element2;
            Object object = value2 = resolved ? expression2.getValue() : expression2.getUnresolvedValue();
        }
        if (value2 == null) {
            return null;
        }
        T result2 = typeReference.castTo(value2);
        if (result2 == null && typeReference.getType().equals(String.class)) {
            result2 = typeReference.castTo(value2.toString());
        }
        return result2;
    }

    private void makeEmptyMap() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.getName()));
        } else {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.myPropertyDescription));
        }
    }

    private void makeEmptyList() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.getName()));
        } else {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.myPropertyDescription));
        }
    }

    private void bindToNewElement(@NotNull GradleDslExpression newElement) {
        if (newElement == this.myElement) {
            return;
        }
        GradleDslElement element2 = this.getTransform().replace(this.myPropertyHolder, this.myElement, newElement, this.getName());
        if (element2 != null) {
            GradleDslElement copyFrom = this.myElement != null && this.myElement.getElementType() == PropertyType.FAKE ? ((FakeElement)this.myElement).getRealExpression() : this.myElement;
            element2.setElementType(this.myPropertyType);
            ModelEffectDescription effect = element2.getModelEffect();
            if (effect == null || effect.semantics != ModelSemanticsDescription.CREATE_WITH_VALUE) {
                if (copyFrom != null) {
                    element2.setExternalSyntax(copyFrom.getExternalSyntax());
                }
                if (copyFrom != null) {
                    element2.setModelEffect(copyFrom.getModelEffect());
                }
            }
            element2.setModified();
            this.myElement = element2;
        }
    }

    @Nullable
    public GradleDslElement getElement() {
        return this.getTransform().transform(this.myElement);
    }

    @Override
    @NotNull
    public GradleDslElement getHolder() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return this.myPropertyHolder;
        }
        GradleDslElement parent2 = element2.getParent();
        if (parent2 == null) {
            return this.myPropertyHolder;
        }
        return parent2;
    }

    @Override
    @Nullable
    public GradleDslElement getRawElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public GradleDslElement getRawPropertyHolder() {
        return this.myPropertyHolder;
    }

    @NotNull
    protected PropertyTransform getTransform() {
        for (PropertyTransform transform2 : this.myTransforms) {
            if (!transform2.test(this.myElement, this.myPropertyHolder)) continue;
            return transform2;
        }
        return PropertyUtil.DEFAULT_TRANSFORM;
    }

    protected PropertyTransform getTransformFor(@Nullable GradleDslElement element2) {
        for (PropertyTransform transform2 : this.myTransforms) {
            if (!transform2.test(element2, this.myPropertyHolder)) continue;
            return transform2;
        }
        return PropertyUtil.DEFAULT_TRANSFORM;
    }

    @NotNull
    List<GradlePropertyModelImpl> dependencies() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return Collections.emptyList();
        }
        return element2.getResolvedVariables().stream().map(injection -> {
            GradleDslElement injected = injection.getToBeInjected();
            return injected != null ? new GradlePropertyModelImpl(injected) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

