/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DependenciesModelImpl
extends GradleDslBlockModel
implements DependenciesModel {
    public static final Logger LOG = Logger.getInstance(DependenciesModelImpl.class);
    private static final Fetcher<ArtifactDependencyModel> ourArtifactFetcher = new Fetcher<ArtifactDependencyModel>(){

        @Override
        public void fetch(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull GradleDslElement resolved, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @NotNull List<? super ArtifactDependencyModel> dest) {
            ArtifactDependencyModelImpl.DynamicNotation notation;
            if (!(element2 instanceof GradleDslExpression)) {
                return;
            }
            String methodName = null;
            if (element2 instanceof GradleDslMethodCall) {
                List<GradleDslExpression> arguments2 = ((GradleDslMethodCall)element2).getArguments();
                methodName = ((GradleDslMethodCall)element2).getMethodName();
                if (arguments2.size() == 1 && Arrays.asList("platform", "enforcedPlatform").contains(methodName)) {
                    element2 = arguments2.get(0);
                    resolved = DependenciesModelImpl.resolveElement(element2);
                } else {
                    return;
                }
            }
            if ((element2 instanceof GradleDslSimpleExpression || resolved instanceof GradleDslExpressionMap) && (notation = ArtifactDependencyModelImpl.DynamicNotation.create(configurationName, (GradleDslExpression)element2, configurationElement, maintainer, methodName)) != null) {
                dest.add(notation);
                if (DependenciesModelImpl.isInVersionCatalogFile(resolved)) {
                    notation.markAsVersionCatalogDependency();
                    notation.enableSetThrough();
                }
            }
        }
    };
    private static final Fetcher<ModuleDependencyModel> ourModuleFetcher = new Fetcher<ModuleDependencyModel>(){

        @Override
        public void fetch(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull GradleDslElement resolved, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @NotNull List<? super ModuleDependencyModel> dest) {
            if (resolved instanceof GradleDslMethodCall) {
                ModuleDependencyModel model2;
                String platformMethodName = null;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)resolved;
                if (Arrays.asList("platform", "enforcedPlatform").contains(methodCall.getMethodName()) && methodCall.getArguments().size() == 1 && methodCall.getArguments().get(0) instanceof GradleDslMethodCall) {
                    platformMethodName = methodCall.getMethodName();
                    methodCall = (GradleDslMethodCall)methodCall.getArguments().get(0);
                }
                if (methodCall.getMethodName().equals("project") && (model2 = ModuleDependencyModelImpl.create(configurationName, methodCall, maintainer, platformMethodName)) != null && model2.path().getValueType() != GradlePropertyModel.ValueType.NONE) {
                    dest.add(model2);
                }
            }
        }
    };
    private static final Fetcher<FileDependencyModel> ourFileFetcher = new Fetcher<FileDependencyModel>(){

        @Override
        public void fetch(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull GradleDslElement resolved, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @NotNull List<? super FileDependencyModel> dest) {
            GradleDslMethodCall methodCall;
            if (resolved instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)resolved).getMethodName().equals("files")) {
                dest.addAll(FileDependencyModelImpl.create(configurationName, methodCall, maintainer));
            }
        }
    };
    private static final Fetcher<FileTreeDependencyModel> ourFileTreeFetcher = new Fetcher<FileTreeDependencyModel>(){

        @Override
        public void fetch(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull GradleDslElement resolved, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @NotNull List<? super FileTreeDependencyModel> dest) {
            FileTreeDependencyModel model2;
            GradleDslMethodCall methodCall;
            if (resolved instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)resolved).getMethodName().equals("fileTree") && (model2 = FileTreeDependencyModelImpl.create(methodCall, configurationName, maintainer)) != null && model2.dir().getValueType() != GradlePropertyModel.ValueType.NONE) {
                dest.add(model2);
            }
        }
    };
    private static final Fetcher<DependencyModel> ourAllFetcher = new Fetcher<DependencyModel>(){

        @Override
        public void fetch(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull GradleDslElement resolved, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @NotNull List<? super DependencyModel> dest) {
            ourArtifactFetcher.fetch(configurationName, element2, resolved, configurationElement, maintainer, dest);
            ourModuleFetcher.fetch(configurationName, element2, resolved, configurationElement, maintainer, dest);
            ourFileFetcher.fetch(configurationName, element2, resolved, configurationElement, maintainer, dest);
            ourFileTreeFetcher.fetch(configurationName, element2, resolved, configurationElement, maintainer, dest);
        }
    };
    private static final Map<String, Function<ArtifactDependencySpec, String>> COMPONENT_MAP = ImmutableMap.builder().put((Object)"name", ArtifactDependencySpec::getName).put((Object)"group", ArtifactDependencySpec::getGroup).put((Object)"version", ArtifactDependencySpec::getVersion).put((Object)"ext", ArtifactDependencySpec::getExtension).put((Object)"classifier", ArtifactDependencySpec::getClassifier).build();

    public DependenciesModelImpl(@NotNull DependenciesDslElement dslElement) {
        super(dslElement);
    }

    private static boolean isInVersionCatalogFile(GradleDslElement element2) {
        return element2.getDslFile() instanceof GradleVersionCatalogFile;
    }

    @Override
    @NotNull
    public List<DependencyModel> all() {
        return this.all(null, ourAllFetcher);
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        return this.all(configurationName, ourArtifactFetcher);
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        return this.all(null, ourArtifactFetcher);
    }

    @Override
    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpecImpl.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        ArtifactDependencySpecImpl dependency = ArtifactDependencySpecImpl.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addArtifact(configurationName, dependency);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference) {
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        this.addArtifact(configurationName, dependency, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, excludes);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull String compactNotation, boolean enforced) {
        ArtifactDependencySpecImpl dependency = ArtifactDependencySpecImpl.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addPlatformArtifact(configurationName, dependency, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference, boolean enforced) {
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, boolean enforced) {
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, enforced);
    }

    @Override
    public boolean replaceArtifactByPsiElement(@NotNull PsiElement psiElement, @NotNull ArtifactDependencySpec dependency) {
        GradleDslElement element2 = this.findByPsiElement(psiElement);
        if (element2 == null) {
            return false;
        }
        DependenciesModelImpl.performDependencyReplace(psiElement, element2, dependency);
        return true;
    }

    @Override
    @NotNull
    public List<ModuleDependencyModel> modules() {
        return this.all(null, ourModuleFetcher);
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path2) {
        this.addModule(configurationName, path2, null);
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path2, @Nullable String config2) {
        ModuleDependencyModelImpl.createNew(this.myDslElement, configurationName, path2, config2);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileTreeDependencyModel> fileTrees() {
        return this.all(null, ourFileTreeFetcher);
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir) {
        this.addFileTree(configurationName, dir, null, null);
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        FileTreeDependencyModelImpl.createNew(this.myDslElement, configurationName, dir, includes, excludes);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileDependencyModel> files() {
        return this.all(null, ourFileFetcher);
    }

    @Override
    public void addFile(@NotNull String configurationName, @NotNull String file2) {
        FileDependencyModelImpl.createNew(this.myDslElement, configurationName, file2);
    }

    @Override
    public void remove(@NotNull DependencyModel dependency) {
        if (!(dependency instanceof DependencyModelImpl)) {
            LOG.warn("Tried to remove an unknown dependency type: " + dependency);
            return;
        }
        GradleDslElement dependencyElement = ((DependencyModelImpl)dependency).getDslElement();
        GradleDslElement parent2 = dependencyElement.getParent();
        if (parent2 instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)parent2;
            List<GradleDslExpression> arguments2 = methodCall.getArguments();
            if (arguments2.size() == 1 && arguments2.get(0).equals(dependencyElement)) {
                this.myDslElement.removeProperty(methodCall);
            } else {
                methodCall.remove(dependencyElement);
            }
        } else if (parent2 instanceof GradleDslExpressionList) {
            List<GradleDslExpression> expressions = ((GradleDslExpressionList)parent2).getExpressions();
            if (expressions.size() == 1 && expressions.get(0).equals(dependencyElement)) {
                if (parent2.getParent() instanceof GradleDslMethodCall) {
                    this.myDslElement.removeProperty(parent2.getParent());
                } else {
                    this.myDslElement.removeProperty(parent2);
                }
            } else {
                ((GradleDslExpressionList)parent2).removeElement(dependencyElement);
            }
        } else {
            this.myDslElement.removeProperty(dependencyElement);
        }
    }

    @NotNull
    private <T extends DependencyModel> List<T> all(@Nullable String configurationName, @NotNull Fetcher<T> fetcher) {
        List<T> dependencies2 = fetcher.createCollector();
        for (GradleDslElement element2 : configurationName != null ? this.myDslElement.getPropertyElementsByName(configurationName) : this.myDslElement.getAllPropertyElements()) {
            this.collectFrom(element2.getName(), element2, fetcher, dependencies2);
        }
        return dependencies2;
    }

    private <T extends DependencyModel> void collectFrom(@NotNull String configurationName, @NotNull GradleDslElement element2, @NotNull Fetcher<T> byFetcher, @NotNull List<T> dest) {
        String name2;
        GradleDslClosure configurationElement = element2.getClosureElement();
        GradleDslElement resolved = DependenciesModelImpl.resolveElement(element2);
        if (resolved instanceof GradleDslExpressionList) {
            for (GradleDslExpression expression2 : ((GradleDslExpressionList)resolved).getExpressions()) {
                GradleDslElement gradleDslElement = DependenciesModelImpl.resolveElement(expression2);
                byFetcher.fetch(configurationName, expression2, gradleDslElement, configurationElement, Maintainers.EXPRESSION_LIST_MAINTAINER, dest);
            }
            return;
        }
        if (resolved instanceof GradleDslMethodCall && (name2 = ((GradleDslMethodCall)resolved).getMethodName()).equals(configurationName)) {
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)resolved).getArguments()) {
                GradleDslElement resolvedArgument = DependenciesModelImpl.resolveElement(gradleDslElement);
                byFetcher.fetch(configurationName, gradleDslElement, resolvedArgument, configurationElement, Maintainers.ARGUMENT_LIST_MAINTAINER, dest);
            }
            return;
        }
        byFetcher.fetch(configurationName, element2, resolved, configurationElement, Maintainers.SINGLE_ITEM_MAINTAINER, dest);
    }

    @NotNull
    private static GradleDslElement resolveElement(@NotNull GradleDslElement element2) {
        GradleDslElement resolved = element2;
        GradleDslElement foundElement = PropertyUtil.followElement(element2);
        if (foundElement instanceof GradleDslExpression) {
            resolved = foundElement;
        }
        return resolved;
    }

    private static void performDependencyReplace(@NotNull PsiElement psiElement, @NotNull GradleDslElement element2, @NotNull ArtifactDependencySpec dependency) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(element2 instanceof GradleDslLiteral)) break block2;
                        ((GradleDslLiteral)element2).setValue(dependency.compactNotation());
                        break block3;
                    }
                    if (!(element2 instanceof GradleDslExpressionMap)) break block4;
                    DependenciesModelImpl.updateGradleExpressionMapWithDependency((GradleDslExpressionMap)element2, dependency);
                    break block3;
                }
                if (!(element2 instanceof GradleDslMethodCall)) break block5;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element2;
                for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                    if (gradleDslElement.getPsiElement() != psiElement) continue;
                    DependenciesModelImpl.performDependencyReplace(psiElement, gradleDslElement, dependency);
                }
                break block3;
            }
            if (!(element2 instanceof GradleDslExpressionList)) break block3;
            for (GradleDslSimpleExpression expression2 : ((GradleDslExpressionList)element2).getSimpleExpressions()) {
                if (element2.getPsiElement() != psiElement) continue;
                DependenciesModelImpl.performDependencyReplace(psiElement, expression2, dependency);
            }
        }
    }

    private static void updateGradleExpressionMapWithDependency(@NotNull GradleDslExpressionMap map2, @NotNull ArtifactDependencySpec dependency) {
        LinkedHashMap<String, Function<ArtifactDependencySpec, String>> properties2 = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>(COMPONENT_MAP);
        for (Map.Entry<String, GradleDslElement> entry : map2.getPropertyElements().entrySet()) {
            if (properties2.containsKey(entry.getKey())) {
                String value2 = (String)((Function)properties2.get(entry.getKey())).fun((Object)dependency);
                if (value2 == null) continue;
                map2.setNewLiteral(entry.getKey(), value2);
                properties2.remove(entry.getKey());
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
        for (Map.Entry<String, GradleDslElement> entry : properties2.entrySet()) {
            String value2 = (String)((Function)entry.getValue()).fun((Object)dependency);
            if (value2 != null) {
                map2.addNewLiteral(entry.getKey(), value2);
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
    }

    private static boolean isChildOfParent(@NotNull PsiElement child, @NotNull PsiElement parent2) {
        ArrayList childElements = Lists.newArrayList((Object[])new PsiElement[]{parent2});
        while (!childElements.isEmpty()) {
            PsiElement element2 = (PsiElement)childElements.remove(0);
            if (element2.equals(child)) {
                return true;
            }
            childElements.addAll(Arrays.asList(element2.getChildren()));
        }
        return false;
    }

    @Nullable
    private GradleDslElement findByPsiElement(@NotNull PsiElement child) {
        for (String configurationName : this.myDslElement.getProperties()) {
            for (GradleDslElement element2 : this.myDslElement.getPropertyElementsByName(configurationName)) {
                if (element2 instanceof GradleDslMethodCall) {
                    GradleDslMethodCall methodCall = (GradleDslMethodCall)element2;
                    for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                        if (gradleDslElement.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, gradleDslElement.getPsiElement())) continue;
                        return gradleDslElement;
                    }
                    continue;
                }
                if (element2 instanceof GradleDslExpressionList) {
                    for (GradleDslSimpleExpression e : ((GradleDslExpressionList)element2).getSimpleExpressions()) {
                        if (e.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, e.getPsiElement())) continue;
                        return e;
                    }
                    continue;
                }
                if (element2.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, element2.getPsiElement())) continue;
                return element2;
            }
        }
        return null;
    }

    private static interface Fetcher<T extends DependencyModel> {
        default public List<T> createCollector() {
            return new ArrayList();
        }

        public void fetch(@NotNull String var1, @NotNull GradleDslElement var2, @NotNull GradleDslElement var3, @Nullable GradleDslClosure var4, @NotNull DependencyModelImpl.Maintainer var5, @NotNull List<? super T> var6);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Maintainers implements DependencyModelImpl.Maintainer
    {
        EXPRESSION_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslExpressionList nameHolder = parentList;
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index2 = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.get(0) == dslElement && expressions.get(1) instanceof GradleDslExpressionMap) {
                    UnsupportedOperationException t = new UnsupportedOperationException("Changing the configuration name of a multi-entry dependency declaration containing map-notations is not supported.");
                    LOG.warn((Throwable)t);
                    return null;
                }
                GradleDslExpression copiedElement = ((GradleDslExpression)dslElement).copy();
                copiedElement.getNameElement().rename(newConfigurationName);
                dependencyModel.setDslElement(copiedElement);
                dependenciesElement.addNewElementAt(index2, copiedElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        ARGUMENT_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslElement nameHolder = parentList.getParent();
                GradleNameElement nameElement = nameHolder.getNameElement();
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index2 = dependenciesElement.getAllElements().indexOf(nameHolder);
                GradleDslExpression copiedElement = ((GradleDslExpression)dslElement).copy();
                copiedElement.getNameElement().rename(newConfigurationName);
                dependencyModel.setDslElement(copiedElement);
                dependenciesElement.addNewElementAt(index2, copiedElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        SINGLE_ITEM_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                Maintainers.renameSingleElementConfiguration(dslElement, newConfigurationName);
                return this;
            }
        }
        ,
        DEEP_EXPRESSION_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                List<GradleDslExpression> declarationExpressions;
                GradleDslExpressionList declarationExpressionList;
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                GradleDslExpressionList nameHolder = declarationExpressionList = (GradleDslExpressionList)methodCall.getParent();
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index2 = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.size() == 1 && (declarationExpressions = declarationExpressionList.getExpressions()).size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index2, copiedMethodElement);
                if (expressions.size() == 1) {
                    declarationExpressionList.removeElement(methodCall);
                } else {
                    parentList.removeElement(dslElement);
                }
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        DEEP_ARGUMENT_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                List<GradleDslExpression> declarationMethodExpressions;
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                GradleDslExpressionList declarationMethodArguments = (GradleDslExpressionList)methodCall.getParent();
                GradleDslMethodCall nameHolder = (GradleDslMethodCall)declarationMethodArguments.getParent();
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index2 = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.size() == 1 && (declarationMethodExpressions = declarationMethodArguments.getExpressions()).size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index2, copiedMethodElement);
                if (expressions.size() == 1) {
                    declarationMethodArguments.removeElement(methodCall);
                } else {
                    parentList.removeElement(dslElement);
                }
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        DEEP_SINGLE_ITEM_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(methodCall, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall nameHolder = methodCall;
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index2 = dependenciesElement.getAllElements().indexOf(nameHolder);
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index2, copiedMethodElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        };


        private static void renameSingleElementConfiguration(@NotNull GradleDslElement dslElement, @NotNull String newConfigurationName) {
            GradleDslMethodCall methodCall;
            if (dslElement instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)dslElement).getMethodName().equals(dslElement.getNameElement().name())) {
                methodCall.setMethodName(newConfigurationName);
            }
            dslElement.getNameElement().rename(newConfigurationName);
            dslElement.setModified();
        }
    }
}

