/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    public ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file2, @NotNull BuildModelContext buildModelContext) {
        this.myBuildModelContext = buildModelContext;
        this.myProjectBuildFile = this.myBuildModelContext.initializeContext(project, file2);
    }

    @Override
    @NotNull
    public BuildModelContext getContext() {
        return this.myBuildModelContext;
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : new GradleBuildModelImpl(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module2) {
        VirtualFile file2 = this.myBuildModelContext.getGradleBuildFile(module2);
        return file2 == null ? null : this.getModuleBuildModel(file2);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file2 = this.myBuildModelContext.getGradleBuildFile(modulePath);
        return file2 == null ? null : this.getModuleBuildModel(file2);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file2) {
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file2, false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Nullable
    private VirtualFile getProjectSettingsFile() {
        VirtualFile virtualFile = this.myProjectBuildFile == null ? this.myBuildModelContext.getProjectSettingsFile() : this.myProjectBuildFile.tryToFindSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    @Override
    public void applyChanges() {
        this.runOverProjectTree(file2 -> {
            file2.applyChanges();
            file2.saveAllChanges();
        });
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        List<GradleDslFile> files2 = this.myBuildModelContext.getAllRequestedFiles();
        files2.forEach(GradleDslFile::reparse);
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        return this.getAllIncludedBuildModels((i, j) -> {});
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels(@NotNull BiConsumer<Integer, Integer> func) {
        GradleSettingsModel settingsModel;
        File buildSrc;
        VirtualFile buildSrcVirtualFile;
        Integer[] nModelsSeen = new Integer[]{0};
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(new GradleBuildModelImpl(this.myProjectBuildFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((buildSrcVirtualFile = this.myBuildModelContext.getGradleBuildFile(buildSrc = new File(FileUtil.toCanonicalPath((String)Optional.ofNullable(this.myBuildModelContext.getProject().getBasePath()).orElse("")), "buildSrc"))) != null) {
            allModels.add(this.getModuleBuildModel(buildSrcVirtualFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            return allModels;
        }
        Set<String> modulePaths = settingsModel.modulePaths();
        Integer nModelsToConsider = nModelsSeen[0] + modulePaths.size();
        allModels.addAll(modulePaths.stream().map(modulePath -> {
            VirtualFile file2;
            File moduleDir;
            GradleBuildModel model2 = null;
            if (!modulePath.equals(":") && (moduleDir = settingsModel.moduleDirectory((String)modulePath)) != null && (file2 = this.myBuildModelContext.getGradleBuildFile(moduleDir)) != null) {
                model2 = this.getModuleBuildModel(file2);
            }
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], nModelsToConsider);
            return model2;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return allModels;
    }

    @Override
    @NotNull
    public GradleVersionCatalogsModel getVersionCatalogsModel() {
        Set<GradleVersionCatalogFile> files2 = this.getContext().getVersionCatalogFiles();
        return new GradleVersionCatalogsModelImpl(files2);
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }
}

