/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.InexpressiblePropertyTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.InfixPropertyTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.LiteralToInfixTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PluginAliasTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PluginNameTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginModelImpl
implements PluginModel {
    @NonNls
    public static final String ALIAS = "alias";
    @NonNls
    private static final String APPLY = "apply";
    @NonNls
    public static final String ID = "id";
    @NonNls
    public static final String KOTLIN = "kotlin";
    @NonNls
    public static final String PLUGIN = "plugin";
    @NonNls
    private static final String VERSION = "version";
    @NotNull
    private final GradleDslElement myCompleteElement;

    @NotNull
    public static List<PluginModelImpl> create(@NotNull GradlePropertiesDslElement dslElement) {
        List<GradleDslElement> elements = dslElement.getAllPropertyElements();
        ArrayList<PluginModelImpl> results2 = new ArrayList<PluginModelImpl>();
        for (GradleDslElement e : elements) {
            if (e instanceof GradleDslSimpleExpression || e instanceof GradleDslExpressionMap || e instanceof GradleDslInfixExpression) {
                results2.add(new PluginModelImpl(e));
                continue;
            }
            if (!(e instanceof GradleDslExpressionList)) continue;
            GradleDslExpressionList element2 = (GradleDslExpressionList)e;
            for (GradleDslSimpleExpression item2 : element2.getSimpleExpressions()) {
                results2.add(new PluginModelImpl(item2));
            }
        }
        return results2;
    }

    public static Map<String, PluginModelImpl> deduplicatePlugins(@NotNull List<PluginModelImpl> models) {
        LinkedHashMap<String, PluginModelImpl> modelMap = new LinkedHashMap<String, PluginModelImpl>();
        for (PluginModelImpl model2 : models) {
            ResolvedPropertyModel propertyModel = model2.name();
            if (propertyModel.getValueType() != GradlePropertyModel.ValueType.STRING) continue;
            modelMap.put(propertyModel.forceString(), model2);
        }
        return modelMap;
    }

    public static void removePlugins(@NotNull List<PluginModelImpl> models, @NotNull String name2) {
        for (PluginModelImpl model2 : models) {
            if (!name2.equals(model2.name().toString())) continue;
            model2.remove();
        }
    }

    public PluginModelImpl(@NotNull GradleDslElement completeElement) {
        this.myCompleteElement = completeElement;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel name() {
        return GradlePropertyModelBuilder.create(this.myCompleteElement).addTransform(new PluginAliasTransform(ID, ArtifactDependencySpec::getName, ArtifactDependencySpecImpl::setName)).addTransform(new PluginNameTransform()).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel version() {
        return GradlePropertyModelBuilder.create(this.myCompleteElement).addTransform(new PluginAliasTransform(VERSION, ArtifactDependencySpec::getVersion, ArtifactDependencySpecImpl::setVersion)).addTransform(new LiteralToInfixTransform(VERSION)).addTransform(new InfixPropertyTransform(VERSION)).addTransform(new InexpressiblePropertyTransform()).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel apply() {
        return GradlePropertyModelBuilder.create(this.myCompleteElement).addTransform(new LiteralToInfixTransform(APPLY)).addTransform(new InfixPropertyTransform(APPLY)).addTransform(new InexpressiblePropertyTransform()).buildResolved();
    }

    @Override
    public void remove() {
        PropertyUtil.removeElement(this.myCompleteElement);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myCompleteElement.getPsiElement();
    }
}

