/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.settings.VersionCatalogModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleDslModelExperimentalSettings;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.AndroidGradlePluginVersion;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.utils.BuildScriptUtil;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleBuildFile myRootProjectFile;
    @Nullable
    private AndroidGradlePluginVersion agpVersion;
    @NotNull
    private final Set<GradleVersionCatalogFile> myVersionCatalogFiles = new LinkedHashSet<GradleVersionCatalogFile>();

    public void setRootProjectFile(@NotNull GradleBuildFile rootProjectFile) {
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleBuildFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    public void setAgpVersion(@Nullable AndroidGradlePluginVersion agpVersion) {
        this.agpVersion = agpVersion;
    }

    @Nullable
    public AndroidGradlePluginVersion getAgpVersion() {
        return this.agpVersion;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        return new BuildModelContext(project, resolvedConfigurationFileLocationProvider);
    }

    private BuildModelContext(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myResolvedConfigurationFileLocationProvider = resolvedConfigurationFileLocationProvider;
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        return this.myDependencyManager;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file2) {
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file2, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file2, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap = this.myNotifications.computeIfAbsent(file2, f -> MutableClassToInstanceMap.create());
        if (notificationMap.containsKey(type.getClazz())) {
            return (T)((BuildModelNotification)notificationMap.getInstance(type.getClazz()));
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        return (T)notification;
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myFileCache.getCurrentParsingRoot();
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, @NotNull String name2, boolean isApplied) {
        return this.myFileCache.getOrCreateBuildFile(file2, name2, this, isApplied);
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, boolean isApplied) {
        return this.getOrCreateBuildFile(file2, file2.getName(), isApplied);
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        return this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file2, @NotNull String moduleName2) {
        return this.myFileCache.getOrCreatePropertiesFile(file2, moduleName2, this);
    }

    @NotNull
    public GradleVersionCatalogFile getOrCreateVersionCatalogFile(@NotNull VirtualFile file2, @NotNull String catalogName) {
        return this.myFileCache.getOrCreateVersionCatalogFile(file2, catalogName, this);
    }

    @NotNull
    public GradleBuildFile parseBuildFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String moduleName2, boolean isApplied) {
        GradleBuildFile buildDslFile = new GradleBuildFile(file2, project, moduleName2, this);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                GradleSettingsModel gradleSettingsModel = this.getSettingsModel(buildDslFile);
                this.populateWithParentModuleSubProjectsProperties(buildDslFile, gradleSettingsModel);
            }
            this.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        return buildDslFile;
    }

    @Nullable
    public GradleBuildFile initializeContext(@NotNull Project project, @Nullable VirtualFile file2) {
        GradleBuildFile result2;
        GradleBuildFile gradleBuildFile = result2 = file2 != null ? new GradleBuildFile(file2, project, ":", this) : null;
        if (result2 != null) {
            this.setRootProjectFile(result2);
            ApplicationManager.getApplication().runReadAction(() -> {
                GradleSettingsModel gradleSettingsModel = this.getSettingsModel(result2);
                this.populateWithParentModuleSubProjectsProperties(result2, gradleSettingsModel);
                this.populateSiblingDslFileWithGradlePropertiesFile(result2);
                this.populateVersionCatalogFiles(gradleSettingsModel);
                result2.parse();
            });
            this.putBuildFile(file2.getUrl(), result2);
        } else {
            ApplicationManager.getApplication().runReadAction(() -> {
                VirtualFile maybeSettingsFile = this.getProjectSettingsFile();
                if (maybeSettingsFile != null) {
                    GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
                    this.populateVersionCatalogFiles(new GradleSettingsModelImpl(settingsFile));
                }
            });
        }
        return result2;
    }

    private void putBuildFile(@NotNull String name2, @NotNull GradleBuildFile buildFile) {
        this.myFileCache.putBuildFile(name2, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        return this.myFileCache.getAllFiles();
    }

    @NotNull
    public Set<GradleVersionCatalogFile> getVersionCatalogFiles() {
        return this.myVersionCatalogFiles;
    }

    private void populateVersionCatalogFiles(@Nullable GradleSettingsModel gradleSettingsModel) {
        if (!GradleDslModelExperimentalSettings.getInstance().isVersionCatalogEnabled()) {
            return;
        }
        if (gradleSettingsModel == null) {
            this.checkVersionCatalog("gradle/libs.versions.toml", "libs").ifPresent(this.myVersionCatalogFiles::add);
            return;
        }
        for (VersionCatalogModel versionCatalogModel2 : gradleSettingsModel.dependencyResolutionManagement().versionCatalogs()) {
            String from = versionCatalogModel2.from().getValue(GradlePropertyModel.STRING_TYPE);
            if (from == null) continue;
            this.checkVersionCatalog(from, versionCatalogModel2.getName()).ifPresent(this.myVersionCatalogFiles::add);
        }
    }

    private Optional<GradleVersionCatalogFile> checkVersionCatalog(String filePath, String name2) {
        @SystemIndependent String fromPath = FileUtil.toSystemIndependentName((String)filePath);
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        @SystemIndependent String path2 = String.join((CharSequence)"/", rootPath, fromPath);
        VirtualFile versionCatalogFile = VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)path2)), (boolean)false);
        if (versionCatalogFile == null) {
            return Optional.empty();
        }
        return Optional.of(this.getOrCreateVersionCatalogFile(versionCatalogFile, name2));
    }

    private void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile) {
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)false);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = this.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModelImpl propertiesModel = new GradlePropertiesModelImpl(parsedProperties);
        GradlePropertiesFile propertiesDslFile = propertiesModel.myGradlePropertiesFile;
        buildDslFile.setPropertiesFile(propertiesDslFile);
    }

    @Nullable
    private GradleSettingsModel getSettingsModel(@NotNull GradleBuildFile buildDslFile) {
        VirtualFile maybeSettingsFile = buildDslFile.tryToFindSettingsFile();
        if (maybeSettingsFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    private void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile, @Nullable GradleSettingsModel gradleSettingsModel) {
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleBuildFile parentModuleDslFile = parentModuleModelImpl.myGradleBuildFile;
        buildDslFile.setParentModuleBuildFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement(SubProjectsDslElement.SUBPROJECTS);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.addAppliedProperty(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            GradleDslElement element2 = entry.getValue();
            if (element2 instanceof ApplyDslElement) {
                ApplyDslElement subProjectsApply = (ApplyDslElement)element2;
                ApplyDslElement myApply = new ApplyDslElement(buildDslFile, buildDslFile);
                buildDslFile.setParsedElement(myApply);
                for (GradleDslElement appliedElement : subProjectsApply.getAllElements()) {
                    myApply.addParsedElement(appliedElement);
                }
                continue;
            }
            buildDslFile.addAppliedProperty(this.dslTreeCopy(element2, buildDslFile));
        }
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element2, GradleDslElement parent2) {
        return this.dslTreeCopy(element2, parent2, new HashMap<GradleDslElement, GradleDslElement>());
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element2, GradleDslElement parent2, Map<GradleDslElement, GradleDslElement> seen) {
        GradleDslElement result2;
        GradleDslElement previous = seen.get(element2);
        if (previous != null) {
            return previous;
        }
        if (element2 instanceof DescribedGradlePropertiesDslElement) {
            PropertiesElementDescription description2 = ((DescribedGradlePropertiesDslElement)((Object)element2)).getDescription();
            Object myProperties = description2.constructor.construct(parent2, GradleNameElement.copy(element2.getNameElement()));
            result2 = myProperties;
            seen.put(element2, result2);
            for (GradleDslElement subElement : ((GradlePropertiesDslElement)element2).getAllElements()) {
                ((GradlePropertiesDslElement)myProperties).addAppliedProperty(this.dslTreeCopy(subElement, (GradleDslElement)myProperties, seen));
            }
        } else {
            result2 = element2;
            seen.put(element2, result2);
        }
        return result2;
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull Module module2) {
        VirtualFile result2 = this.myResolvedConfigurationFileLocationProvider.getGradleBuildFile(module2);
        if (result2 != null) {
            return result2;
        }
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(module2);
        if (rootPath == null) {
            return null;
        }
        File moduleRoot = new File(FileUtil.toSystemDependentName((String)rootPath));
        return this.getGradleBuildFile(moduleRoot);
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile(dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath = BuildScriptUtil.findGradleSettingsFile(dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public VirtualFile getProjectSettingsFile() {
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        if (rootPath == null) {
            return null;
        }
        return this.getGradleSettingsFile(new File(FileUtil.toSystemDependentName((String)rootPath)));
    }

    @Nullable
    public VirtualFile getVersionCatalogFile(@NotNull File dirPath, @NotNull String name2) {
        File versionCatalogFilePath = new File(dirPath, name2 + ".versions.toml");
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)versionCatalogFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public VirtualFile getVersionCatalogFile(@NotNull String name2) {
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        if (rootPath == null) {
            return null;
        }
        return this.getVersionCatalogFile(new File(FileUtil.toSystemDependentName((String)rootPath), "gradle"), name2);
    }

    public static interface ResolvedConfigurationFileLocationProvider {
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project var1);
    }
}

