/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.VersionCatalogNamingUtilKt;
import com.android.tools.idea.gradle.dependencies.AddDependencyPolicy;
import com.android.tools.idea.gradle.dependencies.ConfigurationNameMapper;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.catalog.GradleVersionCatalogLibraries;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.LibraryDeclarationModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.LibraryDeclarationSpec;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Objects;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)project.getService(GradleDependencyManager.class);
    }

    protected CatalogDependenciesInfo computeCatalogDependenciesInfo(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2, GradleVersionCatalogModel catalogModel) {
        Project project = module2.getProject();
        GradleBuildModel moduleModel = ProjectBuildModel.get(project).getModuleBuildModel(module2);
        List<ArtifactDependencyModel> compileDependencies = moduleModel != null ? moduleModel.dependencies().artifacts() : null;
        String appCompatVersion = GradleDependencyManager.getAppCompatVersion(compileDependencies);
        CatalogDependenciesInfo searchResult = new CatalogDependenciesInfo();
        GradleVersionCatalogLibraries libraries2 = catalogModel.libraryDeclarations();
        for (GradleCoordinate coordinate : dependencies2) {
            if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) continue;
            Optional<GradleCoordinate> resolvedCoordinate = this.resolveCoordinate(project, coordinate, appCompatVersion);
            GradleCoordinate finalCoordinate = resolvedCoordinate.orElse(coordinate);
            if (libraries2 == null) {
                searchResult.missingLibraries.add(finalCoordinate);
                continue;
            }
            Optional<Pair> maybeCoordinate = libraries2.getAll().entrySet().stream().filter(entry -> {
                LibraryDeclarationSpec spec = ((LibraryDeclarationModel)entry.getValue()).getSpec();
                return Objects.equal((Object)spec.getGroup(), (Object)coordinate.getGroupId()) && Objects.equal((Object)spec.getName(), (Object)coordinate.getArtifactId()) && Objects.equal((Object)spec.getVersion(), (Object)coordinate.getRevision());
            }).map(dep -> new Pair((Object)((String)dep.getKey()), (Object)coordinate)).findFirst();
            if (maybeCoordinate.isEmpty()) {
                searchResult.missingLibraries.add(finalCoordinate);
                continue;
            }
            searchResult.matchedCoordinates.add((Pair<String, GradleCoordinate>)maybeCoordinate.get());
        }
        return searchResult;
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        Project project = module2.getProject();
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module2);
        GradleBuildModel buildModel = ProjectBuildModel.get(project).getModuleBuildModel(module2);
        if (gradleModel == null && buildModel == null) {
            return Collections.emptyList();
        }
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts() : null;
        String appCompatVersion = GradleDependencyManager.getAppCompatVersion(compileDependencies);
        ArrayList<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        for (GradleCoordinate coordinate : dependencies2) {
            if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) continue;
            Optional<GradleCoordinate> resolvedCoordinate = this.resolveCoordinate(project, coordinate, appCompatVersion);
            GradleCoordinate finalCoordinate = resolvedCoordinate.orElse(coordinate);
            boolean dependencyFound = compileDependencies != null && compileDependencies.stream().anyMatch(d -> Objects.equal((Object)d.group().toString(), (Object)finalCoordinate.getGroupId()) && d.name().forceString().equals(finalCoordinate.getArtifactId()));
            if (dependencyFound) continue;
            missingLibraries.add(finalCoordinate);
        }
        return missingLibraries;
    }

    private static String getAppCompatVersion(List<ArtifactDependencyModel> compileDependencies) {
        String appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", (Object)dependency.group().toString()) || Objects.equal((Object)"multidex", (Object)dependency.name().forceString())) continue;
                String s = dependency.version().toString();
                if (s == null) break;
                appCompatVersion = s;
                break;
            }
        }
        return appCompatVersion;
    }

    private Optional<GradleCoordinate> resolveCoordinate(Project project, GradleCoordinate coordinate, String appCompatVersion) {
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project, null);
        if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
            resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion));
        }
        return Optional.of(resolvedCoordinate != null ? resolvedCoordinate : coordinate);
    }

    @TestOnly
    public boolean addDependenciesAndSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        AddDependencyPolicy policy = AddDependencyPolicy.calculateAddDependencyPolicy(ProjectBuildModel.get(module2.getProject()));
        boolean result2 = this.addDependenciesInTransaction(module2, dependencies2, policy, null);
        GradleDependencyManager.requestProjectSync(module2.getProject(), GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_ADDED);
        return result2;
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        AddDependencyPolicy policy = AddDependencyPolicy.calculateAddDependencyPolicy(ProjectBuildModel.get(module2.getProject()));
        return this.addDependenciesInTransaction(module2, dependencies2, policy, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable ConfigurationNameMapper nameMapper) {
        AddDependencyPolicy policy = AddDependencyPolicy.calculateAddDependencyPolicy(ProjectBuildModel.get(module2.getProject()));
        return this.addDependenciesInTransaction(module2, dependencies2, policy, nameMapper);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module2, @NotNull List<GradleCoordinate> dependencies2) {
        GradleBuildModel buildModel = ProjectBuildModel.get(module2.getProject()).getModuleBuildModel(module2);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module2, dependencies2);
        return true;
    }

    private static List<Pair<String, GradleCoordinate>> addCatalogLibraries(@NotNull GradleVersionCatalogModel catalogModel, @NotNull List<GradleCoordinate> coordinates) {
        ArrayList<Pair<String, GradleCoordinate>> addedCoordinates = new ArrayList<Pair<String, GradleCoordinate>>();
        GradleVersionCatalogLibraries libraries2 = catalogModel.libraryDeclarations();
        Set<String> names = libraries2.getAllAliases();
        for (GradleCoordinate coordinate : coordinates) {
            String alias = VersionCatalogNamingUtilKt.pickLibraryVariableName((GradleCoordinate)coordinate, (boolean)false, names);
            libraries2.addDeclaration(alias, coordinate.toString());
            names.add(alias);
            addedCoordinates.add((Pair<String, GradleCoordinate>)new Pair((Object)alias, (Object)coordinate));
        }
        return addedCoordinates;
    }

    private static void addCatalogReferences(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<Pair<String, GradleCoordinate>> namedCoordinates, @NotNull GradleVersionCatalogModel catalogModel, @Nullable ConfigurationNameMapper nameMapper) {
        DependenciesModel dependenciesModel = buildModel.dependencies();
        for (Pair<String, GradleCoordinate> namedCoordinate : namedCoordinates) {
            String name2 = "compile";
            if (nameMapper != null) {
                name2 = nameMapper.mapName(module2, name2, (GradleCoordinate)namedCoordinate.getSecond());
            }
            name2 = GradleUtil.mapConfigurationName(name2, GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(module2), false);
            String alias = (String)namedCoordinate.getFirst();
            ReferenceTo reference = new ReferenceTo(catalogModel.libraries().findProperty(alias), dependenciesModel);
            dependenciesModel.addArtifact(name2, reference);
        }
    }

    private boolean addDependenciesInTransaction(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> coordinates, @NotNull AddDependencyPolicy policy, @Nullable ConfigurationNameMapper nameMapper) {
        Project project = module2.getProject();
        GradleBuildModel buildModel = ProjectBuildModel.get(project).getModuleBuildModel(module2);
        if (buildModel == null) {
            return false;
        }
        switch (policy) {
            case BUILD_FILE: {
                WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
                    List<GradleCoordinate> missing = this.findMissingDependencies(module2, coordinates);
                    if (missing.isEmpty()) {
                        return;
                    }
                    GradleDependencyManager.addDependenciesToBuildFile(buildModel, module2, missing, nameMapper);
                });
                break;
            }
            case VERSION_CATALOG: {
                GradleVersionCatalogsModel catalog = ProjectBuildModel.get(project).getVersionCatalogsModel();
                GradleVersionCatalogModel catalogModel = catalog.getVersionCatalogModel("libs");
                WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
                    List<GradleCoordinate> missingFromModule = this.findMissingDependencies(module2, coordinates);
                    if (missingFromModule.isEmpty()) {
                        return;
                    }
                    CatalogDependenciesInfo catalogSearchResult = this.computeCatalogDependenciesInfo(module2, missingFromModule, catalogModel);
                    GradleDependencyManager.addDependenciesToCatalogAndModuleBuildFile(module2, nameMapper, buildModel, catalogModel, catalogSearchResult);
                });
            }
        }
        return true;
    }

    private static void addDependenciesToCatalogAndModuleBuildFile(@NotNull Module module2, @Nullable ConfigurationNameMapper nameMapper, GradleBuildModel buildModel, GradleVersionCatalogModel catalogModel, CatalogDependenciesInfo catalogSearchResult) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            List<Pair<String, GradleCoordinate>> addedCoordinates = GradleDependencyManager.addCatalogLibraries(catalogModel, catalogSearchResult.missingLibraries);
            ArrayList<Pair<String, GradleCoordinate>> allCoordinates = new ArrayList<Pair<String, GradleCoordinate>>(catalogSearchResult.matchedCoordinates);
            allCoordinates.addAll(addedCoordinates);
            GradleDependencyManager.addCatalogReferences(buildModel, module2, allCoordinates, catalogModel, nameMapper);
            catalogModel.applyChanges();
            buildModel.applyChanges();
        });
    }

    private static void addDependenciesToBuildFile(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates, @Nullable ConfigurationNameMapper nameMapper) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name2 = "compile";
                if (nameMapper != null) {
                    name2 = nameMapper.mapName(module2, name2, coordinate);
                }
                name2 = GradleUtil.mapConfigurationName(name2, GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(module2), false);
                dependenciesModel.addArtifact(name2, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates) {
        assert (!coordinates.isEmpty());
        Project project = module2.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> GradleDependencyManager.updateDependencies(buildModel, module2, coordinates));
    }

    private static void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        GradleSyncInvoker.Request request2 = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request2, null);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList<ArtifactDependencyModel> artifacts = new ArrayList<ArtifactDependencyModel>(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (!gc.getGroupId().equals(m.group().toString()) || !gc.getArtifactId().equals(m.name().forceString()) || gc.getRevision().equals(m.version().toString())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    static class CatalogDependenciesInfo {
        public List<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        public List<Pair<String, GradleCoordinate>> matchedCoordinates = new ArrayList<Pair<String, GradleCoordinate>>();

        CatalogDependenciesInfo() {
        }
    }
}

