/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.annotations.NotNull;

public class SyncProjectAction
extends AndroidStudioGradleAction
implements DumbAware {
    private final NotNullLazyValue<GradleSyncInvoker> mySyncInvoker;

    public SyncProjectAction() {
        this("Sync Project with _Gradle Files");
    }

    protected SyncProjectAction(@NotNull String text2) {
        super(text2);
        this.mySyncInvoker = NotNullLazyValue.createValue(() -> GradleSyncInvoker.getInstance());
    }

    @VisibleForTesting
    SyncProjectAction(@NotNull String text2, @NotNull GradleSyncInvoker syncInvoker) {
        super(text2);
        this.mySyncInvoker = NotNullLazyValue.createConstantValue((Object)syncInvoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        try {
            ((GradleSyncInvoker)this.mySyncInvoker.getValue()).requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_SYNC_ACTION), null);
        }
        finally {
            presentation.setEnabled(true);
        }
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        boolean enabled2 = !GradleSyncState.getInstance(project).isSyncInProgress();
        e.getPresentation().setEnabled(enabled2);
    }
}

