/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.library.LibraryPropertiesDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPropertiesAction
extends AnAction {
    public LibraryPropertiesAction() {
        super("Library Properties...", null, AllIcons.Actions.Properties);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(LibraryPropertiesAction.findLibrary(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Library library = LibraryPropertiesAction.findLibrary(e);
        if (library != null) {
            Project project = e.getProject();
            assert (project != null);
            LibraryPropertiesDialog dialog2 = new LibraryPropertiesDialog(project, library);
            if (dialog2.showAndGet()) {
                dialog2.applyChanges();
            }
        }
    }

    @Nullable
    private static Library findLibrary(@NotNull AnActionEvent e) {
        String libraryName;
        NamedLibraryElementNode node;
        Project project;
        if (IdeInfo.getInstance().isAndroidStudio() && (project = e.getProject()) != null && (node = LibraryPropertiesAction.findLibraryNode(e.getDataContext())) != null && StringUtil.isNotEmpty((String)(libraryName = node.getName()))) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
            return libraryTable.getLibraryByName(libraryName);
        }
        return null;
    }

    @Nullable
    private static NamedLibraryElementNode findLibraryNode(@NotNull DataContext dataContext) {
        Navigatable navigatable;
        Navigatable[] navigatables = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
        if (navigatables != null && navigatables.length == 1 && (navigatable = navigatables[0]) instanceof NamedLibraryElementNode) {
            return (NamedLibraryElementNode)navigatable;
        }
        return null;
    }
}

