/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.gradle.actions.BuildsToPathsMapper;
import com.android.tools.idea.gradle.project.build.invoker.AssembleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvokerKt;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildResult;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class GoToApkLocationTask {
    public static final String ANALYZE = "analyze:";
    public static final String MODULE = "module:";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<Module> myModules;
    @NotNull
    private final String myNotificationTitle;
    @NotNull
    private final List<String> myBuildVariants;

    public GoToApkLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle) {
        this(project, modules, notificationTitle, Collections.emptyList());
    }

    public GoToApkLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle, @NotNull List<String> buildVariants) {
        this.myProject = project;
        this.myModules = modules;
        this.myNotificationTitle = notificationTitle;
        this.myBuildVariants = buildVariants;
    }

    public void executeWhenBuildFinished(@NotNull ListenableFuture<AssembleInvocationResult> resultFuture) {
        GradleBuildInvokerKt.whenFinished(resultFuture, MoreExecutors.directExecutor(), result2 -> {
            BuildsToPathsMapper buildsToPathsMapper = BuildsToPathsMapper.getInstance(this.myProject);
            Map<String, File> apkBuildsToPaths = buildsToPathsMapper.getBuildsToPaths((AssembleInvocationResult)result2, this.myBuildVariants, this.myModules, false);
            this.showNotification((GradleBuildResult)result2, apkBuildsToPaths);
            return null;
        });
    }

    private void showNotification(@NotNull GradleBuildResult result2, @NotNull Map<String, File> apkBuildsToPaths) {
        boolean isSigned;
        AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
        boolean bl = isSigned = !this.myBuildVariants.isEmpty();
        if (result2.isBuildSuccessful()) {
            StringBuilder builder2 = new StringBuilder();
            int count2 = apkBuildsToPaths.size();
            builder2.append("APK(s) generated successfully for ");
            if (isSigned) {
                String moduleName2 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
                builder2.append("module '").append(moduleName2).append("' with ").append(count2).append(count2 == 1 ? " build variant" : " build variants");
            } else {
                builder2.append(count2).append(count2 == 1 ? " module" : " modules");
            }
            builder2.append(":<br/>");
            if (this.isShowFilePathActionSupported()) {
                Iterator<String> iterator2 = apkBuildsToPaths.keySet().iterator();
                while (iterator2.hasNext()) {
                    String moduleOrBuildVariant = iterator2.next();
                    if (isSigned) {
                        builder2.append("Build variant '");
                    } else {
                        builder2.append("Module '");
                    }
                    builder2.append(moduleOrBuildVariant).append("': ");
                    builder2.append("<a href=\"").append(MODULE).append(moduleOrBuildVariant).append("\">locate</a> or ");
                    builder2.append("<a href=\"").append(ANALYZE).append(moduleOrBuildVariant).append("\">analyze</a> the APK.");
                    if (!iterator2.hasNext()) continue;
                    builder2.append("<br/>");
                }
                String text2 = builder2.toString();
                notification.showBalloon(this.myNotificationTitle, text2, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(apkBuildsToPaths, this.myProject));
            } else {
                builder2.append(apkBuildsToPaths.entrySet().stream().map(entry -> String.format(" - %s: %s", entry.getKey(), ((File)entry.getValue()).getPath())).collect(Collectors.joining("\n")));
                StringBuilder balloonBuilder = new StringBuilder();
                balloonBuilder.append("APK(s) generated successfully for ");
                if (isSigned) {
                    String moduleName3 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
                    balloonBuilder.append("module '").append(moduleName3).append("' with ").append(count2).append(count2 == 1 ? " build variant" : " build variants");
                } else {
                    balloonBuilder.append(count2).append(count2 == 1 ? " module" : " modules");
                }
                notification.showBalloon(this.myNotificationTitle, balloonBuilder.toString(), NotificationType.INFORMATION, new OpenEventLogHyperlink());
                notification.addLogEvent(this.myNotificationTitle, builder2.toString(), NotificationType.INFORMATION);
            }
        } else if (result2.isBuildCancelled()) {
            notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
        } else {
            String msg = "Errors while building APK. You can find the errors in the 'Messages' view.";
            notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
        }
    }

    @VisibleForTesting
    boolean isShowFilePathActionSupported() {
        return RevealFileAction.isSupported();
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Map<String, File> myApkPathsPerModule;
        @NotNull
        private final Project myProject;

        OpenFolderNotificationListener(@NotNull Map<String, File> apkPathsPerModule, @NotNull Project project) {
            this.myApkPathsPerModule = apkPathsPerModule;
            this.myProject = project;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            String description2 = e.getDescription();
            if (description2.startsWith(GoToApkLocationTask.ANALYZE)) {
                VirtualFile apk;
                File apkPath = this.myApkPathsPerModule.get(description2.substring(GoToApkLocationTask.ANALYZE.length()));
                if (apkPath.isFile()) {
                    apk = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(apkPath);
                } else {
                    FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select APK to analyze").withFileFilter(file2 -> ApkFileSystem.EXTENSIONS.contains(file2.getExtension()));
                    apk = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)LocalFileSystem.getInstance().findFileByIoFile(apkPath));
                }
                if (apk != null) {
                    OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, apk);
                    FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
                }
            } else if (description2.startsWith(GoToApkLocationTask.MODULE)) {
                File apkPath = this.myApkPathsPerModule.get(description2.substring(GoToApkLocationTask.MODULE.length()));
                assert (apkPath != null);
                if (apkPath.isFile()) {
                    apkPath = apkPath.getParentFile();
                }
                RevealFileAction.openDirectory((File)apkPath);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myApkPathsPerModule, listener2.myApkPathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myApkPathsPerModule);
        }
    }

    @VisibleForTesting
    static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show APK path(s) in the '" + ActionCenter.getToolwindowName() + "' view");
        }

        protected void execute(@NotNull Project project) {
            ToolWindow tw = ActionCenter.getToolwindow((Project)project);
            if (tw != null) {
                tw.activate(null, false);
            }
        }

        public int hashCode() {
            return Objects.hash(this.getUrl(), this.toHtml());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenEventLogHyperlink other = (OpenEventLogHyperlink)((Object)o);
            return this.getUrl().equals(other.getUrl()) && this.toHtml().equals(other.toHtml());
        }
    }
}

