/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildBundleAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build Bundle(s)";

    public BuildBundleAction() {
        super(ACTION_TEXT);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled2 = (Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get() != false && BuildBundleAction.isProjectBuildWithGradle(project);
        e.getPresentation().setEnabledAndVisible(enabled2);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (BuildBundleAction.isProjectBuildWithGradle(project)) {
            List<Module> appModules = GradleProjectSystemUtil.getAppHolderModulesSupportingBundleTask(project);
            if (appModules.size() > 0) {
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
                GoToBundleLocationTask task2 = new GoToBundleLocationTask(project, appModules, ACTION_TEXT);
                Module[] modulesToBuild = appModules.toArray(Module.EMPTY_ARRAY);
                task2.executeWhenBuildFinished(gradleBuildInvoker.bundle(modulesToBuild));
            } else {
                AndroidNotification.getInstance(project).showBalloon(ACTION_TEXT, "No modules supporting bundles found", NotificationType.ERROR);
            }
        }
    }

    private static boolean isProjectBuildWithGradle(@Nullable Project project) {
        return project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }
}

