/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.gradle.model.ArtifactIdentifier;
import com.android.ide.gradle.model.artifacts.AdditionalClassifierArtifacts;
import com.android.ide.gradle.model.artifacts.AdditionalClassifierArtifactsModel;
import com.android.tools.idea.gradle.project.sync.AdditionalClassifierArtifactsModelCollectorKt;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class LibraryFilePaths {
    @NotNull
    private final Map<String, ArtifactPaths> myPathsMap = new HashMap<String, ArtifactPaths>();
    private static final Pattern gradleCachePattern = Pattern.compile("^[a-f0-9]{30,48}$");
    @NotNull
    public static final String NAME_PREFIX = GradleConstants.SYSTEM_ID.getReadableName() + ": ";

    public void populate(@NotNull AdditionalClassifierArtifactsModel artifacts) {
        for (AdditionalClassifierArtifacts artifact : artifacts.getArtifacts()) {
            this.myPathsMap.computeIfAbsent(AdditionalClassifierArtifactsModelCollectorKt.idToString((ArtifactIdentifier)artifact.getId()), k -> new ArtifactPaths(artifact));
        }
    }

    public Collection<String> retrieveCachedLibs() {
        return new HashSet<String>(this.myPathsMap.keySet());
    }

    @NotNull
    public static LibraryFilePaths getInstance(@NotNull Project project) {
        return (LibraryFilePaths)project.getService(LibraryFilePaths.class);
    }

    @Nullable
    public ArtifactPaths getCachedPathsForArtifact(@NotNull String libraryName) {
        String libraryId = LibraryFilePaths.getLibraryId(libraryName);
        return this.myPathsMap.getOrDefault(libraryId, null);
    }

    @NotNull
    static String getLibraryId(@NotNull String libraryName) {
        if (libraryName.startsWith(NAME_PREFIX)) {
            libraryName = libraryName.substring(NAME_PREFIX.length());
        }
        if (libraryName.contains("@")) {
            libraryName = libraryName.substring(0, libraryName.indexOf(64));
        }
        return libraryName.trim();
    }

    @Nullable
    public File findPomPathForLibrary(@NotNull String libraryName, @NotNull File libraryPath) {
        String libraryId = LibraryFilePaths.getLibraryId(libraryName);
        if (this.myPathsMap.containsKey(libraryId)) {
            return this.myPathsMap.get((Object)libraryId).pom;
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, ".pom", false);
    }

    @Nullable
    public static File findArtifactFilePathInRepository(@NotNull File libraryPath, @NotNull String fileNameSuffix, boolean searchInIdeCache) {
        File librarySourceDirPath;
        File sourceJarPath;
        if (!libraryPath.isFile()) {
            return null;
        }
        File parentPath = libraryPath.getParentFile();
        String name2 = FileUtil.getNameWithoutExtension((File)libraryPath);
        String sourceFileName = name2 + fileNameSuffix;
        if (parentPath != null) {
            File sourceJar = LibraryFilePaths.findChildPath(parentPath, sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parentPath = parentPath.getParentFile()) != null) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
            if ((parentPath = libraryPath.getParentFile()) != null && gradleCachePattern.matcher(parentPath.getName()).matches() && (parentPath = parentPath.getParentFile()) != null && parentPath.getParentFile() != null && libraryPath.getName().startsWith(parentPath.getParentFile().getName())) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || !gradleCachePattern.matcher(child.getName()).matches() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        if (searchInIdeCache && (sourceJarPath = new File(librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir(), sourceFileName)).isFile()) {
            return sourceJarPath;
        }
        return null;
    }

    @Nullable
    private static File findChildPath(@NotNull File parentPath, @NotNull String childName) {
        for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
            if (!childName.equals(child.getName())) continue;
            return child.isFile() ? child : null;
        }
        return null;
    }

    public static class ArtifactPaths {
        @Nullable
        public final File javaDoc;
        @Nullable
        public final File sources;
        @Nullable
        public final File pom;
        @Nullable
        public final File sampleSource;

        private ArtifactPaths(AdditionalClassifierArtifacts artifact) {
            this.javaDoc = artifact.getJavadoc();
            this.sources = artifact.getSources();
            this.pom = artifact.getMavenPom();
            this.sampleSource = artifact.getSampleSources();
        }
    }
}

