/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SystemFonts {
    private static final int CONDENSED_WIDTH = 75;
    private final Map<String, FontFamily> myFonts;

    public SystemFonts(@NotNull DownloadableFontCacheServiceImpl service) {
        this.myFonts = SystemFonts.createFonts(service);
    }

    @NotNull
    public Collection<FontFamily> getFontFamilies() {
        return this.myFonts.values();
    }

    @Nullable
    public FontFamily getFont(String name2) {
        return this.myFonts.get(name2);
    }

    private static Map<String, FontFamily> createFonts(@NotNull DownloadableFontCacheServiceImpl service) {
        TreeMap<String, FontFamily> fonts = new TreeMap<String, FontFamily>();
        for (String fontName : AndroidDomUtil.AVAILABLE_FAMILIES) {
            FontFamily family = SystemFonts.createFont(service, fontName);
            if (family == null) continue;
            fonts.put(fontName, family);
        }
        return fonts;
    }

    @Nullable
    private static FontFamily createFont(@NotNull DownloadableFontCacheServiceImpl service, @NotNull String systemFontName) {
        switch (systemFontName) {
            case "sans-serif-thin": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 100, 400);
            }
            case "sans-serif-light": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 300, 700);
            }
            case "sans-serif": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 400, 700);
            }
            case "sans-serif-medium": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 500, 900);
            }
            case "sans-serif-black": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 900);
            }
            case "sans-serif-condensed-light": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 75, 300, 700);
            }
            case "sans-serif-condensed": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 75, 400, 700);
            }
            case "sans-serif-condensed-medium": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 75, 400, 700);
            }
            case "serif": {
                return SystemFonts.findFont(service, systemFontName, "Noto Serif", 100, 400, 700);
            }
            case "monospace": {
                return SystemFonts.findFont(service, systemFontName, "Droid Sans Mono", 100, 400);
            }
            case "serif-monospace": {
                return SystemFonts.findFont(service, systemFontName, "Cutive Mono", 100, 400);
            }
            case "casual": {
                return SystemFonts.findFont(service, systemFontName, "Coming Soon", 100, 400);
            }
            case "cursive": {
                return SystemFonts.findFont(service, systemFontName, "Dancing Script", 100, 400, 700);
            }
            case "sans-serif-smallcaps": {
                return SystemFonts.findFont(service, systemFontName, "Carrois Gothic SC", 100, 400);
            }
        }
        return null;
    }

    @Nullable
    private static FontFamily findFont(@NotNull DownloadableFontCacheServiceImpl service, @NotNull String systemFontName, @NotNull String name2, int width, int ... weights) {
        FontFamily family = service.findFont(FontProvider.GOOGLE_PROVIDER, name2);
        if (family == null) {
            return null;
        }
        List filtered = family.getFonts().stream().filter(font -> font.getWidth() == width && Ints.contains((int[])weights, (int)font.getWeight())).map(FontDetail::toMutableFontDetail).collect(Collectors.toList());
        MutableFontDetail wanted = new MutableFontDetail(400, width, false);
        FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
        if (best == null) {
            return null;
        }
        return new FontFamily(FontProvider.GOOGLE_PROVIDER, FontSource.SYSTEM, systemFontName, best.getFontUrl(), "", filtered);
    }
}

