/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.FontFamilyParser;
import com.android.tools.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFonts {
    private final DownloadableFontCacheService myService = DownloadableFontCacheService.getInstance();
    private final ResourceRepositoryManager myResourceRepository;
    private final Map<String, FontFamily> myProjectFonts;
    private final Map<String, QueryParser.ParseResult> myParseResults;
    private final List<String> myDefinitions;

    public ProjectFonts(@NotNull ResourceRepositoryManager resourceRepositoryManager) {
        this.myResourceRepository = resourceRepositoryManager;
        this.myProjectFonts = new TreeMap<String, FontFamily>();
        this.myParseResults = new HashMap<String, QueryParser.ParseResult>();
        this.myDefinitions = new ArrayList<String>();
    }

    @NotNull
    public List<FontFamily> getFonts() {
        ArrayList<FontFamily> fonts = new ArrayList<FontFamily>();
        ListMultimap fontResources = this.myResourceRepository.getProjectResources().getResources(ResourceNamespace.TODO(), ResourceType.FONT);
        List names = fontResources.keySet().stream().sorted().collect(Collectors.toList());
        for (String name2 : names) {
            fonts.add(this.resolveFont("@font/" + name2));
        }
        return fonts;
    }

    @NotNull
    public FontFamily getFont(@NotNull String name2) {
        return this.resolveFont(name2);
    }

    @Nullable
    public String getErrorMessage(@Nullable FontFamily family) {
        if (family == null || !family.getMenu().isEmpty()) {
            return null;
        }
        String name2 = "@font/" + family.getName();
        this.analyzeFont(name2);
        if (this.hasCircularReferences(name2)) {
            return "The font: \"" + family.getName() + "\" has a circular definition";
        }
        return "The font: \"" + family.getName() + "\" has an error in the definition";
    }

    @NotNull
    private FontFamily resolveFont(@NotNull String name2) {
        this.analyzeFont(name2);
        FontFamily resolvedFamily = this.myProjectFonts.get(name2);
        if (resolvedFamily != null) {
            return resolvedFamily;
        }
        if (ProjectFonts.isSystemFont(name2)) {
            FontFamily family = this.myService.getSystemFont(name2);
            if (family == null) {
                family = this.myService.getDefaultSystemFont();
            }
            return family;
        }
        QueryParser.ParseResult result2 = this.myParseResults.get(name2);
        if (result2 instanceof QueryParser.DownloadableParseResult) {
            return this.resolveDownloadableFont(name2, (QueryParser.DownloadableParseResult)result2);
        }
        if (result2 instanceof FontFamilyParser.CompoundFontResult) {
            return this.resolveCompoundFont(name2, (FontFamilyParser.CompoundFontResult)result2);
        }
        return this.createUnresolvedFontFamily(name2);
    }

    private FontFamily resolveDownloadableFont(@NotNull String name2, @NotNull QueryParser.DownloadableParseResult result2) {
        String authority = result2.getAuthority();
        ArrayList<FontDetail> details = new ArrayList<FontDetail>();
        Iterator iterator2 = result2.getFonts().asMap().entrySet().iterator();
        while (iterator2.hasNext()) {
            FontProvider provider2 = new FontProvider("", authority, "", "", "", "");
            Map.Entry entry = iterator2.next();
            String fontName = (String)entry.getKey();
            FontFamily family = this.myService.findFont(provider2, fontName);
            if (family == null) {
                return this.createUnresolvedFontFamily(name2);
            }
            for (MutableFontDetail wanted : (Collection)entry.getValue()) {
                FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
                if (best == null) {
                    return this.createUnresolvedFontFamily(name2);
                }
                if (details.indexOf(best) >= 0) continue;
                details.add(best);
            }
        }
        if (details.isEmpty()) {
            return this.createUnresolvedFontFamily(name2);
        }
        return this.createSynonym(name2, details);
    }

    private FontFamily resolveCompoundFont(@NotNull String name2, @NotNull FontFamilyParser.CompoundFontResult result2) {
        if (this.hasCircularReferences(name2)) {
            return this.createUnresolvedFontFamily(name2);
        }
        ArrayList<FontDetail> fonts = new ArrayList<FontDetail>();
        for (Map.Entry<String, MutableFontDetail> font : result2.getFonts().entrySet()) {
            String dependency = font.getKey();
            MutableFontDetail wanted = font.getValue();
            FontFamily family = this.resolveFont(dependency);
            if (family.getMenu().isEmpty()) {
                return this.createUnresolvedFontFamily(name2);
            }
            FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
            assert (best != null);
            best = new FontDetail(best, wanted);
            fonts.add(best);
        }
        return this.createCompoundFamily(name2, fonts);
    }

    private void analyzeFont(@NotNull String name2) {
        if (this.isKnownFont(name2)) {
            return;
        }
        ListMultimap fonts = this.myResourceRepository.getAppResources().getResources(ResourceNamespace.TODO(), ResourceType.FONT);
        String fontName = StringUtil.trimStart((String)name2, (String)"@font/");
        if (!fonts.keySet().contains(fontName)) {
            this.createUnresolvedFontFamily(name2);
            return;
        }
        List items2 = fonts.get((Object)fontName);
        ResourceValue resourceValue = items2.stream().map(item2 -> item2.getResourceValue()).findFirst().orElse(null);
        if (resourceValue == null) {
            return;
        }
        String value2 = resourceValue.getValue();
        if (value2 == null) {
            this.createUnresolvedFontFamily(name2);
            return;
        }
        if (value2.endsWith(".xml")) {
            File fontFile = new File(value2);
            if (!fontFile.exists()) {
                this.createUnresolvedFontFamily(name2);
                return;
            }
            QueryParser.ParseResult result2 = FontFamilyParser.parseFontFamily(fontFile);
            if (result2 instanceof FontFamilyParser.ParseErrorResult) {
                this.createUnresolvedFontFamily(name2);
                return;
            }
            this.myParseResults.put(name2, result2);
            if (result2 instanceof FontFamilyParser.CompoundFontResult) {
                FontFamilyParser.CompoundFontResult compoundResult = (FontFamilyParser.CompoundFontResult)result2;
                for (String font : compoundResult.getFonts().keySet()) {
                    this.analyzeFont(font);
                }
            }
            return;
        }
        this.createEmbeddedFontFamily(name2, value2);
    }

    private boolean isKnownFont(@NotNull String name2) {
        return ProjectFonts.isSystemFont(name2) || this.myProjectFonts.containsKey(name2) || this.myParseResults.containsKey(name2);
    }

    private static boolean isSystemFont(@NotNull String name2) {
        return !name2.startsWith("@font/");
    }

    private boolean hasCircularReferences(@NotNull String name2) {
        this.myDefinitions.clear();
        this.myDefinitions.add(name2);
        return this.checkDependencies(name2);
    }

    private boolean checkDependencies(@NotNull String name2) {
        QueryParser.ParseResult result2 = this.myParseResults.get(name2);
        if (result2 == null) {
            return false;
        }
        int dept = this.myDefinitions.size();
        if (result2 instanceof FontFamilyParser.CompoundFontResult) {
            FontFamilyParser.CompoundFontResult compoundResult = (FontFamilyParser.CompoundFontResult)result2;
            for (String dependency : compoundResult.getFonts().keySet()) {
                this.myDefinitions.subList(dept, this.myDefinitions.size()).clear();
                if (this.myDefinitions.contains(dependency)) {
                    return true;
                }
                this.myDefinitions.add(dependency);
                if (!this.checkDependencies(dependency)) continue;
                return true;
            }
        }
        return false;
    }

    private void createEmbeddedFontFamily(@NotNull String name2, @NotNull String fileName) {
        String fontName = StringUtil.trimStart((String)name2, (String)"@font/");
        String fileUrl = "file://" + fileName;
        MutableFontDetail detail = new MutableFontDetail(400, 100, false, fileUrl, "", false, false);
        FontFamily family = new FontFamily(FontProvider.EMPTY_PROVIDER, FontSource.PROJECT, fontName, fileUrl, "", Collections.singletonList(detail));
        this.myProjectFonts.put(name2, family);
    }

    private FontFamily createUnresolvedFontFamily(@NotNull String name2) {
        String fontName = StringUtil.trimStart((String)name2, (String)"@font/");
        MutableFontDetail detail = new MutableFontDetail(400, 100, false);
        FontFamily family = new FontFamily(FontProvider.EMPTY_PROVIDER, FontSource.PROJECT, fontName, "", "", Collections.singletonList(detail));
        this.myProjectFonts.put(name2, family);
        return family;
    }

    private FontFamily createSynonym(@NotNull String name2, @NotNull List<FontDetail> details) {
        assert (!details.isEmpty());
        MutableFontDetail wanted = new MutableFontDetail(400, 100, false);
        FontDetail best = wanted.findBestMatch(details);
        assert (best != null);
        FontProvider provider2 = best.getFamily().getProvider();
        String fontName = StringUtil.trimStart((String)name2, (String)"@font/");
        FontFamily family = new FontFamily(provider2, FontSource.PROJECT, fontName, best.getFontUrl(), "", ImmutableList.copyOf(details));
        this.myProjectFonts.put(name2, family);
        return family;
    }

    private FontFamily createCompoundFamily(@NotNull String name2, @NotNull List<FontDetail> fonts) {
        assert (!fonts.isEmpty());
        String fontName = StringUtil.trimStart((String)name2, (String)"@font/");
        MutableFontDetail wanted = new MutableFontDetail(400, 100, false);
        FontDetail best = wanted.findBestMatch(fonts);
        assert (best != null);
        FontFamily original = best.getFamily();
        FontFamily family = new FontFamily(original.getProvider(), FontSource.PROJECT, fontName, original.getMenu(), "", ImmutableList.copyOf(fonts));
        this.myProjectFonts.put(name2, family);
        return family;
    }
}

