/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.io.HttpRequests;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFileDownloader {
    private static final Logger LOG = Logger.getInstance(FontFileDownloader.class);
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;

    public FontFileDownloader(@NotNull List<? extends DownloadableFileDescription> fileDescriptions) {
        this.myFileDescriptions = fileDescriptions;
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(@NotNull File targetDir) throws IOException {
        List<Pair<File, DownloadableFileDescription>> downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        }
        try {
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(AndroidBundle.message("progress.downloading.0.files.text", this.myFileDescriptions.size()));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start2 = System.currentTimeMillis();
            ExecutorService executor2 = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileDownloaderImpl pool", (int)maxParallelDownloads);
            ArrayList<Future<Void>> results2 = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results2.add(executor2.submit(() -> {
                    SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator();
                    indicator.checkCanceled();
                    File existing2 = new File(targetDir, description2.getDefaultFileName());
                    String url = description2.getDownloadUrl();
                    if (url.startsWith(LIB_SCHEMA)) {
                        String path2 = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)LIB_SCHEMA));
                        File file2 = PathManager.findFileInLibDirectory((String)path2);
                        existingFiles.add(Pair.create((Object)file2, (Object)description2));
                    } else if (url.startsWith("file://")) {
                        String path3 = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                        File file3 = new File(path3);
                        if (file3.exists()) {
                            existingFiles.add(Pair.create((Object)file3, (Object)description2));
                        }
                    } else {
                        File downloaded;
                        try {
                            downloaded = FontFileDownloader.downloadFile(description2, existing2, (ProgressIndicator)indicator);
                        }
                        catch (IOException e) {
                            throw new IOException(AndroidBundle.message("error.file.download.failed", description2.getDownloadUrl(), e.getMessage()), e);
                        }
                        if (FileUtil.filesEqual((File)downloaded, (File)existing2)) {
                            existingFiles.add(Pair.create((Object)existing2, (Object)description2));
                        } else {
                            totalSize.addAndGet(downloaded.length());
                            downloadedFiles.add(Pair.create((Object)downloaded, (Object)description2));
                        }
                    }
                    indicator.finished();
                    return null;
                }));
            }
            for (Future future2 : results2) {
                try {
                    future2.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)e.getCause();
                    }
                    LOG.error((Throwable)e);
                }
            }
            long duration2 = System.currentTimeMillis() - start2;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration2) + "(" + duration2 + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FontFileDownloader.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            return localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            FontFileDownloader.deleteFiles(downloadedFiles);
            throw e;
        }
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<Pair<File, DownloadableFileDescription>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result2 = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
            DownloadableFileDescription description2 = (DownloadableFileDescription)pair.getSecond();
            String fileName = description2.generateFileName(s -> !new File(targetDir, (String)s).exists());
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result2.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description2));
        }
        return result2;
    }

    private static void deleteFiles(List<Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair : pairs) {
            FileUtil.delete((File)((File)pair.getFirst()));
        }
    }

    @NotNull
    private static File downloadFile(@NotNull DownloadableFileDescription description2, @NotNull File existingFile, @NotNull ProgressIndicator indicator) throws IOException {
        try {
            return FontFileDownloader.downloadFile(description2, existingFile, indicator, true);
        }
        catch (IOException ex) {
            return FontFileDownloader.downloadFile(description2, existingFile, indicator, false);
        }
    }

    @NotNull
    private static File downloadFile(final @NotNull DownloadableFileDescription description2, final @NotNull File existingFile, final @NotNull ProgressIndicator indicator, boolean compressed) throws IOException {
        final String presentableUrl = description2.getPresentableDownloadUrl();
        indicator.setText2(AndroidBundle.message("progress.connecting.to.download.file.text", presentableUrl));
        indicator.setIndeterminate(true);
        return (File)HttpRequests.request((String)description2.getDownloadUrl()).gzip(compressed).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request2) throws IOException {
                int size = request2.getConnection().getContentLength();
                if (existingFile.exists() && (long)size == existingFile.length()) {
                    return existingFile;
                }
                indicator.setText2(AndroidBundle.message("progress.download.file.text", description2.getPresentableFileName(), presentableUrl));
                return request2.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp"), indicator);
            }
        });
    }

    private static class ConcurrentTasksProgressManager {
        private final ProgressIndicator myParent;
        private final int myTasksCount;
        private final AtomicDouble myTotalFraction;
        private final Object myLock = new Object();
        private final Object2ObjectLinkedOpenHashMap<SubTaskProgressIndicator, String> myText2Stack = new Object2ObjectLinkedOpenHashMap();

        private ConcurrentTasksProgressManager(ProgressIndicator parent2, int tasksCount) {
            this.myParent = parent2;
            this.myTasksCount = tasksCount;
            this.myTotalFraction = new AtomicDouble();
        }

        public void updateFraction(double delta) {
            this.myTotalFraction.addAndGet(delta / (double)this.myTasksCount);
            this.myParent.setFraction(this.myTotalFraction.get());
        }

        public SubTaskProgressIndicator createSubTaskIndicator() {
            return new SubTaskProgressIndicator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text2) {
            if (text2 != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.put((Object)subTask, (Object)text2);
                }
                this.myParent.setText2(text2);
            } else {
                String prev;
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.remove((Object)subTask);
                    prev = this.myText2Stack.isEmpty() ? null : (String)this.myText2Stack.get(this.myText2Stack.lastKey());
                }
                if (prev != null) {
                    this.myParent.setText2(prev);
                }
            }
        }
    }

    private static class SubTaskProgressIndicator
    extends SensitiveProgressWrapper {
        private final AtomicDouble myFraction;
        private final ConcurrentTasksProgressManager myProgressManager;

        private SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager) {
            super(progressManager.myParent);
            this.myProgressManager = progressManager;
            this.myFraction = new AtomicDouble();
        }

        public void setFraction(double newValue) {
            double oldValue = this.myFraction.getAndSet(newValue);
            this.myProgressManager.updateFraction(newValue - oldValue);
        }

        public void setIndeterminate(boolean indeterminate) {
            if (this.myProgressManager.myTasksCount > 1) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }

        public void setText2(String text2) {
            this.myProgressManager.setText2(this, text2);
        }

        public double getFraction() {
            return this.myFraction.get();
        }

        public void finished() {
            this.setFraction(1.0);
            this.myProgressManager.setText2(this, null);
        }
    }
}

