/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fileTypes;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.FlagManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        ProjectFileIndex projectFileIndex;
        Module module2;
        Project project;
        PsiDirectory psiDirectory;
        VirtualFile virtualDirectory;
        if (element2 instanceof XmlFile) {
            FolderConfiguration config2;
            String parentName;
            int index2;
            VirtualFile file2 = ((XmlFile)element2).getVirtualFile();
            if (file2 == null) {
                return null;
            }
            if ("AndroidManifest.xml".equals(file2.getName())) {
                return StudioIcons.Shell.Filetree.MANIFEST_FILE;
            }
            VirtualFile parent2 = file2.getParent();
            if (parent2 != null && (index2 = (parentName = parent2.getName()).indexOf(45)) != -1 && (config2 = FolderConfiguration.getConfigForFolder((String)parentName)) != null && config2.getLocaleQualifier() != null && ResourceFolderType.getFolderType((String)parentName) != null) {
                return FlagManager.get().getFlag(config2);
            }
        }
        if (element2 instanceof PsiDirectory && ProjectRootsUtil.isModuleContentRoot((VirtualFile)(virtualDirectory = (psiDirectory = (PsiDirectory)element2).getVirtualFile()), (Project)(project = psiDirectory.getProject())) && (module2 = (projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).getModuleForFile(virtualDirectory)) != null && !module2.isDisposed() && ModuleSystemUtil.isLinkedAndroidModule(module2)) {
            return AndroidIconProvider.getModuleIcon(module2);
        }
        return null;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module2) {
        if (ModuleSystemUtil.isHolderModule(module2) || ModuleSystemUtil.isMainModule(module2)) {
            return AndroidIconProvider.getAndroidModuleIcon(ProjectSystemUtil.getModuleSystem(module2));
        }
        if (ModuleSystemUtil.isAndroidTestModule(module2)) {
            return StudioIcons.Shell.Filetree.ANDROID_MODULE;
        }
        return AllIcons.Nodes.Module;
    }

    @NotNull
    public static Icon getAndroidModuleIcon(@NotNull AndroidModuleSystem androidModuleSystem2) {
        return AndroidIconProvider.getAndroidModuleIcon(androidModuleSystem2.getType());
    }

    @NotNull
    public static Icon getAndroidModuleIcon(@NotNull AndroidModuleSystem.Type androidProjectType) {
        switch (androidProjectType) {
            case TYPE_NON_ANDROID: {
                return AllIcons.Nodes.Module;
            }
            case TYPE_APP: {
                return StudioIcons.Shell.Filetree.ANDROID_MODULE;
            }
            case TYPE_FEATURE: 
            case TYPE_DYNAMIC_FEATURE: {
                return StudioIcons.Shell.Filetree.FEATURE_MODULE;
            }
            case TYPE_INSTANTAPP: {
                return StudioIcons.Shell.Filetree.INSTANT_APPS;
            }
            case TYPE_LIBRARY: {
                return StudioIcons.Shell.Filetree.LIBRARY_MODULE;
            }
            case TYPE_TEST: {
                return StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT;
            }
        }
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }
}

