/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow.ui;

import com.android.tools.idea.file.explorer.toolwindow.ui.PopupMenuItem;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ComponentPopupMenu {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DefaultActionGroup myGroup;

    public ComponentPopupMenu(@NotNull JComponent component2) {
        this.myComponent = component2;
        this.myGroup = new DefaultActionGroup();
    }

    ComponentPopupMenu(@NotNull JComponent component2, @NotNull DefaultActionGroup group2) {
        this.myComponent = component2;
        this.myGroup = group2;
    }

    @NotNull
    public ActionGroup getActionGroup() {
        return this.myGroup;
    }

    public void install() {
        PopupHandler.installPopupMenu((JComponent)this.myComponent, (ActionGroup)this.myGroup, (String)"unknown");
    }

    public void addSeparator() {
        this.myGroup.addSeparator();
    }

    public ComponentPopupMenu addPopup(@NotNull String name2) {
        ComponentPopupMenu newMenu = new ComponentPopupMenu(this.myComponent, (DefaultActionGroup)new NonEmptyActionGroup());
        ActionGroup subGroup = newMenu.getActionGroup();
        subGroup.setPopup(true);
        subGroup.getTemplatePresentation().setText(name2);
        this.myGroup.add((AnAction)subGroup);
        return newMenu;
    }

    public void addItem(final @NotNull PopupMenuItem popupMenuItem) {
        Shortcut[] shortcuts;
        AnAction action2 = new AnAction(popupMenuItem.getIcon()){

            public void update(@NotNull AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setText(popupMenuItem.getText());
                presentation.setEnabled(popupMenuItem.isEnabled());
                presentation.setVisible(popupMenuItem.isVisible());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                popupMenuItem.run();
            }
        };
        String shortcutId = popupMenuItem.getShortcutId();
        if (!StringUtil.isEmpty((String)shortcutId)) {
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            Shortcut[] shortcuts2 = active.getShortcuts(shortcutId);
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts2), this.myComponent);
        }
        if ((shortcuts = popupMenuItem.getShortcuts()) != null && shortcuts.length > 0) {
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this.myComponent);
        }
        this.myGroup.add(action2);
    }
}

