/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow.adbimpl;

import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbFileListingEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileListingEntryBuilder {
    @Nullable
    private String myPath;
    @Nullable
    private AdbFileListingEntry.EntryKind myKind;
    @Nullable
    private String myPermissions;
    @Nullable
    private String myOwner;
    @Nullable
    private String myGroup;
    @Nullable
    private String myDate;
    @Nullable
    private String myTime;
    private long mySize;
    @Nullable
    private String myExtraInfo;

    public AdbFileListingEntryBuilder() {
    }

    public AdbFileListingEntryBuilder(@NotNull AdbFileListingEntry source) {
        this.myPath = source.getFullPath();
        this.myKind = source.getKind();
        this.myPermissions = source.getPermissions();
        this.myOwner = source.getOwner();
        this.myGroup = source.getGroup();
        this.myDate = source.getDate();
        this.myTime = source.getTime();
        this.mySize = source.getSize();
        this.myExtraInfo = source.getInfo();
    }

    public AdbFileListingEntry build() {
        if (this.myPath == null) {
            throw new IllegalStateException("Entry path must be set");
        }
        if (this.myKind == null) {
            throw new IllegalStateException("Entry kind must be set");
        }
        return new AdbFileListingEntry(this.myPath, this.myKind, this.myPermissions, this.myOwner, this.myGroup, this.myDate, this.myTime, Long.toString(this.mySize), this.myExtraInfo);
    }

    public AdbFileListingEntryBuilder setPath(@NotNull String path2) {
        this.myPath = path2;
        return this;
    }

    public AdbFileListingEntryBuilder setKind(@NotNull AdbFileListingEntry.EntryKind kind) {
        this.myKind = kind;
        return this;
    }

    public AdbFileListingEntryBuilder setPermissions(@Nullable String permissions) {
        this.myPermissions = permissions;
        return this;
    }

    public AdbFileListingEntryBuilder setOwner(@Nullable String owner) {
        this.myOwner = owner;
        return this;
    }

    public AdbFileListingEntryBuilder setGroup(@Nullable String group2) {
        this.myGroup = group2;
        return this;
    }

    public AdbFileListingEntryBuilder setDate(@Nullable String date) {
        this.myDate = date;
        return this;
    }

    public AdbFileListingEntryBuilder setTime(@Nullable String time2) {
        this.myTime = time2;
        return this;
    }

    public AdbFileListingEntryBuilder setSize(long size) {
        this.mySize = size;
        return this;
    }

    public AdbFileListingEntryBuilder setExtraInfo(@Nullable String extraInfo) {
        this.myExtraInfo = extraInfo;
        return this;
    }
}

