/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow;

import com.android.tools.idea.AndroidEnvironmentUtils;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerController;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerFileManager;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerModel;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbDeviceFileSystemRenderer;
import com.android.tools.idea.file.explorer.toolwindow.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.file.explorer.toolwindow.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SystemProperties;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    private static final String DEVICE_EXPLORER_ENABLED = "android.device.explorer.enabled";
    public static final String TOOL_WINDOW_ID = "Device File Explorer";

    public boolean isApplicable(@NotNull Project project) {
        return SystemProperties.getBooleanProperty((String)DEVICE_EXPLORER_ENABLED, (boolean)true) && AndroidEnvironmentUtils.isAndroidEnvironment((Project)project) && (Boolean)StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get() == false;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        AdbDeviceFileSystemService adbService2 = (AdbDeviceFileSystemService)project.getService(AdbDeviceFileSystemService.class);
        DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)project.getService(DeviceExplorerFileManager.class);
        DeviceExplorerModel model2 = new DeviceExplorerModel();
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, new AdbDeviceFileSystemRenderer(), model2);
        DeviceExplorerController controller2 = new DeviceExplorerController(project, model2, view, adbService2, fileManager, fileManager::openFile);
        controller2.setup();
        ContentManager contentManager = toolWindow.getContentManager();
        Content toolWindowContent = contentManager.getFactory().createContent(view.getComponent(), "", true);
        contentManager.addContent(toolWindowContent);
    }
}

