/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.file.explorer.toolwindow;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorerController;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DeviceExplorer {
    private DeviceExplorer() {
    }

    public static void openAndShowDevice(Project project, @NotNull AvdInfo avdInfo) {
        if (!DeviceExplorer.showToolWindow(project)) {
            return;
        }
        DeviceExplorerController controller2 = DeviceExplorerController.getProjectController(project);
        assert (controller2 != null);
        assert (AndroidDebugBridge.getBridge() != null);
        String avdName = avdInfo.getName();
        Optional<IDevice> optionalIDevice = Arrays.stream(AndroidDebugBridge.getBridge().getDevices()).filter(device2 -> avdName.equals(device2.getAvdName())).findAny();
        if (!optionalIDevice.isPresent()) {
            controller2.reportErrorFindingDevice("Unable to find AVD " + avdName + " by name. Please retry.");
            return;
        }
        controller2.selectActiveDevice(optionalIDevice.get().getSerialNumber());
    }

    public static void openAndShowDevice(Project project, @NotNull String serialNumber) {
        if (!DeviceExplorer.showToolWindow(project)) {
            return;
        }
        DeviceExplorerController controller2 = DeviceExplorerController.getProjectController(project);
        assert (controller2 != null);
        controller2.selectActiveDevice(serialNumber);
    }

    public static boolean showToolWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Device File Explorer");
        if (toolWindow != null) {
            toolWindow.show();
            return true;
        }
        return false;
    }
}

