/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.execution.common.AppRunConfiguration;
import com.android.tools.idea.execution.common.processhandler.DeviceAwareProcessHandler;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidRemoteDebugProcessHandler
extends DeviceAwareProcessHandler
implements SwappableProcessHandler {
    private final Project myProject;
    private final Client myClient;
    private final boolean myDetachIsDefault;

    public AndroidRemoteDebugProcessHandler(Project project, Client client2, boolean detachIsDefault) {
        this.myProject = project;
        this.myClient = client2;
        this.myDetachIsDefault = detachIsDefault;
        this.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, this);
    }

    public void startNotify() {
        final DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        DebugProcessListener listener2 = new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                debugProcess2.removeDebugProcessListener((DebugProcessListener)this);
                ScheduledFuture<?> future2 = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> AndroidRemoteDebugProcessHandler.this.notifyProcessDetached(), 1L, TimeUnit.SECONDS);
                Disposer.register((Disposable)AndroidRemoteDebugProcessHandler.this.myProject, () -> future2.cancel(false));
            }
        };
        debugProcess2.addDebugProcessListener(listener2);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess2.isDetached()) {
                debugProcess2.removeDebugProcessListener(listener2);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess2 != null) {
            debugProcess2.stop(false);
        }
        this.notifyProcessTerminated(0);
    }

    protected void detachProcessImpl() {
        DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess2 != null) {
            debugProcess2.stop(false);
        }
        this.myClient.notifyVmMirrorExited();
        this.notifyProcessDetached();
    }

    public boolean detachIsDefault() {
        return this.myDetachIsDefault;
    }

    public boolean isSilentlyDestroyOnClose() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    @Override
    @Nullable
    public Executor getExecutor() {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getExecutor();
    }

    @Override
    public boolean isRunningWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        boolean sameRunningApp;
        boolean bl = sameRunningApp = runConfiguration instanceof AppRunConfiguration && Objects.equals(this.myClient.getClientData().getPackageName(), ((AppRunConfiguration)runConfiguration).getAppId());
        if (!sameRunningApp) {
            return false;
        }
        if (executionTarget instanceof AndroidExecutionTarget) {
            IDevice device2 = this.myClient.getDevice();
            return ((AndroidExecutionTarget)executionTarget).getRunningDevices().stream().anyMatch(d -> d == device2);
        }
        return false;
    }

    public boolean isPackageRunning(@Nullable IDevice device2, @NotNull String packageName2) {
        return (device2 == null || device2 == this.myClient.getDevice()) && packageName2.equals(this.myClient.getClientData().getPackageName());
    }

    @Override
    public boolean isAssociated(@NotNull IDevice device2) {
        return device2 == this.myClient.getDevice();
    }
}

