/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManager;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManagerListener;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitor;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorKt;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorState;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorStateListener;
import com.android.tools.idea.execution.common.processhandler.TextEmitter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u001a\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012f\b\u0002\u0010\u000e\u001a`\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u00140\u000fj\u0002`\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\b\u0010 \u001a\u00020\rH\u0017J\u0012\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020\fH\u0007J\b\u0010\"\u001a\u00020\rH\u0007J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\b\u0010'\u001a\u00020&H\u0007J\u0010\u0010(\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\fH\u0003J\u0006\u0010)\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rl\u0010\u000e\u001a`\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u00140\u000fj\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager;", "Ljava/io/Closeable;", "targetApplicationId", "", "deploymentApplicationService", "Lcom/android/tools/idea/run/DeploymentApplicationService;", "textEmitter", "Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;", "listener", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;", "finishAndroidProcessCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "singleDeviceAndroidProcessMonitorFactory", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "targetDevice", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorStateListener;", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor;", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorFactory;", "(Ljava/lang/String;Lcom/android/tools/idea/run/DeploymentApplicationService;Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function4;)V", "myIsOnAllTargetProcessesTerminatedCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myMonitorListener", "com/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager$myMonitorListener$1", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager$myMonitorListener$1;", "myMonitors", "Ljava/util/concurrent/ConcurrentMap;", "add", "device", "close", "closeAndReplace", "detachAndClose", "detachDevice", "getMonitor", "isAssociated", "", "isEmpty", "remove", "start", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nAndroidProcessMonitorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProcessMonitorManager.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1851#2,2:183\n1851#2,2:185\n1851#2,2:187\n*S KotlinDebug\n*F\n+ 1 AndroidProcessMonitorManager.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager\n*L\n148#1:183,2\n158#1:185,2\n163#1:187,2\n*E\n"})
public final class AndroidProcessMonitorManager
implements Closeable {
    @NotNull
    private final String targetApplicationId;
    @NotNull
    private final DeploymentApplicationService deploymentApplicationService;
    @NotNull
    private final TextEmitter textEmitter;
    @NotNull
    private final AndroidProcessMonitorManagerListener listener;
    @NotNull
    private final Function4<String, IDevice, SingleDeviceAndroidProcessMonitorStateListener, DeploymentApplicationService, SingleDeviceAndroidProcessMonitor> singleDeviceAndroidProcessMonitorFactory;
    @NotNull
    private final ConcurrentMap<IDevice, SingleDeviceAndroidProcessMonitor> myMonitors;
    @NotNull
    private final AtomicBoolean myIsOnAllTargetProcessesTerminatedCalled;
    @NotNull
    private final myMonitorListener.1 myMonitorListener;

    public AndroidProcessMonitorManager(@NotNull String targetApplicationId, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull TextEmitter textEmitter, @NotNull AndroidProcessMonitorManagerListener listener2, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, @NotNull Function4<? super String, ? super IDevice, ? super SingleDeviceAndroidProcessMonitorStateListener, ? super DeploymentApplicationService, SingleDeviceAndroidProcessMonitor> singleDeviceAndroidProcessMonitorFactory) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        Intrinsics.checkNotNullParameter((Object)textEmitter, (String)"textEmitter");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter(singleDeviceAndroidProcessMonitorFactory, (String)"singleDeviceAndroidProcessMonitorFactory");
        this.targetApplicationId = targetApplicationId;
        this.deploymentApplicationService = deploymentApplicationService;
        this.textEmitter = textEmitter;
        this.listener = listener2;
        this.singleDeviceAndroidProcessMonitorFactory = singleDeviceAndroidProcessMonitorFactory;
        this.myMonitors = new ConcurrentHashMap();
        this.myIsOnAllTargetProcessesTerminatedCalled = new AtomicBoolean();
        this.myMonitorListener = new SingleDeviceAndroidProcessMonitorStateListener(this){
            final /* synthetic */ AndroidProcessMonitorManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull SingleDeviceAndroidProcessMonitor monitor, @NotNull SingleDeviceAndroidProcessMonitorState newState) {
                Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
                Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
                if (newState == SingleDeviceAndroidProcessMonitorState.PROCESS_NOT_FOUND) {
                    TextEmitter textEmitter = AndroidProcessMonitorManager.access$getTextEmitter$p(this.this$0);
                    String string = "Timed out waiting for process (" + monitor.getTargetApplicationId() + ") to appear on " + monitor.getTargetDevice().getName() + ".\n";
                    Key key = ProcessOutputTypes.STDOUT;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"STDOUT");
                    textEmitter.emit(string, key);
                }
                if (SingleDeviceAndroidProcessMonitorKt.isTerminalState(newState)) {
                    AndroidProcessMonitorManager.access$remove(this.this$0, monitor.getTargetDevice());
                }
            }
        };
    }

    public /* synthetic */ AndroidProcessMonitorManager(final String string, final DeploymentApplicationService deploymentApplicationService, final TextEmitter textEmitter, AndroidProcessMonitorManagerListener androidProcessMonitorManagerListener, Function1 function1, Function4 function4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function4 = (Function4)new Function4<String, IDevice, SingleDeviceAndroidProcessMonitorStateListener, DeploymentApplicationService, SingleDeviceAndroidProcessMonitor>((Function1<? super IDevice, Unit>)function1){
                final /* synthetic */ Function1<IDevice, Unit> $finishAndroidProcessCallback;
                {
                    this.$finishAndroidProcessCallback = $finishAndroidProcessCallback;
                    super(4);
                }

                @NotNull
                public final SingleDeviceAndroidProcessMonitor invoke(@NotNull String string2, @NotNull IDevice device2, @NotNull SingleDeviceAndroidProcessMonitorStateListener monitorListener, @NotNull DeploymentApplicationService deploymentApplicationService2) {
                    Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                    Intrinsics.checkNotNullParameter((Object)monitorListener, (String)"monitorListener");
                    Intrinsics.checkNotNullParameter((Object)deploymentApplicationService2, (String)"<anonymous parameter 3>");
                    return new SingleDeviceAndroidProcessMonitor(string, device2, monitorListener, deploymentApplicationService, textEmitter, this.$finishAndroidProcessCallback, null, null, 192, null);
                }
            };
        }
        this(string, deploymentApplicationService, textEmitter, androidProcessMonitorManagerListener, (Function1<? super IDevice, Unit>)function1, (Function4<? super String, ? super IDevice, ? super SingleDeviceAndroidProcessMonitorStateListener, ? super DeploymentApplicationService, SingleDeviceAndroidProcessMonitor>)function4);
    }

    @AnyThread
    public final void add(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitors.computeIfAbsent(device2, new Function(this, device2){
            final /* synthetic */ AndroidProcessMonitorManager this$0;
            final /* synthetic */ IDevice $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
            }

            public final SingleDeviceAndroidProcessMonitor apply(IDevice it) {
                return (SingleDeviceAndroidProcessMonitor)AndroidProcessMonitorManager.access$getSingleDeviceAndroidProcessMonitorFactory$p(this.this$0).invoke((Object)AndroidProcessMonitorManager.access$getTargetApplicationId$p(this.this$0), (Object)this.$device, (Object)AndroidProcessMonitorManager.access$getMyMonitorListener$p(this.this$0), (Object)AndroidProcessMonitorManager.access$getDeploymentApplicationService$p(this.this$0));
            }
        });
    }

    @WorkerThread
    @Nullable
    public final SingleDeviceAndroidProcessMonitor closeAndReplace(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitors.compute(device2, new BiFunction(this, device2){
            final /* synthetic */ AndroidProcessMonitorManager this$0;
            final /* synthetic */ IDevice $device;
            {
                this.this$0 = $receiver;
                this.$device = $device;
            }

            @Nullable
            public final SingleDeviceAndroidProcessMonitor apply(@NotNull IDevice iDevice, @Nullable SingleDeviceAndroidProcessMonitor monitorValue) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)iDevice, (String)"<anonymous parameter 0>");
                    SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor = monitorValue;
                    if (singleDeviceAndroidProcessMonitor == null) break block0;
                    singleDeviceAndroidProcessMonitor.replaceListenerAndClose(null);
                }
                return (SingleDeviceAndroidProcessMonitor)AndroidProcessMonitorManager.access$getSingleDeviceAndroidProcessMonitorFactory$p(this.this$0).invoke((Object)AndroidProcessMonitorManager.access$getTargetApplicationId$p(this.this$0), (Object)this.$device, (Object)AndroidProcessMonitorManager.access$getMyMonitorListener$p(this.this$0), (Object)AndroidProcessMonitorManager.access$getDeploymentApplicationService$p(this.this$0));
            }
        });
    }

    @WorkerThread
    public final void detachDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor = this.getMonitor(device2);
        if (singleDeviceAndroidProcessMonitor != null) {
            singleDeviceAndroidProcessMonitor.detachAndClose();
        }
        this.remove(device2);
    }

    @WorkerThread
    @Nullable
    public final SingleDeviceAndroidProcessMonitor getMonitor(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return (SingleDeviceAndroidProcessMonitor)this.myMonitors.get(device2);
    }

    @AnyThread
    public final boolean isAssociated(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return ((Map)this.myMonitors).containsKey(device2);
    }

    @AnyThread
    public final boolean isEmpty() {
        return this.myMonitors.isEmpty();
    }

    @WorkerThread
    private final void remove(IDevice device2) {
        if (this.myMonitors.remove(device2) != null && this.myMonitors.isEmpty() && this.myIsOnAllTargetProcessesTerminatedCalled.compareAndSet(false, true)) {
            this.listener.onAllTargetProcessesTerminated();
        }
    }

    @Override
    @WorkerThread
    public void close() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.close();
        }
        this.myMonitors.clear();
    }

    @WorkerThread
    public final void detachAndClose() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.detachAndClose();
        }
        this.close();
    }

    public final void start() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.start();
        }
    }

    public static final /* synthetic */ Function4 access$getSingleDeviceAndroidProcessMonitorFactory$p(AndroidProcessMonitorManager $this) {
        return $this.singleDeviceAndroidProcessMonitorFactory;
    }

    public static final /* synthetic */ String access$getTargetApplicationId$p(AndroidProcessMonitorManager $this) {
        return $this.targetApplicationId;
    }

    public static final /* synthetic */ myMonitorListener.1 access$getMyMonitorListener$p(AndroidProcessMonitorManager $this) {
        return $this.myMonitorListener;
    }

    public static final /* synthetic */ DeploymentApplicationService access$getDeploymentApplicationService$p(AndroidProcessMonitorManager $this) {
        return $this.deploymentApplicationService;
    }

    public static final /* synthetic */ TextEmitter access$getTextEmitter$p(AndroidProcessMonitorManager $this) {
        return $this.textEmitter;
    }

    public static final /* synthetic */ void access$remove(AndroidProcessMonitorManager $this, IDevice device2) {
        $this.remove(device2);
    }
}

