/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u001a0\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0001\u00a8\u0006\u0014"}, d2={"getClientWithAppId", "Lcom/android/ddmlib/Client;", "device", "Lcom/android/ddmlib/IDevice;", "appId", "", "showError", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/execution/ExecutionException;", "sessionName", "waitForClientReadyForDebug", "appIds", "", "pollTimeoutSeconds", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.execution.common"})
public final class UtilsKt {
    @WorkerThread
    @NotNull
    public static final Client waitForClientReadyForDebug(@NotNull IDevice device2, @NotNull Collection<String> appIds, long pollTimeoutSeconds, @NotNull ProgressIndicator indicator) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText("Waiting for processes " + CollectionsKt.joinToString$default((Iterable)appIds, null, null, null, (int)0, null, null, (int)63, null));
        Logger.getInstance((String)"waitForClientReadyForDebug").info("Waiting for clients " + appIds + " for " + pollTimeoutSeconds + " seconds");
        long startTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMillis <= TimeUnit.SECONDS.toMillis(pollTimeoutSeconds)) {
            indicator.checkCanceled();
            if (!device2.isOnline()) {
                throw new ExecutionException("Device is offline");
            }
            for (String appId : appIds) {
                Client client2 = UtilsKt.getClientWithAppId(device2, appId);
                if (client2 == null) continue;
                return client2;
            }
            Uninterruptibles.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        throw new ExecutionException("Processes " + CollectionsKt.joinToString$default((Iterable)appIds, null, null, null, (int)0, null, null, (int)63, null) + " are not found. Aborting session.");
    }

    public static /* synthetic */ Client waitForClientReadyForDebug$default(IDevice iDevice, Collection collection2, long l, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
        if ((n & 4) != 0) {
            l = 15L;
        }
        return UtilsKt.waitForClientReadyForDebug(iDevice, collection2, l, progressIndicator);
    }

    private static final Client getClientWithAppId(IDevice device2, String appId) {
        List<Client> clients = DeploymentApplicationService.Companion.getInstance().findClient(device2, appId);
        if (!((Collection)clients).isEmpty()) {
            Logger.getInstance((String)"waitForClientReadyForDebug").info("Found process " + appId);
            if (clients.size() > 1) {
                Logger.getInstance((String)"waitForClientReadyForDebug").info("Multiple clients with same application ID: " + appId);
            }
            Client client2 = clients.get(0);
            ClientData.DebuggerStatus debuggerStatus = client2.getClientData().getDebuggerConnectionStatus();
            switch (debuggerStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[debuggerStatus.ordinal()]) {
                case 1: {
                    return client2;
                }
                case 2: {
                    Locale locale = Locale.US;
                    String string = "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application";
                    Object[] objectArray = new Object[]{client2.getDebuggerListenPort()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                    String message2 = string2;
                    throw new ExecutionException(message2);
                }
                case 3: {
                    throw new ExecutionException("A debugger is already attached");
                }
                case 4: {
                    return null;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    public static final void showError(@NotNull Project project, @NotNull ExecutionException e, @NotNull String sessionName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Object[] objectArray = new Object[]{sessionName};
        ExecutionUtil.handleExecutionError((Project)project, (String)"Debug", (Throwable)e, (String)ExecutionBundle.message((String)"error.running.configuration.message", (Object[])objectArray), (String)e.getMessage(), Function.identity(), null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientData.DebuggerStatus.values().length];
            try {
                nArray[ClientData.DebuggerStatus.WAITING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientData.DebuggerStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientData.DebuggerStatus.ATTACHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientData.DebuggerStatus.DEFAULT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

