/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.tools.idea.execution.common.debug.utils.ProcessNameReader;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/execution/common/debug/utils/FacetFinder;", "", "()V", "findFacetForProcess", "Lorg/jetbrains/android/facet/AndroidFacet;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nFacetFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetFinder.kt\ncom/android/tools/idea/execution/common/debug/utils/FacetFinder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n359#2,7:154\n*S KotlinDebug\n*F\n+ 1 FacetFinder.kt\ncom/android/tools/idea/execution/common/debug/utils/FacetFinder\n*L\n99#1:154,7\n*E\n"})
public final class FacetFinder {
    @NotNull
    public static final FacetFinder INSTANCE = new FacetFinder();

    private FacetFinder() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AndroidFacet findFacetForProcess(@NotNull Project project, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Map processNameCache = new LinkedHashMap();
        List<AndroidFacet> holderFacets = ProjectSystemUtil.getAndroidFacets(project);
        for (AndroidFacet holderFacet : holderFacets) {
            Module module2;
            Module module3 = holderFacet.getMainModule();
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"holderFacet.mainModule");
            if (ModuleExtensionsKt.getAndroidFacet((Module)module3) != null) {
                boolean bl = false;
                try {
                    String facetPackageName;
                    AndroidFacet it;
                    Intrinsics.checkNotNullExpressionValue((Object)ProjectSystemUtil.getModuleSystem(it).getApplicationIdProvider().getPackageName(), (String)"it.getModuleSystem().get\u2026nIdProvider().packageName");
                    if (Intrinsics.areEqual((Object)processName, (Object)facetPackageName)) {
                        return it;
                    }
                    if (StringsKt.startsWith$default((String)processName, (String)(facetPackageName + ":"), (boolean)false, (int)2, null)) {
                        return it;
                    }
                }
                catch (ApkProvisionException facetPackageName) {
                }
            }
            if ((module2 = holderFacet.getAndroidTestModule()) != null && (module2 = ModuleExtensionsKt.getAndroidFacet((Module)module2)) != null) {
                Module it = module2;
                boolean bl = false;
                try {
                    String facetTestPackageName = ProjectSystemUtil.getModuleSystem((AndroidFacet)it).getApplicationIdProvider().getTestPackageName();
                    if (Intrinsics.areEqual((Object)processName, (Object)facetTestPackageName)) {
                        return it;
                    }
                    if (StringsKt.startsWith$default((String)processName, (String)(facetTestPackageName + ":"), (boolean)false, (int)2, null)) {
                        return it;
                    }
                }
                catch (ApkProvisionException facetTestPackageName) {
                }
            }
            Object[] objectArray = new Module[]{holderFacet.getMainModule(), holderFacet.getAndroidTestModule()};
            for (Module module4 : CollectionsKt.listOfNotNull((Object[])objectArray)) {
                Set dependentModules = new LinkedHashSet();
                ModuleUtilCore.getDependencies((Module)module4, (Set)dependentModules);
                for (Module dependentModule : dependentModules) {
                    List globalProcessNames;
                    Object object;
                    String key$iv;
                    void $this$getOrPut$iv;
                    AndroidFacet dependentAndroidFacet;
                    if (AndroidFacet.getInstance((Module)dependentModule) == null) continue;
                    Map map2 = processNameCache;
                    Intrinsics.checkNotNullExpressionValue((Object)dependentAndroidFacet.getHolderModule().getName(), (String)"dependentAndroidFacet.holderModule.name");
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        List<String> answer$iv = ProcessNameReader.INSTANCE.readGlobalProcessNames(dependentAndroidFacet);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    if (!(globalProcessNames = (List)object).contains(processName)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)module4, (String)"module");
                    return ModuleExtensionsKt.getAndroidFacet((Module)module4);
                }
            }
        }
        return null;
    }
}

