/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.impl.java;

import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.processhandler.AndroidRemoteDebugProcessHandler;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerGlobalSearchScope;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u000f\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/execution/common/debug/impl/java/AndroidJavaDebugEnvironment;", "Lcom/intellij/debugger/DebugEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "client", "Lcom/android/ddmlib/Client;", "mySessionName", "", "consoleViewToReuse", "Lcom/intellij/execution/ui/ConsoleView;", "detachIsDefault", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/ddmlib/Client;Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleView;Z)V", "myRemoteConnection", "Lcom/intellij/execution/configurations/RemoteConnection;", "searchScope", "Lcom/intellij/debugger/DebuggerGlobalSearchScope;", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "getPollTimeout", "", "getRemoteConnection", "getRunJre", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/annotations/Nullable;", "getSearchScope", "getSessionName", "isRemote", "intellij.android.execution.common"})
public final class AndroidJavaDebugEnvironment
implements DebugEnvironment {
    @NotNull
    private final Project project;
    @NotNull
    private final Client client;
    @NotNull
    private final String mySessionName;
    @Nullable
    private final ConsoleView consoleViewToReuse;
    private final boolean detachIsDefault;
    @NotNull
    private final RemoteConnection myRemoteConnection;
    @NotNull
    private final DebuggerGlobalSearchScope searchScope;

    public AndroidJavaDebugEnvironment(@NotNull Project project, @NotNull Client client2, @NotNull String mySessionName, @Nullable ConsoleView consoleViewToReuse, boolean detachIsDefault) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)mySessionName, (String)"mySessionName");
        this.project = project;
        this.client = client2;
        this.mySessionName = mySessionName;
        this.consoleViewToReuse = consoleViewToReuse;
        this.detachIsDefault = detachIsDefault;
        this.myRemoteConnection = new RemoteConnection(true, "localhost", String.valueOf(this.client.getDebuggerListenPort()), false);
        this.searchScope = new DebuggerGlobalSearchScope(GlobalSearchScope.allScope((Project)this.project), this.project);
    }

    @NotNull
    public DebuggerGlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @NotNull
    public ExecutionResult createExecutionResult() {
        ConsoleView consoleView = this.consoleViewToReuse;
        if (consoleView == null) {
            ConsoleView consoleView2 = TextConsoleBuilderFactory.getInstance().createBuilder(this.project).getConsole();
            consoleView = consoleView2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"getInstance().createBuilder(project).console");
        }
        ConsoleView console = consoleView;
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)console));
        AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(this.project, this.client, this.detachIsDefault);
        console.attachToProcess((ProcessHandler)debugProcessHandler);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)debugProcessHandler);
    }

    public boolean isRemote() {
        return true;
    }

    @NotNull
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    public long getPollTimeout() {
        return 0L;
    }

    @NotNull
    public String getSessionName() {
        return this.mySessionName;
    }

    @Nullable
    public Sdk getRunJre() {
        return ProjectRootManager.getInstance((Project)this.project).getProjectSdk();
    }
}

