/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.impl;

import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidDebuggerImplBase<S extends AndroidDebuggerState>
implements AndroidDebugger<S> {
    @NotNull
    protected static String getClientDebugPort(@NotNull Client client2) {
        return Integer.toString(client2.getDebuggerListenPort()).trim();
    }

    @Nullable
    protected static DebuggerSession findJdwpDebuggerSession(@NotNull Project project, @NotNull String debugPort) {
        for (DebuggerSession session2 : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            if (!debugPort.equals(session2.getProcess().getConnection().getDebuggerAddress().trim())) continue;
            return session2;
        }
        return null;
    }

    protected static boolean activateDebugSessionWindow(@NotNull Project project, @NotNull RunContentDescriptor descriptor2) {
        ProcessHandler processHandler2 = descriptor2.getProcessHandler();
        Content content2 = descriptor2.getAttachedContent();
        if (processHandler2 == null || content2 == null) {
            return false;
        }
        Executor executor2 = DefaultDebugExecutor.getDebugExecutorInstance();
        boolean processTerminated = processHandler2.isProcessTerminated();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (processTerminated) {
                RunContentManager.getInstance((Project)project).removeRunContent(executor2, descriptor2);
            } else {
                content2.getManager().setSelectedContent(content2);
                ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow(executor2.getToolWindowId());
                window2.activate(null, false, true);
            }
        });
        return !processTerminated;
    }

    @Override
    public boolean shouldBeDefault() {
        return false;
    }
}

