/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common;

import com.android.sdklib.AndroidVersion;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final String myExecutorId;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    @NotNull
    private final ExecutionTarget myExecutionTarget;

    @NotNull
    public static AndroidSessionInfo create(@NotNull ProcessHandler processHandler2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo result2 = new AndroidSessionInfo(processHandler2, runConfiguration, executorId, executionTarget);
        processHandler2.putUserData(KEY, (Object)result2);
        return result2;
    }

    private AndroidSessionInfo(@NotNull ProcessHandler processHandler2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull ExecutionTarget executionTarget) {
        this.myRunConfiguration = runConfiguration;
        this.myExecutorId = executorId;
        this.myExecutionTarget = executionTarget;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    @Nullable
    public Executor getExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(this.getExecutorId());
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myExecutionTarget;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    @Nullable
    public static List<AndroidSessionInfo> findActiveSession(@NotNull Project project) {
        return Arrays.stream(ExecutionManager.getInstance((Project)project).getRunningProcesses()).map(handler2 -> (AndroidSessionInfo)handler2.getUserData(KEY)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

